/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Delegates;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSummary;
import org.apache.iceberg.RollingManifestWriter;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptingFileIO;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableCommitReport;
import org.apache.iceberg.metrics.LoggingMetricsReporter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Queues;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.math.IntMath;
import org.apache.iceberg.util.Exceptions;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SnapshotProducer<ThisT>
implements SnapshotUpdate<ThisT> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotProducer.class);
    static final int MIN_FILE_GROUP_SIZE = 10000;
    static final Set<ManifestFile> EMPTY_SET = Sets.newHashSet();
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            SnapshotProducer.this.ops.io().deleteFile(file);
        }
    };
    private final LoadingCache<ManifestFile, ManifestFile> manifestsWithMetadata;
    private final TableOperations ops;
    private final boolean strictCleanup;
    private final boolean canInheritSnapshotId;
    private final String commitUUID = UUID.randomUUID().toString();
    private final AtomicInteger manifestCount = new AtomicInteger(0);
    private final AtomicInteger attempt = new AtomicInteger(0);
    private final List<String> manifestLists = Lists.newArrayList();
    private final long targetManifestSizeBytes;
    private MetricsReporter reporter = LoggingMetricsReporter.instance();
    private volatile Long snapshotId = null;
    private TableMetadata base;
    private boolean stageOnly = false;
    private Consumer<String> deleteFunc = this.defaultDelete;
    private ExecutorService workerPool;
    private String targetBranch = "main";
    private CommitMetrics commitMetrics;

    protected SnapshotProducer(TableOperations ops) {
        this.ops = ops;
        this.strictCleanup = ops.requireStrictCleanup();
        this.base = ops.current();
        this.manifestsWithMetadata = Caffeine.newBuilder().build(file -> {
            if (file.snapshotId() != null) {
                return file;
            }
            return SnapshotProducer.addMetadata(ops, file);
        });
        this.targetManifestSizeBytes = ops.current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
        boolean snapshotIdInheritanceEnabled = ops.current().propertyAsBoolean("compatibility.snapshot-id-inheritance.enabled", false);
        this.canInheritSnapshotId = ops.current().formatVersion() > 1 || snapshotIdInheritanceEnabled;
    }

    protected abstract ThisT self();

    public ThisT stageOnly() {
        this.stageOnly = true;
        return this.self();
    }

    public ThisT scanManifestsWith(ExecutorService executorService) {
        this.workerPool = executorService;
        return this.self();
    }

    protected TableOperations ops() {
        return this.ops;
    }

    protected CommitMetrics commitMetrics() {
        if (this.commitMetrics == null) {
            this.commitMetrics = CommitMetrics.of((MetricsContext)new DefaultMetricsContext());
        }
        return this.commitMetrics;
    }

    protected ThisT reportWith(MetricsReporter newReporter) {
        this.reporter = newReporter;
        return this.self();
    }

    protected void targetBranch(String branch) {
        Preconditions.checkArgument((branch != null ? 1 : 0) != 0, (Object)"Invalid branch name: null");
        boolean refExists = this.base.ref(branch) != null;
        Preconditions.checkArgument((!refExists || this.base.ref(branch).isBranch() ? 1 : 0) != 0, (String)"%s is a tag, not a branch. Tags cannot be targets for producing snapshots", (Object)branch);
        this.targetBranch = branch;
    }

    protected String targetBranch() {
        return this.targetBranch;
    }

    protected ExecutorService workerPool() {
        if (this.workerPool == null) {
            this.workerPool = ThreadPools.getWorkerPool();
        }
        return this.workerPool;
    }

    public ThisT deleteWith(Consumer<String> deleteCallback) {
        Preconditions.checkArgument((this.deleteFunc == this.defaultDelete ? 1 : 0) != 0, (Object)"Cannot set delete callback more than once");
        this.deleteFunc = deleteCallback;
        return this.self();
    }

    protected abstract void cleanUncommitted(Set<ManifestFile> var1);

    protected abstract String operation();

    protected void validate(TableMetadata currentMetadata, Snapshot snapshot) {
    }

    protected abstract List<ManifestFile> apply(TableMetadata var1, Snapshot var2);

    public Snapshot apply() {
        this.refresh();
        Snapshot parentSnapshot = SnapshotUtil.latestSnapshot(this.base, this.targetBranch);
        long sequenceNumber = this.base.nextSequenceNumber();
        Long parentSnapshotId = parentSnapshot == null ? null : Long.valueOf(parentSnapshot.snapshotId());
        this.validate(this.base, parentSnapshot);
        List<ManifestFile> manifests = this.apply(this.base, parentSnapshot);
        OutputFile manifestList = this.manifestListPath();
        ManifestListWriter writer = ManifestLists.write(this.ops.current().formatVersion(), manifestList, this.snapshotId(), parentSnapshotId, sequenceNumber, this.base.nextRowId());
        try (ManifestListWriter manifestListWriter = writer;){
            this.manifestLists.add(manifestList.location());
            ManifestFile[] manifestFiles = new ManifestFile[manifests.size()];
            Tasks.range(manifestFiles.length).stopOnFailure().throwFailureWhenFinished().executeWith(this.workerPool()).run(index -> {
                manifestFiles[index.intValue()] = (ManifestFile)this.manifestsWithMetadata.get((Object)((ManifestFile)manifests.get((int)index)));
            });
            writer.addAll(Arrays.asList(manifestFiles));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write manifest list file", new Object[0]);
        }
        Long nextRowId = null;
        Long assignedRows = null;
        if (this.base.formatVersion() >= 3) {
            nextRowId = this.base.nextRowId();
            assignedRows = writer.nextRowId() - this.base.nextRowId();
        }
        Map<String, String> summary = this.summary();
        String operation = this.operation();
        if (summary != null && "replace".equals(operation)) {
            long replacedRecords;
            long addedRecords = PropertyUtil.propertyAsLong(summary, "added-records", 0L);
            Preconditions.checkArgument((addedRecords <= (replacedRecords = PropertyUtil.propertyAsLong(summary, "deleted-records", 0L)) ? 1 : 0) != 0, (String)"Invalid REPLACE operation: %s added records > %s replaced records", (long)addedRecords, (long)replacedRecords);
        }
        return new BaseSnapshot(sequenceNumber, this.snapshotId(), parentSnapshotId, System.currentTimeMillis(), this.operation(), this.summary(this.base), this.base.currentSchemaId(), manifestList.location(), nextRowId, assignedRows);
    }

    protected abstract Map<String, String> summary();

    private Map<String, String> summary(TableMetadata previous) {
        Object previousSummary;
        Map<String, String> summary = this.summary();
        if (summary == null) {
            return ImmutableMap.of();
        }
        SnapshotRef previousBranchHead = previous.ref(this.targetBranch);
        if (previousBranchHead != null) {
            previousSummary = previous.snapshot(previousBranchHead.snapshotId()).summary() != null ? previous.snapshot(previousBranchHead.snapshotId()).summary() : ImmutableMap.of();
        } else {
            ImmutableMap.Builder summaryBuilder = ImmutableMap.builder();
            summaryBuilder.put((Object)"total-records", (Object)"0").put((Object)"total-files-size", (Object)"0").put((Object)"total-data-files", (Object)"0").put((Object)"total-delete-files", (Object)"0").put((Object)"total-position-deletes", (Object)"0").put((Object)"total-equality-deletes", (Object)"0");
            previousSummary = summaryBuilder.build();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(summary);
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-records", summary, "added-records", "deleted-records");
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-files-size", summary, "added-files-size", "removed-files-size");
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-data-files", summary, "added-data-files", "deleted-data-files");
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-delete-files", summary, "added-delete-files", "removed-delete-files");
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-position-deletes", summary, "added-position-deletes", "removed-position-deletes");
        SnapshotProducer.updateTotal((ImmutableMap.Builder<String, String>)builder, (Map<String, String>)previousSummary, "total-equality-deletes", summary, "added-equality-deletes", "removed-equality-deletes");
        builder.putAll(EnvironmentContext.get());
        return builder.build();
    }

    protected TableMetadata current() {
        return this.base;
    }

    protected TableMetadata refresh() {
        this.base = this.ops.refresh();
        return this.base;
    }

    public void commit() {
        AtomicReference stagedSnapshot = new AtomicReference();
        try (Timer.Timed ignore = this.commitMetrics().totalDuration().start();){
            try {
                Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).countAttempts(this.commitMetrics().attempts()).run(taskOps -> {
                    Snapshot newSnapshot = this.apply();
                    stagedSnapshot.set(newSnapshot);
                    TableMetadata.Builder update = TableMetadata.buildFrom(this.base);
                    if (this.base.snapshot(newSnapshot.snapshotId()) != null) {
                        update.setBranchSnapshot(newSnapshot.snapshotId(), this.targetBranch);
                    } else if (this.stageOnly) {
                        update.addSnapshot(newSnapshot);
                    } else {
                        update.setBranchSnapshot(newSnapshot, this.targetBranch);
                    }
                    TableMetadata updated = update.build();
                    if (updated.changes().isEmpty()) {
                        return;
                    }
                    taskOps.commit(this.base, updated.withUUID());
                });
            }
            catch (CommitStateUnknownException commitStateUnknownException) {
                throw commitStateUnknownException;
            }
            catch (RuntimeException e) {
                if (!this.strictCleanup || e instanceof CleanableFailure) {
                    Exceptions.suppressAndThrow(e, this::cleanAll);
                }
                throw e;
            }
            Snapshot committedSnapshot = (Snapshot)stagedSnapshot.get();
            try {
                LOG.info("Committed snapshot {} ({})", (Object)committedSnapshot.snapshotId(), (Object)this.getClass().getSimpleName());
                if (this.cleanupAfterCommit()) {
                    this.cleanUncommitted(Sets.newHashSet((Iterable)committedSnapshot.allManifests(this.ops.io())));
                }
                for (String manifestList : this.manifestLists) {
                    if (committedSnapshot.manifestListLocation().equals(manifestList)) continue;
                    this.deleteFile(manifestList);
                }
            }
            catch (Throwable e) {
                LOG.warn("Failed to load committed table metadata or during cleanup, skipping further cleanup", e);
            }
        }
        try {
            this.notifyListeners();
        }
        catch (Throwable e) {
            LOG.warn("Failed to notify event listeners", e);
        }
    }

    private void notifyListeners() {
        try {
            Object event = this.updateEvent();
            if (event != null) {
                Listeners.notifyAll((Object)event);
                if (event instanceof CreateSnapshotEvent) {
                    CreateSnapshotEvent createSnapshotEvent = (CreateSnapshotEvent)event;
                    this.reporter.report((MetricsReport)ImmutableCommitReport.builder().tableName(createSnapshotEvent.tableName()).snapshotId(createSnapshotEvent.snapshotId()).operation(createSnapshotEvent.operation()).sequenceNumber(createSnapshotEvent.sequenceNumber()).metadata(EnvironmentContext.get()).commitMetrics(CommitMetricsResult.from(this.commitMetrics(), createSnapshotEvent.summary())).build());
                }
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify listeners", (Throwable)e);
        }
    }

    protected void cleanAll() {
        for (String manifestList : this.manifestLists) {
            this.deleteFile(manifestList);
        }
        this.manifestLists.clear();
        this.cleanUncommitted(EMPTY_SET);
    }

    protected void deleteFile(String path) {
        this.deleteFunc.accept(path);
    }

    protected OutputFile manifestListPath() {
        return this.ops.io().newOutputFile(this.ops.metadataFileLocation(FileFormat.AVRO.addExtension(String.format(Locale.ROOT, "snap-%d-%d-%s", this.snapshotId(), this.attempt.incrementAndGet(), this.commitUUID))));
    }

    protected EncryptedOutputFile newManifestOutputFile() {
        String manifestFileLocation = this.ops.metadataFileLocation(FileFormat.AVRO.addExtension(this.commitUUID + "-m" + this.manifestCount.getAndIncrement()));
        return EncryptingFileIO.combine((FileIO)this.ops.io(), (EncryptionManager)this.ops.encryption()).newEncryptingOutputFile(manifestFileLocation);
    }

    protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec spec) {
        return ManifestFiles.write(this.ops.current().formatVersion(), spec, this.newManifestOutputFile(), (Long)this.snapshotId());
    }

    protected ManifestWriter<DeleteFile> newDeleteManifestWriter(PartitionSpec spec) {
        return ManifestFiles.writeDeleteManifest(this.ops.current().formatVersion(), spec, this.newManifestOutputFile(), (Long)this.snapshotId());
    }

    protected RollingManifestWriter<DataFile> newRollingManifestWriter(PartitionSpec spec) {
        return new RollingManifestWriter<DataFile>(() -> this.newManifestWriter(spec), this.targetManifestSizeBytes);
    }

    protected RollingManifestWriter<DeleteFile> newRollingDeleteManifestWriter(PartitionSpec spec) {
        return new RollingManifestWriter<DeleteFile>(() -> this.newDeleteManifestWriter(spec), this.targetManifestSizeBytes);
    }

    protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
        return ManifestFiles.read(manifest, this.ops.io(), this.ops.current().specsById());
    }

    protected ManifestReader<DeleteFile> newDeleteManifestReader(ManifestFile manifest) {
        return ManifestFiles.readDeleteManifest(manifest, this.ops.io(), this.ops.current().specsById());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long snapshotId() {
        if (this.snapshotId == null) {
            SnapshotProducer snapshotProducer = this;
            synchronized (snapshotProducer) {
                while (this.snapshotId == null || this.ops.current().snapshot(this.snapshotId) != null) {
                    this.snapshotId = this.ops.newSnapshotId();
                }
            }
        }
        return this.snapshotId;
    }

    protected boolean canInheritSnapshotId() {
        return this.canInheritSnapshotId;
    }

    protected boolean cleanupAfterCommit() {
        return true;
    }

    protected List<ManifestFile> writeDataManifests(Collection<DataFile> files, PartitionSpec spec) {
        return this.writeDataManifests(files, null, spec);
    }

    protected List<ManifestFile> writeDataManifests(Collection<DataFile> files, Long dataSeq, PartitionSpec spec) {
        return SnapshotProducer.writeManifests(files, group -> this.writeDataFileGroup((Collection<DataFile>)group, dataSeq, spec));
    }

    private List<ManifestFile> writeDataFileGroup(Collection<DataFile> files, Long dataSeq, PartitionSpec spec) {
        RollingManifestWriter<DataFile> writer = this.newRollingManifestWriter(spec);
        try (RollingManifestWriter<DataFile> closableWriter = writer;){
            if (dataSeq != null) {
                files.forEach(file -> closableWriter.add((DataFile)file, dataSeq));
            } else {
                files.forEach(closableWriter::add);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write data manifests", new Object[0]);
        }
        return writer.toManifestFiles();
    }

    protected List<ManifestFile> writeDeleteManifests(Collection<DeleteFile> files, PartitionSpec spec) {
        return SnapshotProducer.writeManifests(files, group -> this.writeDeleteFileGroup((Collection<DeleteFile>)group, spec));
    }

    private List<ManifestFile> writeDeleteFileGroup(Collection<DeleteFile> files, PartitionSpec spec) {
        RollingManifestWriter<DeleteFile> writer = this.newRollingDeleteManifestWriter(spec);
        try (RollingManifestWriter<DeleteFile> closableWriter = writer;){
            for (DeleteFile file : files) {
                Preconditions.checkArgument((boolean)(file instanceof Delegates.PendingDeleteFile), (Object)"Invalid delete file: must be PendingDeleteFile");
                if (file.dataSequenceNumber() != null) {
                    closableWriter.add(file, file.dataSequenceNumber());
                    continue;
                }
                closableWriter.add(file);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write delete manifests", new Object[0]);
        }
        return writer.toManifestFiles();
    }

    private static <F> List<ManifestFile> writeManifests(Collection<F> files, Function<List<F>, List<ManifestFile>> writeFunc) {
        int parallelism = SnapshotProducer.manifestWriterCount(ThreadPools.WORKER_THREAD_POOL_SIZE, files.size());
        List<List<F>> groups = SnapshotProducer.divide(files, parallelism);
        ConcurrentLinkedQueue manifests = Queues.newConcurrentLinkedQueue();
        Tasks.foreach(groups).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(group -> manifests.addAll((Collection)writeFunc.apply((List)group)));
        return ImmutableList.copyOf((Collection)manifests);
    }

    private static <T> List<List<T>> divide(Collection<T> collection, int groupCount) {
        ArrayList list = Lists.newArrayList(collection);
        int groupSize = IntMath.divide((int)list.size(), (int)groupCount, (RoundingMode)RoundingMode.CEILING);
        return Lists.partition((List)list, (int)groupSize);
    }

    @VisibleForTesting
    static int manifestWriterCount(int workerPoolSize, int fileCount) {
        int limit = IntMath.divide((int)fileCount, (int)10000, (RoundingMode)RoundingMode.HALF_UP);
        return Math.max(1, Math.min(workerPoolSize, limit));
    }

    private static ManifestFile addMetadata(TableOperations ops, ManifestFile manifest) {
        Object object;
        block16: {
            ManifestReader<DataFile> reader = ManifestFiles.read(manifest, ops.io(), ops.current().specsById());
            try {
                PartitionSummary stats = new PartitionSummary(ops.current().spec(manifest.partitionSpecId()));
                int addedFiles = 0;
                long addedRows = 0L;
                int existingFiles = 0;
                long existingRows = 0L;
                int deletedFiles = 0;
                long deletedRows = 0L;
                Long snapshotId = null;
                long maxSnapshotId = Long.MIN_VALUE;
                for (ManifestEntry entry : reader.entries()) {
                    if (entry.snapshotId() > maxSnapshotId) {
                        maxSnapshotId = entry.snapshotId();
                    }
                    switch (entry.status()) {
                        case ADDED: {
                            ++addedFiles;
                            addedRows += ((DataFile)entry.file()).recordCount();
                            if (snapshotId != null) break;
                            snapshotId = entry.snapshotId();
                            break;
                        }
                        case EXISTING: {
                            ++existingFiles;
                            existingRows += ((DataFile)entry.file()).recordCount();
                            break;
                        }
                        case DELETED: {
                            ++deletedFiles;
                            deletedRows += ((DataFile)entry.file()).recordCount();
                            if (snapshotId != null) break;
                            snapshotId = entry.snapshotId();
                        }
                    }
                    stats.update(((DataFile)entry.file()).partition());
                }
                if (snapshotId == null) {
                    snapshotId = maxSnapshotId;
                }
                object = new GenericManifestFile(manifest.path(), manifest.length(), manifest.partitionSpecId(), ManifestContent.DATA, manifest.sequenceNumber(), manifest.minSequenceNumber(), snapshotId, stats.summaries(), null, addedFiles, addedRows, existingFiles, existingRows, deletedFiles, deletedRows, null);
                if (reader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read manifest: %s", new Object[]{manifest.path()});
                }
            }
            reader.close();
        }
        return object;
    }

    private static void updateTotal(ImmutableMap.Builder<String, String> summaryBuilder, Map<String, String> previousSummary, String totalProperty, Map<String, String> currentSummary, String addedProperty, String deletedProperty) {
        String totalStr = previousSummary.get(totalProperty);
        if (totalStr != null) {
            try {
                long newTotal = Long.parseLong(totalStr);
                String addedStr = currentSummary.get(addedProperty);
                if (newTotal >= 0L && addedStr != null) {
                    newTotal += Long.parseLong(addedStr);
                }
                String deletedStr = currentSummary.get(deletedProperty);
                if (newTotal >= 0L && deletedStr != null) {
                    newTotal -= Long.parseLong(deletedStr);
                }
                if (newTotal >= 0L) {
                    summaryBuilder.put((Object)totalProperty, (Object)String.valueOf(newTotal));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    protected static class PendingDeleteFile
    extends Delegates.PendingDeleteFile {
        PendingDeleteFile(DeleteFile deleteFile, long dataSequenceNumber) {
            super(deleteFile, dataSequenceNumber);
        }

        PendingDeleteFile(DeleteFile deleteFile) {
            super(deleteFile, null);
        }

        @Override
        PendingDeleteFile wrap(DeleteFile file) {
            return new PendingDeleteFile(file, (long)this.dataSequenceNumber());
        }
    }
}

