/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class ColumnPO {
    private Long columnId;
    private String columnName;
    private Integer columnPosition;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private Long tableId;
    private Long tableVersion;
    private String columnType;
    private String columnComment;
    private Byte nullable;
    private Byte autoIncrement;
    private String defaultValue;
    private Byte columnOpType;
    private Long deletedAt;
    private String auditInfo;

    public static Builder builder() {
        return new Builder();
    }

    private ColumnPO() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPO)) {
            return false;
        }
        ColumnPO other = (ColumnPO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$columnId = this.getColumnId();
        Long other$columnId = other.getColumnId();
        if (this$columnId == null ? other$columnId != null : !((Object)this$columnId).equals(other$columnId)) {
            return false;
        }
        Integer this$columnPosition = this.getColumnPosition();
        Integer other$columnPosition = other.getColumnPosition();
        if (this$columnPosition == null ? other$columnPosition != null : !((Object)this$columnPosition).equals(other$columnPosition)) {
            return false;
        }
        Long this$metalakeId = this.getMetalakeId();
        Long other$metalakeId = other.getMetalakeId();
        if (this$metalakeId == null ? other$metalakeId != null : !((Object)this$metalakeId).equals(other$metalakeId)) {
            return false;
        }
        Long this$catalogId = this.getCatalogId();
        Long other$catalogId = other.getCatalogId();
        if (this$catalogId == null ? other$catalogId != null : !((Object)this$catalogId).equals(other$catalogId)) {
            return false;
        }
        Long this$schemaId = this.getSchemaId();
        Long other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        Long this$tableId = this.getTableId();
        Long other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
            return false;
        }
        Long this$tableVersion = this.getTableVersion();
        Long other$tableVersion = other.getTableVersion();
        if (this$tableVersion == null ? other$tableVersion != null : !((Object)this$tableVersion).equals(other$tableVersion)) {
            return false;
        }
        Byte this$nullable = this.getNullable();
        Byte other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !((Object)this$nullable).equals(other$nullable)) {
            return false;
        }
        Byte this$autoIncrement = this.getAutoIncrement();
        Byte other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
            return false;
        }
        Byte this$columnOpType = this.getColumnOpType();
        Byte other$columnOpType = other.getColumnOpType();
        if (this$columnOpType == null ? other$columnOpType != null : !((Object)this$columnOpType).equals(other$columnOpType)) {
            return false;
        }
        Long this$deletedAt = this.getDeletedAt();
        Long other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$columnComment = this.getColumnComment();
        String other$columnComment = other.getColumnComment();
        if (this$columnComment == null ? other$columnComment != null : !this$columnComment.equals(other$columnComment)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$auditInfo = this.getAuditInfo();
        String other$auditInfo = other.getAuditInfo();
        return !(this$auditInfo == null ? other$auditInfo != null : !this$auditInfo.equals(other$auditInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnPO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $columnId = this.getColumnId();
        result = result * 59 + ($columnId == null ? 43 : ((Object)$columnId).hashCode());
        Integer $columnPosition = this.getColumnPosition();
        result = result * 59 + ($columnPosition == null ? 43 : ((Object)$columnPosition).hashCode());
        Long $metalakeId = this.getMetalakeId();
        result = result * 59 + ($metalakeId == null ? 43 : ((Object)$metalakeId).hashCode());
        Long $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : ((Object)$catalogId).hashCode());
        Long $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        Long $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        Long $tableVersion = this.getTableVersion();
        result = result * 59 + ($tableVersion == null ? 43 : ((Object)$tableVersion).hashCode());
        Byte $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : ((Object)$nullable).hashCode());
        Byte $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
        Byte $columnOpType = this.getColumnOpType();
        result = result * 59 + ($columnOpType == null ? 43 : ((Object)$columnOpType).hashCode());
        Long $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $columnComment = this.getColumnComment();
        result = result * 59 + ($columnComment == null ? 43 : $columnComment.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $auditInfo = this.getAuditInfo();
        result = result * 59 + ($auditInfo == null ? 43 : $auditInfo.hashCode());
        return result;
    }

    public Long getColumnId() {
        return this.columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Integer getColumnPosition() {
        return this.columnPosition;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public Long getTableVersion() {
        return this.tableVersion;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public Byte getNullable() {
        return this.nullable;
    }

    public Byte getAutoIncrement() {
        return this.autoIncrement;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Byte getColumnOpType() {
        return this.columnOpType;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public static class Builder {
        private final ColumnPO columnPO = new ColumnPO();

        private Builder() {
        }

        public Builder withColumnId(Long columnId) {
            this.columnPO.columnId = columnId;
            return this;
        }

        public Builder withColumnName(String columnName) {
            this.columnPO.columnName = columnName;
            return this;
        }

        public Builder withColumnPosition(Integer columnPosition) {
            this.columnPO.columnPosition = columnPosition;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.columnPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.columnPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.columnPO.schemaId = schemaId;
            return this;
        }

        public Builder withTableId(Long tableId) {
            this.columnPO.tableId = tableId;
            return this;
        }

        public Builder withTableVersion(Long tableVersion) {
            this.columnPO.tableVersion = tableVersion;
            return this;
        }

        public Builder withColumnType(String columnType) {
            this.columnPO.columnType = columnType;
            return this;
        }

        public Builder withColumnComment(String columnComment) {
            this.columnPO.columnComment = columnComment;
            return this;
        }

        public Builder withNullable(Byte nullable) {
            this.columnPO.nullable = nullable;
            return this;
        }

        public Builder withAutoIncrement(Byte autoIncrement) {
            this.columnPO.autoIncrement = autoIncrement;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.columnPO.defaultValue = defaultValue;
            return this;
        }

        public Builder withColumnOpType(Byte columnOpType) {
            this.columnPO.columnOpType = columnOpType;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.columnPO.deletedAt = deletedAt;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.columnPO.auditInfo = auditInfo;
            return this;
        }

        public ColumnPO build() {
            Preconditions.checkArgument((this.columnPO.columnId != null ? 1 : 0) != 0, (Object)"Column id is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.columnPO.columnName), (Object)"Column name is required and cannot be blank");
            Preconditions.checkArgument((this.columnPO.columnPosition != null ? 1 : 0) != 0, (Object)"Column position is required");
            Preconditions.checkArgument((this.columnPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.columnPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.columnPO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.columnPO.tableId != null ? 1 : 0) != 0, (Object)"Table id is required");
            Preconditions.checkArgument((this.columnPO.tableVersion != null ? 1 : 0) != 0, (Object)"Table version is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.columnPO.columnType), (Object)"Column type is required and cannot be blank");
            Preconditions.checkArgument((this.columnPO.nullable != null ? 1 : 0) != 0, (Object)"Nullable is required");
            Preconditions.checkArgument((this.columnPO.autoIncrement != null ? 1 : 0) != 0, (Object)"Auto increment is required");
            Preconditions.checkArgument((this.columnPO.columnOpType != null ? 1 : 0) != 0, (Object)"Column operation type is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.columnPO.auditInfo), (Object)"Audit info is required and cannot be blank");
            Preconditions.checkArgument((this.columnPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
            return this.columnPO;
        }
    }

    public static enum AutoIncrement {
        TRUE((byte)0, true),
        FALSE((byte)1, false);

        private final byte value;
        private final boolean autoIncrement;

        private AutoIncrement(Byte value, boolean autoIncrement) {
            this.value = value;
            this.autoIncrement = autoIncrement;
        }

        public Byte value() {
            return this.value;
        }

        public boolean autoIncrement() {
            return this.autoIncrement;
        }

        public static AutoIncrement fromValue(byte value) {
            for (AutoIncrement autoIncrement : AutoIncrement.values()) {
                if (autoIncrement.value != value) continue;
                return autoIncrement;
            }
            throw new IllegalArgumentException("Invalid auto increment value: " + value);
        }

        public static AutoIncrement fromBoolean(boolean autoIncrement) {
            for (AutoIncrement autoIncrementEnum : AutoIncrement.values()) {
                if (autoIncrementEnum.autoIncrement != autoIncrement) continue;
                return autoIncrementEnum;
            }
            throw new IllegalArgumentException("Invalid auto increment boolean value: " + autoIncrement);
        }
    }

    public static enum Nullable {
        TRUE(0, true),
        FALSE(1, false);

        private final byte value;
        private final boolean nullable;

        private Nullable(byte value, boolean nullable) {
            this.value = value;
            this.nullable = nullable;
        }

        public Byte value() {
            return this.value;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public static Nullable fromValue(byte value) {
            for (Nullable nullable : Nullable.values()) {
                if (nullable.value != value) continue;
                return nullable;
            }
            throw new IllegalArgumentException("Invalid nullable value: " + value);
        }

        public static Nullable fromBoolean(boolean nullable) {
            for (Nullable nullableEnum : Nullable.values()) {
                if (nullableEnum.nullable != nullable) continue;
                return nullableEnum;
            }
            throw new IllegalArgumentException("Invalid nullable boolean value: " + nullable);
        }
    }

    public static enum ColumnOpType {
        CREATE(1),
        UPDATE(2),
        DELETE(3);

        private final byte value;

        private ColumnOpType(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }
    }
}

