/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.lancedb.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.lancedb.lance.namespace.model.QueryTableRequest;
import com.lancedb.lance.namespace.model.QueryTableRequestFullTextQuery;
import com.lancedb.lance.namespace.model.QueryTableRequestVector;
import java.io.IOException;
import java.util.List;

public class QueryTableRequestSerializer
extends JsonSerializer<QueryTableRequest> {
    public void serialize(QueryTableRequest value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("k", value.getK().intValue());
        if (value.getId() != null) {
            gen.writeFieldName("id");
            gen.writeStartArray();
            for (String idPart : value.getId()) {
                gen.writeString(idPart);
            }
            gen.writeEndArray();
        }
        gen.writeFieldName("vector");
        if (value.getVector() != null) {
            QueryTableRequestVector vectorObj = value.getVector();
            if (vectorObj.getMultiVector() != null && !vectorObj.getMultiVector().isEmpty()) {
                gen.writeStartArray();
                for (List vec : vectorObj.getMultiVector()) {
                    gen.writeStartArray();
                    for (Float elem : vec) {
                        gen.writeNumber(elem.floatValue());
                    }
                    gen.writeEndArray();
                }
                gen.writeEndArray();
            } else if (vectorObj.getSingleVector() != null && !vectorObj.getSingleVector().isEmpty()) {
                gen.writeStartArray();
                for (Float elem : vectorObj.getSingleVector()) {
                    gen.writeNumber(elem.floatValue());
                }
                gen.writeEndArray();
            } else {
                gen.writeStartArray();
                gen.writeEndArray();
            }
        } else {
            gen.writeStartArray();
            gen.writeEndArray();
        }
        if (value.getBypassVectorIndex() != null) {
            gen.writeBooleanField("bypass_vector_index", value.getBypassVectorIndex().booleanValue());
        }
        if (value.getColumns() != null) {
            gen.writeObjectField("columns", (Object)value.getColumns());
        }
        if (value.getDistanceType() != null) {
            gen.writeStringField("distance_type", value.getDistanceType());
        }
        if (value.getEf() != null) {
            gen.writeNumberField("ef", value.getEf().intValue());
        }
        if (value.getFastSearch() != null) {
            gen.writeBooleanField("fast_search", value.getFastSearch().booleanValue());
        }
        if (value.getFilter() != null) {
            gen.writeStringField("filter", value.getFilter());
        }
        if (value.getFullTextQuery() != null) {
            gen.writeFieldName("full_text_query");
            QueryTableRequestFullTextQuery ftq = value.getFullTextQuery();
            if (ftq.getStringQuery() != null) {
                gen.writeObject((Object)ftq.getStringQuery());
            } else if (ftq.getStructuredQuery() != null) {
                gen.writeObject((Object)ftq.getStructuredQuery());
            } else {
                gen.writeNull();
            }
        }
        if (value.getLowerBound() != null) {
            gen.writeNumberField("lower_bound", value.getLowerBound().floatValue());
        }
        if (value.getNprobes() != null) {
            gen.writeNumberField("nprobes", value.getNprobes().intValue());
        }
        if (value.getOffset() != null) {
            gen.writeNumberField("offset", value.getOffset().intValue());
        }
        if (value.getPrefilter() != null) {
            gen.writeBooleanField("prefilter", value.getPrefilter().booleanValue());
        }
        if (value.getRefineFactor() != null) {
            gen.writeNumberField("refine_factor", value.getRefineFactor().intValue());
        }
        if (value.getUpperBound() != null) {
            gen.writeNumberField("upper_bound", value.getUpperBound().floatValue());
        }
        if (value.getVectorColumn() != null) {
            gen.writeStringField("vector_column", value.getVectorColumn());
        }
        if (value.getVersion() != null) {
            gen.writeNumberField("version", value.getVersion().longValue());
        }
        if (value.getWithRowId() != null) {
            gen.writeBooleanField("with_row_id", value.getWithRowId().booleanValue());
        }
        gen.writeEndObject();
    }
}

