/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.secret;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.TokenFilter;
import org.apache.guacamole.vault.ksm.secret.KsmClient;
import org.apache.guacamole.vault.ksm.secret.KsmRecordService;
import org.apache.guacamole.vault.secret.VaultSecretService;

@Singleton
public class KsmSecretService
implements VaultSecretService {
    @Inject
    private KsmClient ksm;
    @Inject
    private KsmRecordService recordService;

    public String canonicalize(String nameComponent) {
        try {
            return URLEncoder.encode(nameComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }

    public Future<String> getValue(String name) throws GuacamoleException {
        return this.ksm.getSecret(name);
    }

    private void addRecordTokens(Map<String, Future<String>> tokens, String prefix, KeeperRecord record) {
        String passphrase;
        String password;
        if (record == null) {
            return;
        }
        String username = this.recordService.getUsername(record);
        if (username != null) {
            tokens.put(prefix + "USERNAME", CompletableFuture.completedFuture(username));
        }
        if ((password = this.recordService.getPassword(record)) != null) {
            tokens.put(prefix + "PASSWORD", CompletableFuture.completedFuture(password));
        }
        if ((passphrase = this.recordService.getPassphrase(record)) != null) {
            tokens.put(prefix + "PASSPHRASE", CompletableFuture.completedFuture(passphrase));
        }
        Future<String> privateKey = this.recordService.getPrivateKey(record);
        tokens.put(prefix + "KEY", privateKey);
    }

    public Map<String, Future<String>> getTokens(GuacamoleConfiguration config, TokenFilter filter) throws GuacamoleException {
        String username;
        HashMap<String, Future<String>> tokens = new HashMap<String, Future<String>>();
        Map parameters = config.getParameters();
        String hostname = (String)parameters.get("hostname");
        if (hostname != null && !hostname.isEmpty()) {
            this.addRecordTokens(tokens, "KEEPER_SERVER_", this.ksm.getRecordByHost(filter.filter(hostname)));
        }
        if ((username = (String)parameters.get("username")) != null && !username.isEmpty()) {
            this.addRecordTokens(tokens, "KEEPER_USER_", this.ksm.getRecordByLogin(filter.filter(username)));
        }
        if ("rdp".equals(config.getProtocol())) {
            String gatewayUsername;
            String gatewayHostname = (String)parameters.get("gateway-hostname");
            if (gatewayHostname != null && !gatewayHostname.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_GATEWAY_", this.ksm.getRecordByHost(filter.filter(gatewayHostname)));
            }
            if ((gatewayUsername = (String)parameters.get("gateway-username")) != null && !gatewayUsername.isEmpty()) {
                this.addRecordTokens(tokens, "KEEPER_GATEWAY_USER_", this.ksm.getRecordByLogin(filter.filter(gatewayUsername)));
            }
        }
        return tokens;
    }
}

