/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;

final class NodeKey
implements Serializable,
Comparable<NodeKey> {
    private static AtomicLong GENERATOR = new AtomicLong();
    private final int[] myLowerBounds;
    private final int[] myUpperBounds;
    final double displacement;
    final int index;
    final double objective;
    final long parent;
    final long sequence = GENERATOR.getAndIncrement();

    private NodeKey(int[] lowerBounds, int[] upperBounds, long parentSequenceNumber, int indexBranchedOn, double branchVariableDisplacement, double parentObjectiveFunctionValue) {
        this.myLowerBounds = lowerBounds;
        this.myUpperBounds = upperBounds;
        this.parent = parentSequenceNumber;
        this.index = indexBranchedOn;
        this.displacement = branchVariableDisplacement;
        this.objective = parentObjectiveFunctionValue;
    }

    NodeKey(ExpressionsBasedModel integerModel) {
        List<Variable> tmpIntegerVariables = integerModel.getIntegerVariables();
        int tmpLength = tmpIntegerVariables.size();
        this.myLowerBounds = new int[tmpLength];
        this.myUpperBounds = new int[tmpLength];
        Arrays.fill(this.myLowerBounds, Integer.MIN_VALUE);
        Arrays.fill(this.myUpperBounds, Integer.MAX_VALUE);
        for (int i = 0; i < tmpLength; ++i) {
            BigDecimal tmpUpperLimit;
            Variable tmpVariable = tmpIntegerVariables.get(i);
            BigDecimal tmpLowerLimit = tmpVariable.getLowerLimit();
            if (tmpLowerLimit != null) {
                this.myLowerBounds[i] = tmpLowerLimit.intValue();
            }
            if ((tmpUpperLimit = tmpVariable.getUpperLimit()) == null) continue;
            this.myUpperBounds[i] = tmpUpperLimit.intValue();
        }
        this.parent = this.sequence;
        this.index = -1;
        this.displacement = Double.NaN;
        this.objective = Double.NaN;
    }

    @Override
    public int compareTo(NodeKey ref) {
        return Long.compare(this.sequence, ref.sequence);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeKey)) {
            return false;
        }
        NodeKey other = (NodeKey)obj;
        if (!Arrays.equals(this.myLowerBounds, other.myLowerBounds)) {
            return false;
        }
        return Arrays.equals(this.myUpperBounds, other.myUpperBounds);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myLowerBounds);
        result = 31 * result + Arrays.hashCode(this.myUpperBounds);
        return result;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.sequence);
        retVal.append(' ');
        retVal.append('(');
        retVal.append(this.parent);
        retVal.append(')');
        retVal.append(' ');
        retVal.append(this.index);
        retVal.append('=');
        retVal.append(this.displacement);
        retVal.append(' ');
        retVal.append(this.objective);
        retVal.append(' ');
        retVal.append('[');
        if (this.myLowerBounds.length > 0) {
            this.append(retVal, 0);
        }
        for (int i = 1; i < this.myLowerBounds.length; ++i) {
            retVal.append(',');
            retVal.append(' ');
            this.append(retVal, i);
        }
        return retVal.append(']').toString();
    }

    private void append(StringBuilder builder, int index) {
        builder.append(index);
        builder.append('=');
        builder.append(this.myLowerBounds[index]);
        builder.append('<');
        builder.append(this.myUpperBounds[index]);
    }

    private double feasible(int index, double value) {
        return PrimitiveFunction.MIN.invoke(PrimitiveFunction.MAX.invoke(this.myLowerBounds[index], value), this.myUpperBounds[index]);
    }

    long calculateTreeSize() {
        long retVal = 1L;
        int tmpLength = this.myLowerBounds.length;
        for (int i = 0; i < tmpLength; ++i) {
            retVal *= 1L + (long)(this.myUpperBounds[i] - this.myLowerBounds[i]);
        }
        return retVal;
    }

    NodeKey createLowerBranch(int index, double value, double objective) {
        int[] tmpLBs = this.getLowerBounds();
        int[] tmpUBs = this.getUpperBounds();
        double tmpFeasibleValue = this.feasible(index, value);
        int tmpFloor = (int)PrimitiveFunction.FLOOR.invoke(tmpFeasibleValue);
        tmpUBs[index] = tmpFloor >= tmpUBs[index] && tmpFloor > tmpLBs[index] ? tmpFloor - 1 : tmpFloor;
        return new NodeKey(tmpLBs, tmpUBs, this.sequence, index, value - (double)tmpFloor, objective);
    }

    NodeKey createUpperBranch(int index, double value, double objective) {
        int[] tmpLBs = this.getLowerBounds();
        int[] tmpUBs = this.getUpperBounds();
        double tmpFeasibleValue = this.feasible(index, value);
        int tmpCeil = (int)PrimitiveFunction.CEIL.invoke(tmpFeasibleValue);
        tmpLBs[index] = tmpCeil <= tmpLBs[index] && tmpCeil < tmpUBs[index] ? tmpCeil + 1 : tmpCeil;
        return new NodeKey(tmpLBs, tmpUBs, this.sequence, index, (double)tmpCeil - value, objective);
    }

    double getFraction(int index, double value) {
        double tmpFeasibleValue = this.feasible(index, value);
        return PrimitiveFunction.ABS.invoke(tmpFeasibleValue - PrimitiveFunction.RINT.invoke(tmpFeasibleValue));
    }

    BigDecimal getLowerBound(int index) {
        int tmpLower = this.myLowerBounds[index];
        if (tmpLower != Integer.MIN_VALUE) {
            return new BigDecimal(tmpLower);
        }
        return null;
    }

    int[] getLowerBounds() {
        return ArrayUtils.copyOf(this.myLowerBounds);
    }

    BigDecimal getUpperBound(int index) {
        int tmpUpper = this.myUpperBounds[index];
        if (tmpUpper != Integer.MAX_VALUE) {
            return new BigDecimal(tmpUpper);
        }
        return null;
    }

    int[] getUpperBounds() {
        return ArrayUtils.copyOf(this.myUpperBounds);
    }
}

