/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.fs.azurebfs.services.AbfsApacheHttpClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsJdkHttpOperation
extends AbfsHttpOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsJdkHttpOperation.class);
    private final HttpURLConnection connection = this.openConnection();

    public AbfsJdkHttpOperation(URL url, String method, List<AbfsHttpHeader> requestHeaders, Duration connectionTimeout, Duration readTimeout, AbfsClient abfsClient) throws IOException {
        super(LOG, url, method, requestHeaders, connectionTimeout, readTimeout, abfsClient);
        if (this.connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConn = (HttpsURLConnection)this.connection;
            DelegatingSSLSocketFactory sslSocketFactory = DelegatingSSLSocketFactory.getDefaultFactory();
            if (sslSocketFactory != null) {
                secureConn.setSSLSocketFactory((SSLSocketFactory)sslSocketFactory);
            }
        }
        this.connection.setConnectTimeout(this.getConnectionTimeout());
        this.connection.setReadTimeout(this.getReadTimeout());
        this.connection.setRequestMethod(method);
        for (AbfsHttpHeader header : requestHeaders) {
            this.setRequestProperty(header.getName(), header.getValue());
        }
    }

    @Override
    public String getResponseHeader(String httpHeader) {
        return this.connection.getHeaderField(httpHeader);
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.connection.getHeaderFields();
    }

    @Override
    public String getResponseHeaderIgnoreCase(String headerName) {
        Map<String, List<String>> responseHeaders = this.getResponseHeaders();
        if (responseHeaders == null || responseHeaders.isEmpty()) {
            return null;
        }
        return responseHeaders.entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).equalsIgnoreCase(headerName)).flatMap(entry -> ((List)entry.getValue()).stream()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPayload(byte[] buffer, int offset, int length) throws IOException {
        this.connection.setDoOutput(true);
        this.connection.setFixedLengthStreamingMode(length);
        if (buffer == null) {
            buffer = new byte[]{};
            offset = 0;
            length = 0;
        }
        long startTime = 0L;
        startTime = System.nanoTime();
        OutputStream outputStream = null;
        this.setExpectedBytesToBeSent(length);
        try {
            try {
                outputStream = this.getConnOutputStream();
            }
            catch (IOException e) {
                this.setConnectionDisconnectedOnError();
                String expectHeader = this.getConnProperty("Expect");
                if (expectHeader != null && expectHeader.equals("100-continue") && e instanceof ProtocolException && "Server rejected operation".equals(e.getMessage())) {
                    LOG.debug("Getting output stream failed with expect header enabled, returning back ", (Throwable)e);
                    this.setStatusCode(this.getConnResponseCode());
                    this.setStatusDescription(this.getConnResponseMessage());
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    this.setSendRequestTimeMs(this.elapsedTimeMs(startTime));
                    return;
                }
                LOG.debug("Getting output stream failed without expect header enabled, throwing exception ", (Throwable)e);
                throw e;
            }
            this.setBytesSent(length);
            outputStream.write(buffer, offset, length);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            this.setSendRequestTimeMs(this.elapsedTimeMs(startTime));
        }
    }

    @Override
    String getRequestProperty(String headerName) {
        return this.connection.getRequestProperty(headerName);
    }

    @Override
    Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    @Override
    protected InputStream getContentInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        if (this.isConnectionDisconnectedOnError()) {
            LOG.debug("This connection was not successful or has been disconnected, hence not parsing headers and inputStream");
            return;
        }
        this.processConnHeadersAndInputStreams(buffer, offset, length);
    }

    void processConnHeadersAndInputStreams(byte[] buffer, int offset, int length) throws IOException {
        long startTime = 0L;
        startTime = System.nanoTime();
        this.setStatusCode(this.getConnResponseCode());
        this.setRecvResponseTimeMs(this.elapsedTimeMs(startTime));
        this.setStatusDescription(this.getConnResponseMessage());
        this.setRequestId();
        AbfsIoUtils.dumpHeadersToDebugLog("Response Headers", this.connection.getHeaderFields());
        if ("HEAD".equals(this.getMethod())) {
            return;
        }
        this.parseResponse(buffer, offset, length);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection openConnection() throws IOException {
        long start = System.nanoTime();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.getUrl().openConnection();
            return httpURLConnection;
        }
        finally {
            this.setConnectionTimeMs(this.elapsedTimeMs(start));
        }
    }

    @Override
    protected InputStream getErrorStream() {
        return this.connection.getErrorStream();
    }

    @Override
    String getConnProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    @Override
    URL getConnUrl() {
        return this.connection.getURL();
    }

    @Override
    Integer getConnResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    OutputStream getConnOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    @Override
    String getConnResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    public String getTracingContextSuffix() {
        return AbfsApacheHttpClient.usable() ? "JDK" : "JDK_fallback";
    }
}

