/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public final class ObjectRange {
    private final CompletableFuture<ByteBuffer> byteBuffer;
    private final long offset;
    private final int length;

    public ObjectRange(CompletableFuture<ByteBuffer> byteBuffer, long offset, int length) {
        Preconditions.checkNotNull(byteBuffer);
        Preconditions.checkArgument(offset >= 0L);
        Preconditions.checkArgument(length >= 0);
        this.byteBuffer = byteBuffer;
        this.offset = offset;
        this.length = length;
    }

    public String toString() {
        return String.format("offset: %d, length: %d, completable-future: %s", this.offset, this.length, this.byteBuffer.toString());
    }

    @Generated
    public CompletableFuture<ByteBuffer> getByteBuffer() {
        return this.byteBuffer;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectRange)) {
            return false;
        }
        ObjectRange other = (ObjectRange)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        CompletableFuture<ByteBuffer> this$byteBuffer = this.getByteBuffer();
        CompletableFuture<ByteBuffer> other$byteBuffer = other.getByteBuffer();
        return !(this$byteBuffer == null ? other$byteBuffer != null : !this$byteBuffer.equals(other$byteBuffer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getLength();
        CompletableFuture<ByteBuffer> $byteBuffer = this.getByteBuffer();
        result = result * 59 + ($byteBuffer == null ? 43 : $byteBuffer.hashCode());
        return result;
    }
}

