/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.daemon.support;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;

public final class DaemonConfiguration {
    protected static final String DEFAULT_CONFIG = "daemon.properties";
    protected static final String PREFIX = "daemon.";
    private static final String BTOKEN = "${";
    private static final String ETOKEN = "}";
    private final Properties configurationProperties = new Properties();
    private final Properties systemProperties = System.getProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String fileName) {
        boolean ok = false;
        FileInputStream file = null;
        try {
            if (fileName == null) {
                fileName = DEFAULT_CONFIG;
            }
            file = new FileInputStream(fileName);
            this.configurationProperties.clear();
            this.configurationProperties.load(file);
            ok = true;
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {}
        }
        return ok;
    }

    private String expandProperty(String propValue) throws ParseException {
        int ctoken = 0;
        if (propValue == null) {
            return null;
        }
        StringBuffer expanded = new StringBuffer();
        int btoken = propValue.indexOf(BTOKEN);
        while (btoken != -1) {
            if (btoken > 0 && propValue.charAt(btoken - 1) == BTOKEN.charAt(0)) {
                expanded.append(propValue.substring(ctoken, btoken));
                ctoken = btoken + 1;
                btoken = propValue.indexOf(BTOKEN, btoken + BTOKEN.length());
                continue;
            }
            int etoken = propValue.indexOf(ETOKEN, btoken);
            if (etoken != -1) {
                String variable = propValue.substring(btoken + BTOKEN.length(), etoken);
                String sysvalue = this.systemProperties.getProperty(variable);
                if (sysvalue == null) {
                    sysvalue = System.getenv(variable);
                }
                if (sysvalue != null) {
                    String strtoken = propValue.substring(ctoken, btoken);
                    expanded.append(strtoken);
                    expanded.append(sysvalue);
                    ctoken = etoken + ETOKEN.length();
                }
            } else {
                throw new ParseException("Error while looking for teminating '}'", btoken);
            }
            btoken = propValue.indexOf(BTOKEN, etoken + ETOKEN.length());
        }
        expanded.append(propValue.substring(ctoken, propValue.length()));
        return expanded.toString();
    }

    public String getProperty(String name) throws ParseException {
        if (name == null) {
            return null;
        }
        return this.expandProperty(this.configurationProperties.getProperty(PREFIX + name));
    }

    public String[] getPropertyArray(String name) throws ParseException {
        String args;
        ArrayList<String> list = new ArrayList<String>();
        while ((args = this.getProperty(name + "[" + list.size() + "]")) != null) {
            list.add(args);
        }
        return list.toArray(new String[list.size()]);
    }
}

