/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import org.apache.hadoop.fs.shell.PrintableString;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestPrintableString {
    private void expect(String reason, String raw, String expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)new PrintableString(raw).toString()).as(reason, new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testPrintableCharacters() throws Exception {
        this.expect("Should keep ASCII letter", "abcdef237", "abcdef237");
        this.expect("Should keep ASCII symbol", " !\"|}~", " !\"|}~");
        this.expect("Should keep Georgian U+1050 and Box Drawing U+2533", "\u1050\u2533--", "\u1050\u2533--");
        this.expect("Should keep Linear B U+10000 and Phoenician U+10900", "\ud800\udc00'''\ud802\udd00", "\ud800\udc00'''\ud802\udd00");
    }

    @Test
    public void testNonPrintableCharacters() throws Exception {
        this.expect("Should replace single control character", "abc\rdef", "abc?def");
        this.expect("Should replace multiple control characters", "\babc\tdef", "?abc?def");
        this.expect("Should replace all control characters", "\f\f\b\n", "????");
        this.expect("Should replace mixed characters starting with a control", "\u0017ab\u0000", "?ab?");
        this.expect("Should replace Byte Order Mark", "-\ufeff--", "-?--");
        this.expect("Should replace Invisible Separator", "\u2063\t", "??");
        this.expect("Should replace private use U+E000", "\ue000", "?");
        this.expect("Should replace private use U+E123 and U+F432", "\ue123abc\uf432", "?abc?");
        this.expect("Should replace private use in Plane 15 and 16: U+F0000 and U+10FFFD, but keep U+1050", "x\udb80\udc00y\udbff\udffdz\u1050", "x?y?z\u1050");
        this.expect("Should replace unassigned U+DFFFF", "-\udb3f\udfff-", "-?-");
        this.expect("Should replace standalone surrogate U+DB80", "x\udb80yz", "x?yz");
        this.expect("Should replace standalone surrogate mixed with valid pair", "x\udb80\ud802\udd00yz", "x?\ud802\udd00yz");
    }
}

