/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.DefaultS3ClientFactory;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.impl.CSEMaterials;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.functional.LazyAtomicReference;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.encryption.s3.S3AsyncEncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClient;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.DefaultCryptoMaterialsManager;
import software.amazon.encryption.s3.materials.Keyring;
import software.amazon.encryption.s3.materials.KmsKeyring;

public class EncryptionS3ClientFactory
extends DefaultS3ClientFactory {
    private static final String ENCRYPTION_CLIENT_CLASSNAME = "software.amazon.encryption.s3.S3EncryptionClient";
    private static final LazyAtomicReference<Boolean> ENCRYPTION_CLIENT_AVAILABLE = LazyAtomicReference.lazyAtomicReferenceFromSupplier(EncryptionS3ClientFactory::checkForEncryptionClient);
    private S3Client s3Client;
    private S3AsyncClient s3AsyncClient;

    private static boolean checkForEncryptionClient() {
        try {
            ClassLoader cl = EncryptionS3ClientFactory.class.getClassLoader();
            cl.loadClass(ENCRYPTION_CLIENT_CLASSNAME);
            LOG.debug("encryption client class {} found", (Object)ENCRYPTION_CLIENT_CLASSNAME);
            return true;
        }
        catch (Exception e) {
            LOG.debug("encryption client class {} not found", (Object)ENCRYPTION_CLIENT_CLASSNAME, (Object)e);
            return false;
        }
    }

    private static synchronized boolean isEncryptionClientAvailable() {
        return (Boolean)ENCRYPTION_CLIENT_AVAILABLE.get();
    }

    @Override
    public S3Client createS3Client(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        if (!EncryptionS3ClientFactory.isEncryptionClientAvailable()) {
            throw InstantiationIOException.unavailable(uri, ENCRYPTION_CLIENT_CLASSNAME, null, "No encryption client available");
        }
        this.s3Client = super.createS3Client(uri, parameters);
        this.s3AsyncClient = super.createS3AsyncClient(uri, parameters);
        return this.createS3EncryptionClient(parameters);
    }

    @Override
    public S3AsyncClient createS3AsyncClient(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        if (!EncryptionS3ClientFactory.isEncryptionClientAvailable()) {
            throw InstantiationIOException.unavailable(uri, ENCRYPTION_CLIENT_CLASSNAME, null, "No encryption client available");
        }
        return this.createS3AsyncEncryptionClient(parameters);
    }

    private S3Client createS3EncryptionClient(S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        CSEMaterials cseMaterials = parameters.getClientSideEncryptionMaterials();
        Preconditions.checkArgument((this.s3AsyncClient != null ? 1 : 0) != 0, (Object)"S3 async client not initialized");
        Preconditions.checkArgument((this.s3Client != null ? 1 : 0) != 0, (Object)"S3 client not initialized");
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (Object)"S3ClientCreationParameters is not initialized");
        S3EncryptionClient.Builder s3EncryptionClientBuilder = S3EncryptionClient.builderV4().wrappedAsyncClient(this.s3AsyncClient).wrappedClient(this.s3Client).enableLegacyUnauthenticatedModes(true).enableLegacyWrappingAlgorithms(true);
        switch (cseMaterials.getCseKeyType()) {
            case KMS: {
                Keyring kmsKeyring = this.createKmsKeyring(parameters, cseMaterials);
                DefaultCryptoMaterialsManager kmsCryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(kmsKeyring).build();
                s3EncryptionClientBuilder.cryptoMaterialsManager((CryptographicMaterialsManager)kmsCryptoMaterialsManager);
                break;
            }
            case CUSTOM: {
                Keyring keyring;
                try {
                    keyring = this.getKeyringProvider(cseMaterials.getCustomKeyringClassName(), cseMaterials.getConf());
                }
                catch (RuntimeException e) {
                    throw new IOException("Failed to instantiate a custom keyring provider: " + e, e);
                }
                DefaultCryptoMaterialsManager customCryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(keyring).build();
                s3EncryptionClientBuilder.cryptoMaterialsManager((CryptographicMaterialsManager)customCryptoMaterialsManager);
                break;
            }
        }
        return s3EncryptionClientBuilder.build();
    }

    private Keyring createKmsKeyring(S3ClientFactory.S3ClientCreationParameters parameters, CSEMaterials cseMaterials) {
        KmsClientBuilder kmsClientBuilder = KmsClient.builder();
        if (parameters.getCredentialSet() != null) {
            kmsClientBuilder.credentialsProvider(parameters.getCredentialSet());
        }
        if (parameters.getKmsRegion() != null) {
            kmsClientBuilder.region(Region.of((String)parameters.getKmsRegion()));
        } else if (parameters.getRegion() != null) {
            kmsClientBuilder.region(Region.of((String)parameters.getRegion()));
        } else if (parameters.getEndpoint() != null) {
            String endpointStr = parameters.getEndpoint();
            URI endpoint = EncryptionS3ClientFactory.getS3Endpoint(endpointStr, cseMaterials.getConf());
            kmsClientBuilder.endpointOverride(endpoint);
        }
        return ((KmsKeyring.Builder)KmsKeyring.builder().kmsClient((KmsClient)kmsClientBuilder.build()).wrappingKeyId(cseMaterials.getKmsKeyId()).enableLegacyWrappingAlgorithms(true)).build();
    }

    private S3AsyncClient createS3AsyncEncryptionClient(S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        Preconditions.checkArgument((this.s3AsyncClient != null ? 1 : 0) != 0, (Object)"S3 async client not initialized");
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (Object)"S3ClientCreationParameters is not initialized");
        S3AsyncEncryptionClient.Builder s3EncryptionAsyncClientBuilder = S3AsyncEncryptionClient.builderV4().wrappedClient(this.s3AsyncClient).enableLegacyUnauthenticatedModes(true).enableLegacyWrappingAlgorithms(true);
        CSEMaterials cseMaterials = parameters.getClientSideEncryptionMaterials();
        switch (cseMaterials.getCseKeyType()) {
            case KMS: {
                Keyring kmsKeyring = this.createKmsKeyring(parameters, cseMaterials);
                DefaultCryptoMaterialsManager kmsCryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(kmsKeyring).build();
                s3EncryptionAsyncClientBuilder.cryptoMaterialsManager((CryptographicMaterialsManager)kmsCryptoMaterialsManager);
                break;
            }
            case CUSTOM: {
                Keyring keyring;
                try {
                    keyring = this.getKeyringProvider(cseMaterials.getCustomKeyringClassName(), cseMaterials.getConf());
                }
                catch (RuntimeException e) {
                    throw new IOException("Failed to instantiate a custom keyring provider: " + e, e);
                }
                DefaultCryptoMaterialsManager customCryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(keyring).build();
                s3EncryptionAsyncClientBuilder.cryptoMaterialsManager((CryptographicMaterialsManager)customCryptoMaterialsManager);
                break;
            }
        }
        return s3EncryptionAsyncClientBuilder.build();
    }

    private Keyring getKeyringProvider(String className, Configuration conf) {
        Class<? extends Keyring> keyringProviderClass = this.getCustomKeyringProviderClass(className);
        try {
            return (Keyring)ReflectionUtils.newInstance(keyringProviderClass, (Configuration)conf);
        }
        catch (Exception e) {
            LOG.warn("Failed to create Keyring provider", (Throwable)e);
            try {
                return (Keyring)ReflectionUtils.newInstance(keyringProviderClass, (Configuration)conf, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create Keyring provider", ex);
            }
        }
    }

    private Class<? extends Keyring> getCustomKeyringProviderClass(String className) {
        Preconditions.checkArgument((className != null && !className.isEmpty() ? 1 : 0) != 0, (Object)"Custom Keyring class name is null or empty");
        try {
            return Class.forName(className).asSubclass(Keyring.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Custom CryptographicMaterialsManager class " + className + "not found", e);
        }
    }
}

