/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import software.amazon.s3.analyticsaccelerator.util.RequestCallback;

public class AnalyticsRequestCallback
implements RequestCallback {
    private final S3AInputStreamStatistics statistics;

    public AnalyticsRequestCallback(S3AInputStreamStatistics statistics) {
        this.statistics = statistics;
    }

    public void onGetRequest() {
        this.statistics.getRequestInitiated();
    }

    public void onHeadRequest() {
        this.statistics.headRequestInitiated();
    }

    public void onBlockPrefetch(long start, long end) {
        this.statistics.bytesPrefetched(end - start + 1L);
    }

    public void footerParsingFailed() {
        this.statistics.footerParsingFailed();
    }

    public void onReadVectored(int numIncomingRanges, int numCombinedRanges) {
        this.statistics.readVectoredOperationStarted(numIncomingRanges, numCombinedRanges);
    }

    public void onCacheHit() {
        this.statistics.streamReadCacheHit();
    }
}

