/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.util.Preconditions;

public class NodePlan {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private List<Step> volumeSetPlans = new LinkedList<Step>();
    private String nodeName;
    private String nodeUUID;
    private int port;
    private long timeStamp;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectReader READER = MAPPER.readerFor(NodePlan.class);
    private static final ObjectWriter WRITER = MAPPER.writerFor(MAPPER.constructType(NodePlan.class));
    private static final Configuration CONFIGURATION = new HdfsConfiguration();
    private static final Collection<String> SUPPORTED_PACKAGES = NodePlan.getAllowedPackages();

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public NodePlan() {
    }

    public NodePlan(String datanodeName, int rpcPort) {
        this.nodeName = datanodeName;
        this.port = rpcPort;
    }

    public List<Step> getVolumeSetPlans() {
        return this.volumeSetPlans;
    }

    void addStep(Step nextStep) {
        Preconditions.checkNotNull((Object)nextStep);
        this.volumeSetPlans.add(nextStep);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setVolumeSetPlans(List<Step> volumeSetPlans) {
        this.volumeSetPlans = volumeSetPlans;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setURI(String dataNodeName) {
        this.nodeName = dataNodeName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static NodePlan parseJson(String json) throws IOException {
        JsonNode tree = READER.readTree(json);
        NodePlan.checkNodes(tree);
        return (NodePlan)READER.readValue(tree);
    }

    private static void checkNodes(JsonNode node) throws IOException {
        block5: {
            block4: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block4;
                Iterator fieldsIterator = node.fields();
                while (fieldsIterator.hasNext()) {
                    String textValue;
                    Map.Entry entry = (Map.Entry)fieldsIterator.next();
                    if ("@class".equals(entry.getKey()) && (textValue = ((JsonNode)entry.getValue()).asText()) != null && !textValue.isEmpty() && !NodePlan.stepClassIsAllowed(textValue)) {
                        throw new IOException("Invalid @class value in NodePlan JSON: " + textValue);
                    }
                    NodePlan.checkNodes((JsonNode)entry.getValue());
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (int i = 0; i < node.size(); ++i) {
                NodePlan.checkNodes(node.get(i));
            }
        }
    }

    public String toJson() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String getNodeUUID() {
        return this.nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    private static boolean stepClassIsAllowed(String className) {
        for (String pkg : SUPPORTED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> getAllowedPackages() {
        return CONFIGURATION.getStringCollection("dfs.nodeplan.steps.supported.packages").stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

