/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFileSystemWithTruncate {
    private static MiniDFSCluster cluster;
    private static Configuration clusterConf;
    private static FileSystem fHdfs;
    private FileSystem fsView;
    private Configuration fsViewConf;
    private FileSystem fsTarget;
    private Path targetTestRoot;
    private Path mountOnNn1;
    private FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper("/tmp/TestViewFileSystemWithXAttrs");

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException {
        cluster = new MiniDFSCluster.Builder(clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
    }

    private void setupMountPoints() {
        this.mountOnNn1 = new Path("/mountOnNn1");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
    }

    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
    }

    @Test(timeout=30000L)
    public void testTruncateWithViewFileSystem() throws Exception {
        Path filePath = new Path(this.mountOnNn1 + "/ttest");
        final Path hdfFilepath = new Path("/tmp/TestViewFileSystemWithXAttrs/ttest");
        FSDataOutputStream out = this.fsView.create(filePath);
        out.writeBytes("drtatedasfdasfgdfas");
        out.close();
        int newLength = 10;
        Assert.assertTrue((String)"ViewFS supports truncate", (boolean)this.fsView.hasPathCapability(filePath, "fs.capability.paths.truncate"));
        boolean isReady = this.fsView.truncate(filePath, (long)newLength);
        if (!isReady) {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        return cluster.getFileSystem(0).isFileClosed(hdfFilepath);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }, (long)100L, (long)60000L);
        }
        Assert.assertEquals((long)newLength, (long)this.fsView.getFileStatus(filePath).getLen());
    }

    static {
        clusterConf = new Configuration();
    }
}

