/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;

final class ParameterUtils {
    ParameterUtils() {
    }

    static byte[] HexToBin(String hexV) throws SQLServerException {
        int len = hexV.length();
        char[] orig = hexV.toCharArray();
        if (len % 2 != 0) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        byte[] bin = new byte[len / 2];
        for (int i = 0; i < len / 2; ++i) {
            bin[i] = (byte)((ParameterUtils.CharToHex(orig[2 * i]) << 4) + ParameterUtils.CharToHex(orig[2 * i + 1]));
        }
        return bin;
    }

    static byte CharToHex(char CTX) throws SQLServerException {
        byte ret = 0;
        if (CTX >= 'A' && CTX <= 'F') {
            ret = (byte)(CTX - 65 + 10);
        } else if (CTX >= 'a' && CTX <= 'f') {
            ret = (byte)(CTX - 97 + 10);
        } else if (CTX >= '0' && CTX <= '9') {
            ret = (byte)(CTX - 48);
        } else {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        return ret;
    }

    static int scanSQLForChar(char ch, String sql, int offset) {
        int len = sql.length();
        block6: while (offset < len) {
            char chTmp = sql.charAt(offset++);
            switch (chTmp) {
                case '/': {
                    if (offset == len) continue block6;
                    if (sql.charAt(offset) == '*') {
                        while (++offset < len) {
                            if (sql.charAt(offset) != '*' || offset + 1 >= len || sql.charAt(offset + 1) != '/') continue;
                            offset += 2;
                            continue block6;
                        }
                        continue block6;
                    }
                    if (sql.charAt(offset) == '-') continue block6;
                }
                case '-': {
                    if (sql.charAt(offset) == '-') {
                        while (++offset < len) {
                            if (sql.charAt(offset) != '\n' && sql.charAt(offset) != '\r') continue;
                            ++offset;
                            continue block6;
                        }
                        continue block6;
                    }
                }
                default: {
                    if (ch != chTmp) continue block6;
                    return offset - 1;
                }
                case '[': {
                    chTmp = ']';
                }
                case '\"': 
                case '\'': 
            }
            char chQuote = chTmp;
            while (offset < len) {
                if (sql.charAt(offset++) != chQuote) continue;
                if (len == offset || sql.charAt(offset) != chQuote) continue block6;
                ++offset;
            }
        }
        return len;
    }
}

