/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;

final class LocalTempDir {
    private static LocalDirAllocator directoryAllocator;

    private LocalTempDir() {
    }

    private static synchronized LocalDirAllocator getAllocator(Configuration conf, String key) {
        if (directoryAllocator != null) {
            String bufferDir = conf.get(key) != null ? key : "hadoop.tmp.dir";
            directoryAllocator = new LocalDirAllocator(bufferDir);
        }
        return directoryAllocator;
    }

    public static File tempFile(Configuration conf, String prefix, long size) throws IOException {
        return LocalTempDir.getAllocator(conf, "fs.s3a.buffer.dir").createTmpFileForWrite(prefix, size, conf);
    }

    public static Path tempPath(Configuration conf, String prefix, long size) throws IOException {
        return LocalTempDir.getAllocator(conf, "fs.s3a.buffer.dir").getLocalPathForWrite(prefix, size, conf);
    }
}

