/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGetSpaceUsed {
    private static final File DIR = GenericTestUtils.getTestDir("TestGetSpaceUsed");

    @Before
    public void setUp() {
        FileUtil.fullyDelete((File)DIR);
        Assert.assertTrue((boolean)DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DIR);
    }

    @Test
    public void testBuilderConf() throws Exception {
        File file = new File(DIR, "testBuilderConf");
        Assert.assertTrue((boolean)file.createNewFile());
        Configuration conf = new Configuration();
        conf.set("fs.getspaceused.classname", DummyDU.class.getName());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInterval(0L).setConf(conf).build();
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)(instance instanceof DummyDU));
        Assert.assertFalse((boolean)instance.running());
        instance.close();
    }

    @Test
    public void testBuildInitial() throws Exception {
        File file = new File(DIR, "testBuildInitial");
        Assert.assertTrue((boolean)file.createNewFile());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setKlass(DummyDU.class).build();
        Assert.assertEquals((long)90210L, (long)instance.getUsed());
        instance.close();
    }

    @Test
    public void testBuildInterval() throws Exception {
        File file = new File(DIR, "testBuildInitial");
        Assert.assertTrue((boolean)file.createNewFile());
        CachingGetSpaceUsed instance = (CachingGetSpaceUsed)new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setInterval(50060L).setKlass(DummyDU.class).build();
        Assert.assertEquals((long)50060L, (long)instance.getRefreshInterval());
        instance.close();
    }

    @Test
    public void testBuildNonCaching() throws Exception {
        File file = new File(DIR, "testBuildNonCaching");
        Assert.assertTrue((boolean)file.createNewFile());
        GetSpaceUsed instance = new GetSpaceUsed.Builder().setPath(file).setInitialUsed(90210L).setInterval(50060L).setKlass(DummyGetSpaceUsed.class).build();
        Assert.assertEquals((long)300L, (long)instance.getUsed());
        Assert.assertTrue((boolean)(instance instanceof DummyGetSpaceUsed));
    }

    private static class DummyGetSpaceUsed
    implements GetSpaceUsed {
        public DummyGetSpaceUsed(GetSpaceUsed.Builder builder) {
        }

        public long getUsed() throws IOException {
            return 300L;
        }
    }

    private static class DummyDU
    extends CachingGetSpaceUsed {
        public DummyDU(GetSpaceUsed.Builder builder) throws IOException {
            super(builder);
        }

        protected void refresh() {
        }
    }
}

