/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.shaded.com.google.inject.servlet.ServletUtils;
import org.apache.hadoop.shaded.com.google.inject.servlet.UriPatternMatcher;

public enum UriPatternType {
    SERVLET,
    REGEX;


    static UriPatternMatcher get(UriPatternType type, String pattern) {
        switch (type) {
            case SERVLET: {
                return new ServletStyleUriPatternMatcher(pattern);
            }
            case REGEX: {
                return new RegexUriPatternMatcher(pattern);
            }
        }
        return null;
    }

    private static String getUri(String uri) {
        int queryIdx = uri.indexOf(63);
        if (queryIdx != -1) {
            uri = uri.substring(0, queryIdx);
        }
        return uri;
    }

    private static class RegexUriPatternMatcher
    implements UriPatternMatcher {
        private final Pattern pattern;
        private final String originalPattern;

        public RegexUriPatternMatcher(String pattern) {
            this.originalPattern = pattern;
            try {
                this.pattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException pse) {
                throw new IllegalArgumentException("Invalid regex pattern: " + pse.getMessage());
            }
        }

        @Override
        public boolean matches(String uri) {
            return null != uri && this.pattern.matcher(UriPatternType.getUri(uri)).matches();
        }

        @Override
        public String extractPath(String path) {
            int end;
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.matches() && matcher.groupCount() >= 1 && (end = matcher.start(1)) < path.length()) {
                return path.substring(0, end);
            }
            return null;
        }

        @Override
        public UriPatternType getPatternType() {
            return REGEX;
        }

        @Override
        public String getOriginalPattern() {
            return this.originalPattern;
        }
    }

    private static class ServletStyleUriPatternMatcher
    implements UriPatternMatcher {
        private final String literal;
        private final String originalPattern;
        private final Kind patternKind;

        public ServletStyleUriPatternMatcher(String pattern) {
            this.originalPattern = pattern;
            if (pattern.startsWith("*")) {
                this.literal = pattern.substring(1);
                this.patternKind = Kind.PREFIX;
            } else if (pattern.endsWith("*")) {
                this.literal = pattern.substring(0, pattern.length() - 1);
                this.patternKind = Kind.SUFFIX;
            } else {
                this.literal = pattern;
                this.patternKind = Kind.LITERAL;
            }
            String normalized = ServletUtils.normalizePath(this.literal);
            if (this.patternKind == Kind.PREFIX) {
                normalized = "*" + normalized;
            } else if (this.patternKind == Kind.SUFFIX) {
                normalized = normalized + "*";
            }
            if (!pattern.equals(normalized)) {
                throw new IllegalArgumentException("Servlet patterns cannot contain escape patterns. Registered pattern: '" + pattern + "' normalizes to: '" + normalized + "'");
            }
        }

        @Override
        public boolean matches(String uri) {
            if (null == uri) {
                return false;
            }
            uri = UriPatternType.getUri(uri);
            if (this.patternKind == Kind.PREFIX) {
                return uri.endsWith(this.literal);
            }
            if (this.patternKind == Kind.SUFFIX) {
                return uri.startsWith(this.literal);
            }
            return this.literal.equals(uri);
        }

        @Override
        public String extractPath(String path) {
            if (this.patternKind == Kind.PREFIX) {
                return null;
            }
            if (this.patternKind == Kind.SUFFIX) {
                String extract = this.literal;
                if (extract.endsWith("/")) {
                    extract = extract.substring(0, extract.length() - 1);
                }
                return extract;
            }
            return path;
        }

        @Override
        public UriPatternType getPatternType() {
            return SERVLET;
        }

        @Override
        public String getOriginalPattern() {
            return this.originalPattern;
        }

        private static enum Kind {
            PREFIX,
            SUFFIX,
            LITERAL;

        }
    }
}

