/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoRequest;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorWebService;
import org.apache.hadoop.yarn.server.timelineservice.security.TimelineV2DelegationTokenSecretManagerService;
import org.apache.hadoop.yarn.server.util.timeline.TimelineServerUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeTimelineCollectorManager
extends TimelineCollectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(NodeTimelineCollectorManager.class);
    private HttpServer2 timelineRestServer;
    private String timelineRestServerBindAddress;
    private volatile CollectorNodemanagerProtocol nmCollectorService;
    private TimelineV2DelegationTokenSecretManagerService tokenMgrService;
    private final boolean runningAsAuxService;
    private UserGroupInformation loginUGI;
    private ScheduledThreadPoolExecutor tokenRenewalExecutor;
    private long tokenRenewInterval;
    private static final long TIME_BEFORE_RENEW_DATE = 10000L;
    private static final long TIME_BEFORE_EXPIRY = 300000L;
    static final String COLLECTOR_MANAGER_ATTR_KEY = "collector.manager";

    @VisibleForTesting
    protected NodeTimelineCollectorManager() {
        this(true);
    }

    protected NodeTimelineCollectorManager(boolean asAuxService) {
        super(NodeTimelineCollectorManager.class.getName());
        this.runningAsAuxService = asAuxService;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.tokenMgrService = this.createTokenManagerService();
        this.addService((Service)this.tokenMgrService);
        this.loginUGI = UserGroupInformation.getCurrentUser();
        this.tokenRenewInterval = conf.getLong("yarn.timeline-service.delegation.token.renew-interval", 86400000L);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            if (!this.runningAsAuxService) {
                try {
                    this.doSecureLogin();
                }
                catch (IOException ie) {
                    throw new YarnRuntimeException("Failed to login", (Throwable)ie);
                }
            }
            this.loginUGI = UserGroupInformation.getLoginUser();
        }
        this.tokenRenewalExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("App Collector Token Renewal thread").build());
        super.serviceStart();
        this.startWebApp();
    }

    protected TimelineV2DelegationTokenSecretManagerService createTokenManagerService() {
        return new TimelineV2DelegationTokenSecretManagerService();
    }

    @VisibleForTesting
    public TimelineV2DelegationTokenSecretManagerService getTokenManagerService() {
        return this.tokenMgrService;
    }

    private void doSecureLogin() throws IOException {
        Configuration conf = this.getConfig();
        String webAppURLWithoutScheme = WebAppUtils.getTimelineCollectorWebAppURLWithoutScheme((Configuration)conf);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)webAppURLWithoutScheme);
        SecurityUtil.login((Configuration)conf, (String)"yarn.timeline-service.keytab", (String)"yarn.timeline-service.principal", (String)addr.getHostName());
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.timelineRestServer != null) {
            this.timelineRestServer.stop();
        }
        if (this.tokenRenewalExecutor != null) {
            this.tokenRenewalExecutor.shutdownNow();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public Token<TimelineDelegationTokenIdentifier> generateTokenForAppCollector(String user) {
        Token<TimelineDelegationTokenIdentifier> token = this.tokenMgrService.generateToken(UserGroupInformation.createRemoteUser((String)user), this.loginUGI.getShortUserName());
        token.setService(new Text(this.timelineRestServerBindAddress));
        return token;
    }

    @VisibleForTesting
    public long renewTokenForAppCollector(AppLevelTimelineCollector appCollector) throws IOException {
        if (appCollector.getDelegationTokenForApp() != null) {
            return this.tokenMgrService.renewToken(appCollector.getDelegationTokenForApp(), appCollector.getAppDelegationTokenRenewer());
        }
        LOG.info("Delegation token not available for renewal for app {}", (Object)appCollector.getTimelineEntityContext().getAppId());
        return -1L;
    }

    @VisibleForTesting
    public void cancelTokenForAppCollector(AppLevelTimelineCollector appCollector) throws IOException {
        if (appCollector.getDelegationTokenForApp() != null) {
            this.tokenMgrService.cancelToken(appCollector.getDelegationTokenForApp(), appCollector.getAppUser());
        }
    }

    private long getRenewalDelay(long renewInterval) {
        return renewInterval > 10000L ? renewInterval - 10000L : renewInterval;
    }

    private long getRegenerationDelay(long tokenMaxDate) {
        long regenerateTime = tokenMaxDate - Time.now();
        return regenerateTime > 300000L ? regenerateTime - 300000L : regenerateTime;
    }

    private org.apache.hadoop.yarn.api.records.Token generateTokenAndSetTimer(ApplicationId appId, AppLevelTimelineCollector appCollector) throws IOException {
        Token<TimelineDelegationTokenIdentifier> timelineToken = this.generateTokenForAppCollector(appCollector.getAppUser());
        TimelineDelegationTokenIdentifier tokenId = (TimelineDelegationTokenIdentifier)timelineToken.decodeIdentifier();
        long renewalDelay = this.getRenewalDelay(this.tokenRenewInterval);
        long regenerationDelay = this.getRegenerationDelay(tokenId.getMaxDate());
        if (renewalDelay > 0L || regenerationDelay > 0L) {
            boolean isTimerForRenewal = renewalDelay < regenerationDelay;
            ScheduledFuture<?> renewalOrRegenerationFuture = this.tokenRenewalExecutor.schedule(new CollectorTokenRenewer(appId, isTimerForRenewal), isTimerForRenewal ? renewalDelay : regenerationDelay, TimeUnit.MILLISECONDS);
            appCollector.setDelegationTokenAndFutureForApp(timelineToken, renewalOrRegenerationFuture, tokenId.getMaxDate(), tokenId.getRenewer().toString());
        }
        LOG.info("Generated a new token {} for app {}", timelineToken, (Object)appId);
        return org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])timelineToken.getIdentifier(), (String)timelineToken.getKind().toString(), (byte[])timelineToken.getPassword(), (String)timelineToken.getService().toString());
    }

    @Override
    protected void doPostPut(ApplicationId appId, TimelineCollector collector) {
        try {
            this.updateTimelineCollectorContext(appId, collector);
            org.apache.hadoop.yarn.api.records.Token token = null;
            if (UserGroupInformation.isSecurityEnabled() && collector instanceof AppLevelTimelineCollector) {
                AppLevelTimelineCollector appCollector = (AppLevelTimelineCollector)collector;
                token = this.generateTokenAndSetTimer(appId, appCollector);
            }
            this.reportNewCollectorInfoToNM(appId, token);
        }
        catch (IOException | YarnException e) {
            LOG.error("Failed to communicate with NM Collector Service for {}", (Object)appId);
            throw new YarnRuntimeException(e);
        }
    }

    @Override
    protected void postRemove(ApplicationId appId, TimelineCollector collector) {
        if (collector instanceof AppLevelTimelineCollector) {
            try {
                this.cancelTokenForAppCollector((AppLevelTimelineCollector)collector);
            }
            catch (IOException e) {
                LOG.warn("Failed to cancel token for app collector with appId {}", (Object)appId, (Object)e);
            }
        }
    }

    private void startWebApp() {
        Configuration conf = this.getConfig();
        String initializers = conf.get("hadoop.http.filter.initializers", "");
        LinkedHashSet<String> defaultInitializers = new LinkedHashSet<String>();
        TimelineServerUtils.addTimelineAuthFilter(initializers, defaultInitializers, this.tokenMgrService);
        TimelineServerUtils.setTimelineFilters(conf, initializers, defaultInitializers);
        String bindAddress = null;
        String host = conf.getTrimmed("yarn.timeline-service.collector.bind-host");
        Configuration.IntegerRanges portRanges = conf.getRange("yarn.timeline-service.collector.bind-port-ranges", "");
        int startPort = 0;
        if (portRanges != null && !portRanges.isEmpty()) {
            startPort = portRanges.getRangeStart();
        }
        bindAddress = host == null || host.isEmpty() ? conf.get("0.0.0.0", "0.0.0.0") + ":" + startPort : host + ":" + startPort;
        try {
            HttpServer2.Builder builder = new HttpServer2.Builder().setName("timeline").setConf(conf).addEndpoint(URI.create((YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://") + bindAddress));
            if (portRanges != null && !portRanges.isEmpty()) {
                builder.setPortRanges(portRanges);
            }
            if (YarnConfiguration.useHttps((Configuration)conf)) {
                builder = WebAppUtils.loadSslConfiguration((HttpServer2.Builder)builder, (Configuration)conf);
            }
            this.timelineRestServer = builder.build();
            this.timelineRestServer.addJerseyResourcePackage(TimelineCollectorWebService.class.getPackage().getName() + ";" + GenericExceptionHandler.class.getPackage().getName() + ";" + YarnJacksonJaxbJsonProvider.class.getPackage().getName(), "/*");
            this.timelineRestServer.setAttribute(COLLECTOR_MANAGER_ATTR_KEY, (Object)this);
            this.timelineRestServer.start();
        }
        catch (Exception e) {
            String msg = "The per-node collector webapp failed to start.";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        this.timelineRestServerBindAddress = WebAppUtils.getResolvedAddress((InetSocketAddress)this.timelineRestServer.getConnectorAddress(0));
        LOG.info("Instantiated the per-node collector webapp at {}", (Object)this.timelineRestServerBindAddress);
    }

    private void reportNewCollectorInfoToNM(ApplicationId appId, org.apache.hadoop.yarn.api.records.Token token) throws YarnException, IOException {
        ReportNewCollectorInfoRequest request = ReportNewCollectorInfoRequest.newInstance(appId, this.timelineRestServerBindAddress, token);
        LOG.info("Report a new collector for application: {} to the NM Collector Service.", (Object)appId);
        this.getNMCollectorService().reportNewCollectorInfo(request);
    }

    private void updateTimelineCollectorContext(ApplicationId appId, TimelineCollector collector) throws YarnException, IOException {
        long flowRunId;
        String flowVersion;
        String flowName;
        GetTimelineCollectorContextRequest request = GetTimelineCollectorContextRequest.newInstance(appId);
        LOG.info("Get timeline collector context for {}", (Object)appId);
        GetTimelineCollectorContextResponse response = this.getNMCollectorService().getTimelineCollectorContext(request);
        String userId = response.getUserId();
        if (userId != null && !userId.isEmpty()) {
            LOG.debug("Setting the user in the context: {}", (Object)userId);
            collector.getTimelineEntityContext().setUserId(userId);
        }
        if ((flowName = response.getFlowName()) != null && !flowName.isEmpty()) {
            LOG.debug("Setting the flow name: {}", (Object)flowName);
            collector.getTimelineEntityContext().setFlowName(flowName);
        }
        if ((flowVersion = response.getFlowVersion()) != null && !flowVersion.isEmpty()) {
            LOG.debug("Setting the flow version: {}", (Object)flowVersion);
            collector.getTimelineEntityContext().setFlowVersion(flowVersion);
        }
        if ((flowRunId = response.getFlowRunId()) != 0L) {
            LOG.debug("Setting the flow run id: {}", (Object)flowRunId);
            collector.getTimelineEntityContext().setFlowRunId(flowRunId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected CollectorNodemanagerProtocol getNMCollectorService() {
        if (this.nmCollectorService == null) {
            NodeTimelineCollectorManager nodeTimelineCollectorManager = this;
            synchronized (nodeTimelineCollectorManager) {
                if (this.nmCollectorService == null) {
                    Configuration conf = this.getConfig();
                    InetSocketAddress nmCollectorServiceAddress = conf.getSocketAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.collector-service.address", "0.0.0.0:8048", 8048);
                    LOG.info("nmCollectorServiceAddress: {}", (Object)nmCollectorServiceAddress);
                    YarnRPC rpc = YarnRPC.create((Configuration)conf);
                    this.nmCollectorService = (CollectorNodemanagerProtocol)rpc.getProxy(CollectorNodemanagerProtocol.class, nmCollectorServiceAddress, conf);
                }
            }
        }
        return this.nmCollectorService;
    }

    @VisibleForTesting
    public String getRestServerBindAddress() {
        return this.timelineRestServerBindAddress;
    }

    private final class CollectorTokenRenewer
    implements Runnable {
        private ApplicationId appId;
        private boolean timerForRenewal = true;

        private CollectorTokenRenewer(ApplicationId applicationId, boolean forRenewal) {
            this.appId = applicationId;
            this.timerForRenewal = forRenewal;
        }

        private void renewToken(AppLevelTimelineCollector appCollector) throws IOException {
            long newExpirationTime = NodeTimelineCollectorManager.this.renewTokenForAppCollector(appCollector);
            long renewalDelay = 0L;
            if (newExpirationTime > 0L) {
                LOG.info("Renewed token for {} with new expiration timestamp = {}", (Object)this.appId, (Object)newExpirationTime);
                renewalDelay = NodeTimelineCollectorManager.this.getRenewalDelay(newExpirationTime - Time.now());
            }
            long regenerationDelay = NodeTimelineCollectorManager.this.getRegenerationDelay(appCollector.getAppDelegationTokenMaxDate());
            if (renewalDelay > 0L || regenerationDelay > 0L) {
                this.timerForRenewal = renewalDelay < regenerationDelay;
                ScheduledFuture<?> renewalOrRegenerationFuture = NodeTimelineCollectorManager.this.tokenRenewalExecutor.schedule(this, this.timerForRenewal ? renewalDelay : regenerationDelay, TimeUnit.MILLISECONDS);
                appCollector.setRenewalOrRegenerationFutureForApp(renewalOrRegenerationFuture);
            }
        }

        private void regenerateToken(AppLevelTimelineCollector appCollector) throws IOException {
            org.apache.hadoop.yarn.api.records.Token token = NodeTimelineCollectorManager.this.generateTokenAndSetTimer(this.appId, appCollector);
            try {
                NodeTimelineCollectorManager.this.reportNewCollectorInfoToNM(this.appId, token);
            }
            catch (YarnException e) {
                LOG.warn("Unable to report regenerated token to NM for {}", (Object)this.appId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimelineCollector collector = NodeTimelineCollectorManager.this.get(this.appId);
            if (collector == null) {
                LOG.info("Cannot find active collector while {} token for {}", (Object)(this.timerForRenewal ? "renewing" : "regenerating"), (Object)this.appId);
                return;
            }
            AppLevelTimelineCollector appCollector = (AppLevelTimelineCollector)collector;
            TimelineCollector timelineCollector = collector;
            synchronized (timelineCollector) {
                if (!collector.isStopped()) {
                    try {
                        if (this.timerForRenewal) {
                            this.renewToken(appCollector);
                        } else {
                            this.regenerateToken(appCollector);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to {} token for {}", new Object[]{this.timerForRenewal ? "renew" : "regenerate", this.appId, e});
                    }
                }
            }
        }
    }
}

