/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationDroppedTablesTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestEditsBehindDroppedTableTiming
extends ReplicationDroppedTablesTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEditsBehindDroppedTableTiming.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestEditsBehindDroppedTableTiming.setupClusters(true);
    }

    @Test
    public void testEditsBehindDroppedTableTiming() throws Exception {
        Put put;
        TableName tablename = TableName.valueOf((String)"testdroppedtimed");
        byte[] familyName = Bytes.toBytes((String)"fam");
        byte[] row = Bytes.toBytes((String)"row");
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tablename).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName).setScope(1).build()).build();
        Connection connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin1 = connection1.getAdmin();){
            admin1.createTable(table);
        }
        var8_8 = null;
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(table);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        UTIL1.waitUntilAllRegionsAssigned(tablename);
        UTIL2.waitUntilAllRegionsAssigned(tablename);
        admin1 = connection1.getAdmin();
        var8_8 = null;
        try {
            admin1.disableReplicationPeer("2");
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var8_8 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
        var8_8 = null;
        try (Table droppedTable = connection1.getTable(tablename);){
            byte[] rowKey = Bytes.toBytes((String)"0 put on table to be dropped");
            put = new Put(rowKey);
            put.addColumn(familyName, row, VALUE);
            droppedTable.put(put);
        }
        catch (Throwable rowKey) {
            var8_8 = rowKey;
            throw rowKey;
        }
        var8_8 = null;
        try (Table table1 = connection1.getTable(tableName);){
            for (int i = 0; i < 1000; ++i) {
                put = new Put(this.generateRowKey(i)).addColumn(famName, row, VALUE);
                table1.put(put);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        admin2 = connection2.getAdmin();
        var8_8 = null;
        try {
            admin2.disableTable(tablename);
            admin2.deleteTable(tablename);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin2 != null) {
                if (var8_8 != null) {
                    try {
                        admin2.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin2.close();
                }
            }
        }
        admin1 = connection1.getAdmin();
        var8_8 = null;
        try {
            admin1.enableReplicationPeer("2");
            this.verifyReplicationStuck();
            admin1.disableTable(tablename);
            this.verifyReplicationStuck();
            admin1.deleteTable(tablename);
            this.verifyReplicationProceeded();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (admin1 != null) {
                if (var8_8 != null) {
                    try {
                        admin1.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    admin1.close();
                }
            }
        }
    }
}

