/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ReplicationSourceInterface {
    public void init(Configuration var1, FileSystem var2, ReplicationSourceManager var3, ReplicationQueueStorage var4, ReplicationPeer var5, Server var6, String var7, UUID var8, WALFileLengthProvider var9, MetricsSource var10) throws IOException;

    public void enqueueLog(Path var1);

    public void addHFileRefs(TableName var1, byte[] var2, List<Pair<Path, Path>> var3) throws ReplicationException;

    public ReplicationSourceInterface startup();

    public void terminate(String var1);

    public void terminate(String var1, Exception var2);

    public void terminate(String var1, Exception var2, boolean var3);

    public Path getCurrentPath();

    public String getQueueId();

    public String getPeerId();

    public String getStats();

    public boolean isPeerEnabled();

    public boolean isSourceActive();

    public MetricsSource getSourceMetrics();

    public ReplicationEndpoint getReplicationEndpoint();

    public ReplicationSourceManager getSourceManager();

    public WALFileLengthProvider getWALFileLengthProvider();

    public void tryThrottle(int var1) throws InterruptedException;

    public void postShipEdits(List<WAL.Entry> var1, int var2);

    public ServerName getServerWALsBelongTo();

    default public Map<String, ReplicationStatus> getWalGroupStatus() {
        return new HashMap<String, ReplicationStatus>();
    }

    default public boolean isRecovered() {
        return false;
    }

    public ReplicationQueueStorage getReplicationQueueStorage();

    default public void logPositionAndCleanOldLogs(WALEntryBatch entryBatch) {
        this.getSourceManager().logPositionAndCleanOldLogs(this, entryBatch);
    }
}

