/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class IdChannel
extends ManagedChannel {
    private static final AtomicLong ID_ALLOC = new AtomicLong();
    private final long channelId = IdChannel.getNextId();
    private final ManagedChannel channel;

    private static long getNextId() {
        return ID_ALLOC.incrementAndGet();
    }

    public IdChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public ManagedChannel shutdown() {
        return this.channel.shutdown();
    }

    public boolean isShutdown() {
        return this.channel.isShutdown();
    }

    public boolean isTerminated() {
        return this.channel.isTerminated();
    }

    public ManagedChannel shutdownNow() {
        return this.channel.shutdownNow();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.channel.awaitTermination(timeout, unit);
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.channel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.channel.authority();
    }

    public ConnectivityState getState(boolean requestConnection) {
        return this.channel.getState(requestConnection);
    }

    public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
        this.channel.notifyWhenStateChanged(source, callback);
    }

    public void resetConnectBackoff() {
        this.channel.resetConnectBackoff();
    }

    public void enterIdle() {
        this.channel.enterIdle();
    }

    public String toString() {
        return "IdChannel{channelId=" + this.channelId + ", channel=" + this.channel + '}';
    }
}

