/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUserEntry
implements Serializable,
Comparable<UsmUserEntry> {
    private static final long serialVersionUID = -3021438367015187166L;
    private OctetString engineID;
    private OctetString userName;
    private UsmUser usmUser;
    private byte[] authenticationKey;
    private byte[] privacyKey;
    private SnmpConstants.StorageTypeEnum storageType = SnmpConstants.StorageTypeEnum.nonVolatile;
    private volatile WeakReference<Object> ownerReference;

    public UsmUserEntry() {
        this.engineID = new OctetString();
        this.userName = new OctetString();
        this.usmUser = new UsmUser(new OctetString(), null, null, null, null);
    }

    public UsmUserEntry(OctetString userName, UsmUser user) {
        this.userName = userName;
        this.usmUser = user;
        if (user.isLocalized()) {
            this.engineID = user.getLocalizationEngineID();
            if (user.getAuthenticationProtocol() != null && user.getAuthenticationPassphrase() != null) {
                this.authenticationKey = user.getAuthenticationPassphrase().getValue();
                if (user.getPrivacyProtocol() != null && user.getPrivacyPassphrase() != null) {
                    this.privacyKey = user.getPrivacyPassphrase().getValue();
                }
            }
        }
    }

    public UsmUserEntry(OctetString userName, OctetString engineID, UsmUser user) {
        this(userName, user);
        this.engineID = engineID;
    }

    public UsmUserEntry(byte[] engineID, OctetString securityName, OID authProtocol, byte[] authKey, OID privProtocol, byte[] privKey) {
        this.engineID = engineID == null ? null : new OctetString(engineID);
        this.userName = securityName;
        this.authenticationKey = authKey;
        this.privacyKey = privKey;
        this.usmUser = new UsmUser(this.userName, authProtocol, this.authenticationKey != null ? new SecretOctetString(this.authenticationKey) : null, privProtocol, this.privacyKey != null ? new SecretOctetString(this.privacyKey) : null, this.engineID);
    }

    public OctetString getEngineID() {
        return this.engineID;
    }

    public void setEngineID(OctetString engineID) {
        this.engineID = engineID;
    }

    public void setUserName(OctetString userName) {
        this.userName = userName;
    }

    public OctetString getUserName() {
        return this.userName;
    }

    public void setUsmUser(UsmUser usmUser) {
        this.usmUser = usmUser;
    }

    public UsmUser getUsmUser() {
        return this.usmUser;
    }

    public void setAuthenticationKey(byte[] authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setPrivacyKey(byte[] privacyKey) {
        this.privacyKey = privacyKey;
    }

    public byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    @Override
    public int compareTo(UsmUserEntry other) {
        int result = 0;
        if (this.engineID != null && other.engineID != null) {
            result = this.engineID.compareTo(other.engineID);
        } else if (this.engineID != null && other.engineID == null) {
            result = 1;
        } else if (this.engineID == null && other.engineID != null) {
            result = -1;
        }
        if (result == 0 && (result = this.userName.compareTo(other.userName)) == 0) {
            result = this.usmUser.compareTo(other.usmUser);
        }
        return result;
    }

    public SnmpConstants.StorageTypeEnum getStorageType() {
        return this.storageType;
    }

    public void setStorageType(SnmpConstants.StorageTypeEnum storageType) {
        this.storageType = storageType;
    }

    public Object getOwnerReference() {
        return this.ownerReference == null ? null : this.ownerReference.get();
    }

    public void setOwnerReference(Object ownerReference) {
        this.ownerReference = new WeakReference<Object>(ownerReference);
    }

    public String toString() {
        return "UsmUserEntry[userName=" + this.userName + ",usmUser=" + this.usmUser + ",storageType=" + this.storageType + ",ownerReference=" + this.ownerReference + "]";
    }
}

