/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.PlcConnectionManager;
import org.apache.plc4x.java.api.PlcDriver;
import org.apache.plc4x.java.api.PlcDriverManager;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlcDriverManager
implements PlcDriverManager,
PlcConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlcDriverManager.class);
    protected final ClassLoader classLoader;
    private final Map<String, PlcDriver> driverMap;

    public DefaultPlcDriverManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DefaultPlcDriverManager(ClassLoader classLoader) {
        LOGGER.info("Instantiating new PLC Driver Manager with class loader {}", (Object)classLoader);
        this.classLoader = classLoader;
        this.driverMap = new HashMap<String, PlcDriver>();
        ServiceLoader<PlcDriver> plcDriverLoader = ServiceLoader.load(PlcDriver.class, classLoader);
        LOGGER.info("Registering available drivers...");
        for (PlcDriver driver : plcDriverLoader) {
            if (this.driverMap.containsKey(driver.getProtocolCode())) {
                throw new IllegalStateException("Multiple driver implementations available for protocol code '" + driver.getProtocolCode() + "'");
            }
            LOGGER.info("Registering driver for Protocol {} ({})", (Object)driver.getProtocolCode(), (Object)driver.getProtocolName());
            this.driverMap.put(driver.getProtocolCode(), driver);
        }
    }

    @Override
    public PlcConnection getConnection(String url) throws PlcConnectionException {
        PlcConnection connection;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            PlcDriver driver = this.getDriverForUrl(url);
            connection = driver.getConnection(url);
            connection.connect();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return connection;
    }

    @Override
    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        PlcConnection connection;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            PlcDriver driver = this.getDriverForUrl(url);
            connection = driver.getConnection(url, authentication);
            connection.connect();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return connection;
    }

    @Override
    public Set<String> getProtocolCodes() {
        return this.driverMap.keySet();
    }

    @Override
    public PlcDriver getDriver(String protocolCode) throws PlcConnectionException {
        PlcDriver driver = this.driverMap.get(protocolCode);
        if (driver == null) {
            throw new PlcConnectionException("Unable to find driver for protocol '" + protocolCode + "'");
        }
        return driver;
    }

    @Override
    public PlcDriver getDriverForUrl(String url) throws PlcConnectionException {
        try {
            URI connectionUri = new URI(url);
            String protocol = connectionUri.getScheme();
            return this.getDriver(protocol);
        }
        catch (URISyntaxException e) {
            throw new PlcConnectionException("Invalid plc4j connection string '" + url + "'", e);
        }
    }

    @Override
    public PlcConnectionManager getConnectionManager() {
        return this;
    }
}

