/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.data;

import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DateWrapper;
import com.vesoft.nebula.client.graph.data.DurationWrapper;
import com.vesoft.nebula.client.graph.data.GeographyWrapper;
import com.vesoft.nebula.client.graph.data.TimeWrapper;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class BaseTableRow
implements Serializable {
    protected final List<ValueWrapper> values;
    protected String decodeType = "utf-8";

    public BaseTableRow(List<ValueWrapper> values) {
        this.values = values;
    }

    public BaseTableRow(List<ValueWrapper> values, String decodeType) {
        this.values = values;
        this.decodeType = decodeType;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isNullAt(int i) {
        return this.values.get(i) == null;
    }

    public String getString(int i) throws UnsupportedEncodingException {
        return this.values.get(i).asString();
    }

    public long getLong(int i) {
        return this.values.get(i).asLong();
    }

    public boolean getBoolean(int i) {
        return this.values.get(i).asBoolean();
    }

    public double getDouble(int i) {
        return this.values.get(i).asDouble();
    }

    public DateWrapper getDate(int i) {
        return this.values.get(i).asDate();
    }

    public TimeWrapper getTime(int i) {
        return this.values.get(i).asTime();
    }

    public DateTimeWrapper getDateTime(int i) {
        return this.values.get(i).asDateTime();
    }

    public GeographyWrapper getGeography(int i) {
        return this.values.get(i).asGeography();
    }

    public DurationWrapper getDuration(int i) {
        return this.values.get(i).asDuration();
    }

    public List<ValueWrapper> getValues() {
        return this.values;
    }

    public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public String mkString(String start, String sep, String end) {
        int n = this.size();
        StringBuilder builder = new StringBuilder();
        builder.append(start);
        if (n > 0) {
            builder.append(this.values.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append(sep);
                builder.append(this.values.get(i));
            }
        }
        builder.append(end);
        return builder.toString();
    }
}

