/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.flags;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.misc.flags.ReplRemoveFirstIncLoadPendFlagDesc;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;

public class ReplRemoveFirstIncLoadPendFlagOperation
extends DDLOperation<ReplRemoveFirstIncLoadPendFlagDesc> {
    public ReplRemoveFirstIncLoadPendFlagOperation(DDLOperationContext context, ReplRemoveFirstIncLoadPendFlagDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws Exception {
        String dbNameOrPattern = ((ReplRemoveFirstIncLoadPendFlagDesc)this.desc).getDatabaseName();
        for (String dbName : Utils.matchesDb(this.context.getDb(), dbNameOrPattern)) {
            Database database = this.context.getDb().getMSC().getDatabase(dbName);
            Map parameters = database.getParameters();
            String incPendPara = parameters != null ? (String)parameters.get("hive.repl.first.inc.pending") : null;
            if (incPendPara == null) continue;
            parameters.remove("hive.repl.first.inc.pending");
            this.context.getDb().getMSC().alterDatabase(dbName, database);
        }
        return 0;
    }
}

