/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrimColScalarBase;

public class StringRTrimColScalar
extends StringTrimColScalarBase {
    private static final long serialVersionUID = 1L;

    public StringRTrimColScalar(int inputColumn, byte[] trimChars, int outputColumnNum) {
        super(inputColumn, trimChars, outputColumnNum);
    }

    public StringRTrimColScalar() {
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int batchIndex) {
        int index;
        byte[] bytes = vector[batchIndex];
        int startIndex = start[batchIndex];
        for (index = startIndex + length[batchIndex] - 1; index >= startIndex && this.shouldTrim(bytes[index]); --index) {
        }
        int resultLength = index - startIndex + 1;
        if (resultLength == 0) {
            outV.setVal(batchIndex, EMPTY_BYTES, 0, 0);
            return;
        }
        outV.setVal(batchIndex, bytes, startIndex, resultLength);
    }
}

