/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveClientCache;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreUtils {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"hive.log");
    private static volatile HiveClientCache hiveClientCache;
    private static final String FROM_SERIALIZER = "from deserializer";

    public static Deserializer getDeserializer(Configuration conf, Table table, String metaTable, boolean skipConfError) throws MetaException {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        if (lib == null) {
            return null;
        }
        return HiveMetaStoreUtils.getDeserializer(conf, table, metaTable, skipConfError, lib);
    }

    public static Deserializer getDeserializer(Configuration conf, Table table, String metaTable, boolean skipConfError, String lib) throws MetaException {
        AbstractSerDe deserializer;
        block5: {
            try {
                deserializer = (AbstractSerDe)ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(AbstractSerDe.class), (Configuration)conf);
            }
            catch (Exception e) {
                throw new MetaException(e.getClass().getName() + " " + e.getMessage());
            }
            try {
                Properties properties = MetaStoreUtils.getTableMetadata((Table)table);
                if (metaTable != null) {
                    properties.put("metaTable", metaTable);
                }
                deserializer.initialize(conf, properties, null);
            }
            catch (SerDeException e) {
                if (skipConfError) break block5;
                LOG.error("error in initSerDe: " + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage(), (Throwable)e);
                throw new MetaException(((Object)((Object)e)).getClass().getName() + " " + e.getMessage());
            }
        }
        return deserializer;
    }

    public static Class<? extends Deserializer> getDeserializerClass(Configuration conf, Table table) throws Exception {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        return lib == null ? null : conf.getClassByName(lib).asSubclass(Deserializer.class);
    }

    public static Deserializer getDeserializer(Configuration conf, Partition part, Table table) throws MetaException {
        String lib = part.getSd().getSerdeInfo().getSerializationLib();
        try {
            AbstractSerDe deserializer = (AbstractSerDe)ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(AbstractSerDe.class), (Configuration)conf);
            deserializer.initialize(conf, MetaStoreUtils.getTableMetadata((Table)table), MetaStoreUtils.getPartitionMetadata((Partition)part, (Table)table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage(), e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer, Configuration conf) throws SerDeException, MetaException {
        Collection noCommentSerdes = MetastoreConf.getStringCollection((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERDES_WITHOUT_FROM_DESERIALIZER);
        boolean noCommentFromDeserializer = noCommentSerdes.contains(deserializer.getClass().getName());
        ObjectInspector oi = deserializer.getObjectInspector();
        String[] names = tableName.split("\\.");
        String last_name = names[names.length - 1];
        for (int i = 2; i < names.length; ++i) {
            MapObjectInspector moi;
            if (oi instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)oi;
                StructField sf = soi.getStructFieldRef(names[i]);
                if (sf == null) {
                    throw new MetaException("Invalid Field " + names[i]);
                }
                oi = sf.getFieldObjectInspector();
                continue;
            }
            if (oi instanceof ListObjectInspector && names[i].equalsIgnoreCase("$elem$")) {
                ListObjectInspector loi = (ListObjectInspector)oi;
                oi = loi.getListElementObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$key$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapKeyObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$value$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapValueObjectInspector();
                continue;
            }
            throw new MetaException("Unknown type for " + names[i]);
        }
        ArrayList<FieldSchema> str_fields = new ArrayList<FieldSchema>();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            str_fields.add(new FieldSchema(last_name, oi.getTypeName(), HiveMetaStoreUtils.determineFieldComment(null, noCommentFromDeserializer)));
        } else {
            List fields = ((StructObjectInspector)oi).getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                StructField structField = (StructField)fields.get(i);
                String fieldName = structField.getFieldName();
                String fieldTypeName = structField.getFieldObjectInspector().getTypeName();
                String fieldComment = HiveMetaStoreUtils.determineFieldComment(structField.getFieldComment(), noCommentFromDeserializer);
                str_fields.add(new FieldSchema(fieldName, fieldTypeName, fieldComment));
            }
        }
        return str_fields;
    }

    private static String determineFieldComment(String comment, boolean noCommentFromDeserializer) {
        return comment != null || noCommentFromDeserializer ? comment : FROM_SERIALIZER;
    }

    public static FieldSchema getFieldSchemaFromTypeInfo(String fieldName, TypeInfo typeInfo) {
        return new FieldSchema(fieldName, typeInfo.getTypeName(), "generated by TypeInfoUtils.getFieldSchemaFromTypeInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) throws MetaException, IOException {
        if (!HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CLIENT_CACHE_ENABLED)) {
            return HiveClientCache.getNonCachedHiveMetastoreClient(hiveConf);
        }
        if (hiveClientCache != null) return hiveClientCache.get(hiveConf);
        Class<IMetaStoreClient> clazz = IMetaStoreClient.class;
        synchronized (IMetaStoreClient.class) {
            if (hiveClientCache != null) return hiveClientCache.get(hiveConf);
            hiveClientCache = new HiveClientCache(hiveConf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hiveClientCache.get(hiveConf);
        }
    }
}

