/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

class KinesisReaderCheckpoint
implements Iterable<ShardCheckpoint>,
UnboundedSource.CheckpointMark,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -6788209457261206071L;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ShardCheckpoint> shardCheckpoints;

    public KinesisReaderCheckpoint(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ShardCheckpoint> shardCheckpoints) {
        this.shardCheckpoints = ImmutableList.copyOf(shardCheckpoints);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint> splitInto(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits) {
        int partitionSize = this.divideAndRoundUp(this.shardCheckpoints.size(), desiredNumSplits);
        ArrayList checkpoints = Lists.newArrayList();
        for (List shardPartition : Lists.partition(this.shardCheckpoints, (int)partitionSize)) {
            checkpoints.add(new KinesisReaderCheckpoint(shardPartition));
        }
        return checkpoints;
    }

    private @UnknownKeyFor @NonNull @Initialized int divideAndRoundUp(@UnknownKeyFor @NonNull @Initialized int nominator, @UnknownKeyFor @NonNull @Initialized int denominator) {
        return (nominator + denominator - 1) / denominator;
    }

    @UnknownKeyFor @NonNull @Initialized String getStreamName() {
        Iterator<ShardCheckpoint> iterator = this.iterator();
        return iterator.hasNext() ? iterator.next().getStreamName() : "[unknown]";
    }

    public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.shardCheckpoints.toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ShardCheckpoint> iterator() {
        return this.shardCheckpoints.iterator();
    }
}

