/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;

final class AutoValue_SqsIO_WriteBatches<T>
extends SqsIO.WriteBatches<T> {
    private final int concurrentRequests;
    private final Duration batchTimeout;
    private final boolean strictTimeouts;
    private final int batchSize;
    private final ClientConfiguration clientConfiguration;
    private final @Nullable SqsIO.WriteBatches.EntryMapperFn<T> entryMapper;
    private final @Nullable SqsIO.WriteBatches.DynamicDestination<T> dynamicDestination;
    private final @Nullable String queueUrl;

    private AutoValue_SqsIO_WriteBatches(int concurrentRequests, Duration batchTimeout, boolean strictTimeouts, int batchSize, ClientConfiguration clientConfiguration, @Nullable SqsIO.WriteBatches.EntryMapperFn<T> entryMapper, @Nullable SqsIO.WriteBatches.DynamicDestination<T> dynamicDestination, @Nullable String queueUrl) {
        this.concurrentRequests = concurrentRequests;
        this.batchTimeout = batchTimeout;
        this.strictTimeouts = strictTimeouts;
        this.batchSize = batchSize;
        this.clientConfiguration = clientConfiguration;
        this.entryMapper = entryMapper;
        this.dynamicDestination = dynamicDestination;
        this.queueUrl = queueUrl;
    }

    @Override
    @Pure
    int concurrentRequests() {
        return this.concurrentRequests;
    }

    @Override
    @Pure
    Duration batchTimeout() {
        return this.batchTimeout;
    }

    @Override
    @Pure
    boolean strictTimeouts() {
        return this.strictTimeouts;
    }

    @Override
    @Pure
    int batchSize() {
        return this.batchSize;
    }

    @Override
    @Pure
    ClientConfiguration clientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    @Pure
    @Nullable SqsIO.WriteBatches.EntryMapperFn<T> entryMapper() {
        return this.entryMapper;
    }

    @Override
    @Pure
    @Nullable SqsIO.WriteBatches.DynamicDestination<T> dynamicDestination() {
        return this.dynamicDestination;
    }

    @Override
    @Pure
    @Nullable String queueUrl() {
        return this.queueUrl;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqsIO.WriteBatches) {
            SqsIO.WriteBatches that = (SqsIO.WriteBatches)((Object)o);
            return this.concurrentRequests == that.concurrentRequests() && this.batchTimeout.equals((Object)that.batchTimeout()) && this.strictTimeouts == that.strictTimeouts() && this.batchSize == that.batchSize() && this.clientConfiguration.equals(that.clientConfiguration()) && (this.entryMapper == null ? that.entryMapper() == null : this.entryMapper.equals(that.entryMapper())) && (this.dynamicDestination == null ? that.dynamicDestination() == null : this.dynamicDestination.equals(that.dynamicDestination())) && (this.queueUrl == null ? that.queueUrl() == null : this.queueUrl.equals(that.queueUrl()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.concurrentRequests;
        h$ *= 1000003;
        h$ ^= this.batchTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.strictTimeouts ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.batchSize;
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.entryMapper == null ? 0 : this.entryMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.dynamicDestination == null ? 0 : this.dynamicDestination.hashCode();
        h$ *= 1000003;
        return h$ ^= this.queueUrl == null ? 0 : this.queueUrl.hashCode();
    }

    @Override
    SqsIO.WriteBatches.Builder<T> builder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends SqsIO.WriteBatches.Builder<T> {
        private Integer concurrentRequests;
        private Duration batchTimeout;
        private Boolean strictTimeouts;
        private Integer batchSize;
        private ClientConfiguration clientConfiguration;
        private @Nullable SqsIO.WriteBatches.EntryMapperFn<T> entryMapper;
        private @Nullable SqsIO.WriteBatches.DynamicDestination<T> dynamicDestination;
        private @Nullable String queueUrl;

        Builder() {
        }

        private Builder(SqsIO.WriteBatches<T> source) {
            this.concurrentRequests = source.concurrentRequests();
            this.batchTimeout = source.batchTimeout();
            this.strictTimeouts = source.strictTimeouts();
            this.batchSize = source.batchSize();
            this.clientConfiguration = source.clientConfiguration();
            this.entryMapper = source.entryMapper();
            this.dynamicDestination = source.dynamicDestination();
            this.queueUrl = source.queueUrl();
        }

        @Override
        SqsIO.WriteBatches.Builder<T> concurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> batchTimeout(Duration batchTimeout) {
            if (batchTimeout == null) {
                throw new NullPointerException("Null batchTimeout");
            }
            this.batchTimeout = batchTimeout;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> strictTimeouts(boolean strictTimeouts) {
            this.strictTimeouts = strictTimeouts;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> clientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> entryMapper(@Nullable SqsIO.WriteBatches.EntryMapperFn<T> entryMapper) {
            this.entryMapper = entryMapper;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> dynamicDestination(@Nullable SqsIO.WriteBatches.DynamicDestination<T> dynamicDestination) {
            this.dynamicDestination = dynamicDestination;
            return this;
        }

        @Override
        SqsIO.WriteBatches.Builder<T> queueUrl(@Nullable String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        @Override
        SqsIO.WriteBatches<T> build() {
            if (this.concurrentRequests == null || this.batchTimeout == null || this.strictTimeouts == null || this.batchSize == null || this.clientConfiguration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.concurrentRequests == null) {
                    missing.append(" concurrentRequests");
                }
                if (this.batchTimeout == null) {
                    missing.append(" batchTimeout");
                }
                if (this.strictTimeouts == null) {
                    missing.append(" strictTimeouts");
                }
                if (this.batchSize == null) {
                    missing.append(" batchSize");
                }
                if (this.clientConfiguration == null) {
                    missing.append(" clientConfiguration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqsIO_WriteBatches(this.concurrentRequests, this.batchTimeout, this.strictTimeouts, this.batchSize, this.clientConfiguration, this.entryMapper, this.dynamicDestination, this.queueUrl);
        }
    }
}

