/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.CompilerHints;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.Union;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Visitable;

@Internal
public abstract class Operator<OUT>
implements Visitable<Operator<?>> {
    protected final Configuration parameters;
    protected CompilerHints compilerHints;
    protected String name;
    private int parallelism = -1;
    private ResourceSpec minResources = ResourceSpec.DEFAULT;
    private ResourceSpec preferredResources = ResourceSpec.DEFAULT;
    protected final OperatorInformation<OUT> operatorInfo;

    protected Operator(OperatorInformation<OUT> operatorInfo, String name) {
        this.name = name == null ? "(null)" : name;
        this.parameters = new Configuration();
        this.compilerHints = new CompilerHints();
        this.operatorInfo = operatorInfo;
    }

    public OperatorInformation<OUT> getOperatorInfo() {
        return this.operatorInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompilerHints getCompilerHints() {
        return this.compilerHints;
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    public void setParameter(String key, String value) {
        this.parameters.setString(key, value);
    }

    public void setParameter(String key, int value) {
        this.parameters.setInteger(key, value);
    }

    public void setParameter(String key, boolean value) {
        this.parameters.setBoolean(key, value);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @PublicEvolving
    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    @PublicEvolving
    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    @PublicEvolving
    public void setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        this.minResources = minResources;
        this.preferredResources = preferredResources;
    }

    public UserCodeWrapper<?> getUserCodeWrapper() {
        return null;
    }

    public static <T> Operator<T> createUnionCascade(List<? extends Operator<T>> operators) {
        return Operator.createUnionCascade(operators.toArray(new Operator[operators.size()]));
    }

    public static <T> Operator<T> createUnionCascade(Operator<T> ... operators) {
        return Operator.createUnionCascade(null, operators);
    }

    public static <T> Operator<T> createUnionCascade(Operator<T> input1, Operator<T> ... input2) {
        int i;
        if (input2 == null || input2.length == 0) {
            return input1;
        }
        if (input2.length == 1 && input1 == null) {
            return input2[0];
        }
        TypeInformation<T> type = null;
        if (input1 != null) {
            type = input1.getOperatorInfo().getOutputType();
        } else if (input2.length > 0 && input2[0] != null) {
            type = input2[0].getOperatorInfo().getOutputType();
        } else {
            throw new IllegalArgumentException("Could not determine type information from inputs.");
        }
        Union<T> lastUnion = new Union<T>(new BinaryOperatorInformation<T, T, T>(type, type, type), "<unknown>");
        if (input2[0] == null) {
            throw new IllegalArgumentException("The input may not contain null elements.");
        }
        lastUnion.setFirstInput(input2[0]);
        if (input1 != null) {
            lastUnion.setSecondInput(input1);
            i = 1;
        } else {
            if (input2[1] == null) {
                throw new IllegalArgumentException("The input may not contain null elements.");
            }
            lastUnion.setSecondInput(input2[1]);
            i = 2;
        }
        while (i < input2.length) {
            Union<T> tmpUnion = new Union<T>(new BinaryOperatorInformation<T, T, T>(type, type, type), "<unknown>");
            tmpUnion.setSecondInput(lastUnion);
            if (input2[i] == null) {
                throw new IllegalArgumentException("The input may not contain null elements.");
            }
            tmpUnion.setFirstInput(input2[i]);
            lastUnion = tmpUnion;
            ++i;
        }
        return lastUnion;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.getName();
    }
}

