/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@PublicEvolving
public interface TypeSerializerSnapshot<T> {
    public int getCurrentVersion();

    public void writeSnapshot(DataOutputView var1) throws IOException;

    public void readSnapshot(int var1, DataInputView var2, ClassLoader var3) throws IOException;

    public TypeSerializer<T> restoreSerializer();

    @Deprecated
    default public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        TypeSerializerSnapshot<T> newSerializerSnapshot = newSerializer.snapshotConfiguration();
        try {
            Class<?> subClass = newSerializerSnapshot.getClass().getMethod("resolveSchemaCompatibility", TypeSerializerSnapshot.class).getDeclaringClass();
            if (subClass == TypeSerializerSnapshot.class) {
                throw new UnsupportedOperationException("Must implement at least one method about 'resolveSchemaCompatibility', Recommend strongly to implement TypeSerializerSnapshot#resolveSchemaCompatibility(TypeSerializerSnapshot), see FLIP-263 for more details");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return newSerializerSnapshot.resolveSchemaCompatibility(this);
    }

    default public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        try {
            Class<?> subClass = oldSerializerSnapshot.getClass().getMethod("resolveSchemaCompatibility", TypeSerializer.class).getDeclaringClass();
            if (subClass == TypeSerializerSnapshot.class) {
                throw new UnsupportedOperationException("Must implement at least one method about 'resolveSchemaCompatibility', Recommend strongly to implement TypeSerializerSnapshot#resolveSchemaCompatibility(TypeSerializerSnapshot), see FLIP-263 for more details");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return oldSerializerSnapshot.resolveSchemaCompatibility(this.restoreSerializer());
    }

    public static void writeVersionedSnapshot(DataOutputView out, TypeSerializerSnapshot<?> snapshot) throws IOException {
        out.writeUTF(snapshot.getClass().getName());
        out.writeInt(snapshot.getCurrentVersion());
        snapshot.writeSnapshot(out);
    }

    public static <T> TypeSerializerSnapshot<T> readVersionedSnapshot(DataInputView in, ClassLoader cl) throws IOException {
        TypeSerializerSnapshot snapshot = TypeSerializerSnapshotSerializationUtil.readAndInstantiateSnapshotClass(in, cl);
        int version = in.readInt();
        snapshot.readSnapshot(version, in, cl);
        return snapshot;
    }
}

