/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.math.LongMath;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.TimeProvider;

final class InstantTimeProvider
implements TimeProvider {
    private Method now;
    private Method getNano;
    private Method getEpochSecond;

    public InstantTimeProvider(Class<?> instantClass) {
        try {
            this.now = instantClass.getMethod("now", new Class[0]);
            this.getNano = instantClass.getMethod("getNano", new Class[0]);
            this.getEpochSecond = instantClass.getMethod("getEpochSecond", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public long currentTimeNanos() {
        try {
            Object instant = this.now.invoke(null, new Object[0]);
            int nanos = (Integer)this.getNano.invoke(instant, new Object[0]);
            long epochSeconds = (Long)this.getEpochSecond.invoke(instant, new Object[0]);
            return LongMath.saturatedAdd(TimeUnit.SECONDS.toNanos(epochSeconds), nanos);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

