/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.protobuf.services;

import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.InternalChannelz;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.InternalInstrumented;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.ChannelzGrpc;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetChannelRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetChannelResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServerRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServerResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServerSocketsRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServerSocketsResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServersRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetServersResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetSocketRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetSocketResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetSubchannelRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetSubchannelResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetTopChannelsRequest;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.channelz.v1.GetTopChannelsResponse;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.protobuf.services.ChannelzProtoUtil;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4206")
public final class ChannelzService
extends ChannelzGrpc.ChannelzImplBase {
    private final InternalChannelz channelz;
    private final int maxPageSize;

    public static ChannelzService newInstance(int maxPageSize) {
        return new ChannelzService(InternalChannelz.instance(), maxPageSize);
    }

    @VisibleForTesting
    ChannelzService(InternalChannelz channelz, int maxPageSize) {
        this.channelz = channelz;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void getTopChannels(GetTopChannelsRequest request, StreamObserver<GetTopChannelsResponse> responseObserver) {
        GetTopChannelsResponse resp;
        InternalChannelz.RootChannelList rootChannels = this.channelz.getRootChannels(request.getStartChannelId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetTopChannelResponse(rootChannels);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getChannel(GetChannelRequest request, StreamObserver<GetChannelResponse> responseObserver) {
        GetChannelResponse resp;
        InternalInstrumented<InternalChannelz.ChannelStats> s = this.channelz.getRootChannel(request.getChannelId());
        if (s == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find channel " + request.getChannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetChannelResponse.newBuilder().setChannel(ChannelzProtoUtil.toChannel(s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServers(GetServersRequest request, StreamObserver<GetServersResponse> responseObserver) {
        GetServersResponse resp;
        InternalChannelz.ServerList servers = this.channelz.getServers(request.getStartServerId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetServersResponse(servers);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServer(GetServerRequest request, StreamObserver<GetServerResponse> responseObserver) {
        GetServerResponse resp;
        InternalInstrumented<InternalChannelz.ServerStats> s = this.channelz.getServer(request.getServerId());
        if (s == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = GetServerResponse.newBuilder().setServer(ChannelzProtoUtil.toServer(s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSubchannel(GetSubchannelRequest request, StreamObserver<GetSubchannelResponse> responseObserver) {
        GetSubchannelResponse resp;
        InternalInstrumented<InternalChannelz.ChannelStats> s = this.channelz.getSubchannel(request.getSubchannelId());
        if (s == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find subchannel " + request.getSubchannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSubchannelResponse.newBuilder().setSubchannel(ChannelzProtoUtil.toSubchannel(s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSocket(GetSocketRequest request, StreamObserver<GetSocketResponse> responseObserver) {
        GetSocketResponse resp;
        InternalInstrumented<InternalChannelz.SocketStats> s = this.channelz.getSocket(request.getSocketId());
        if (s == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find socket " + request.getSocketId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSocketResponse.newBuilder().setSocket(ChannelzProtoUtil.toSocket(s)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServerSockets(GetServerSocketsRequest request, StreamObserver<GetServerSocketsResponse> responseObserver) {
        GetServerSocketsResponse resp;
        InternalChannelz.ServerSocketsList serverSockets = this.channelz.getServerSockets(request.getServerId(), request.getStartSocketId(), this.maxPageSize);
        if (serverSockets == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = ChannelzProtoUtil.toGetServerSocketsResponse(serverSockets);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }
}

