/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.storage.control.v2.AnywhereCache;
import com.google.storage.control.v2.AnywhereCacheName;
import com.google.storage.control.v2.BucketName;
import com.google.storage.control.v2.CreateAnywhereCacheMetadata;
import com.google.storage.control.v2.CreateAnywhereCacheRequest;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.CreateManagedFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.DeleteManagedFolderRequest;
import com.google.storage.control.v2.DisableAnywhereCacheRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.FolderName;
import com.google.storage.control.v2.GetAnywhereCacheRequest;
import com.google.storage.control.v2.GetFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetManagedFolderRequest;
import com.google.storage.control.v2.GetOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.GetProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.IntelligenceConfig;
import com.google.storage.control.v2.IntelligenceConfigName;
import com.google.storage.control.v2.ListAnywhereCachesRequest;
import com.google.storage.control.v2.ListAnywhereCachesResponse;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.ListManagedFoldersRequest;
import com.google.storage.control.v2.ListManagedFoldersResponse;
import com.google.storage.control.v2.ManagedFolder;
import com.google.storage.control.v2.ManagedFolderName;
import com.google.storage.control.v2.PauseAnywhereCacheRequest;
import com.google.storage.control.v2.RenameFolderMetadata;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.ResumeAnywhereCacheRequest;
import com.google.storage.control.v2.StorageControlSettings;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.StorageLayoutName;
import com.google.storage.control.v2.UpdateAnywhereCacheMetadata;
import com.google.storage.control.v2.UpdateAnywhereCacheRequest;
import com.google.storage.control.v2.UpdateFolderIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateOrganizationIntelligenceConfigRequest;
import com.google.storage.control.v2.UpdateProjectIntelligenceConfigRequest;
import com.google.storage.control.v2.stub.StorageControlStub;
import com.google.storage.control.v2.stub.StorageControlStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StorageControlClient
implements BackgroundResource {
    private final StorageControlSettings settings;
    private final StorageControlStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final StorageControlClient create() throws IOException {
        return StorageControlClient.create(StorageControlSettings.newBuilder().build());
    }

    public static final StorageControlClient create(StorageControlSettings settings) throws IOException {
        return new StorageControlClient(settings);
    }

    public static final StorageControlClient create(StorageControlStub stub) {
        return new StorageControlClient(stub);
    }

    protected StorageControlClient(StorageControlSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageControlStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected StorageControlClient(StorageControlStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final StorageControlSettings getSettings() {
        return this.settings;
    }

    public StorageControlStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Folder createFolder(BucketName parent, Folder folder, String folderId) {
        CreateFolderRequest request = CreateFolderRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFolder(folder).setFolderId(folderId).build();
        return this.createFolder(request);
    }

    public final Folder createFolder(String parent, Folder folder, String folderId) {
        CreateFolderRequest request = CreateFolderRequest.newBuilder().setParent(parent).setFolder(folder).setFolderId(folderId).build();
        return this.createFolder(request);
    }

    public final Folder createFolder(CreateFolderRequest request) {
        return (Folder)this.createFolderCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFolderRequest, Folder> createFolderCallable() {
        return this.stub.createFolderCallable();
    }

    public final void deleteFolder(FolderName name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFolder(request);
    }

    public final void deleteFolder(String name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name).build();
        this.deleteFolder(request);
    }

    public final void deleteFolder(DeleteFolderRequest request) {
        this.deleteFolderCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable() {
        return this.stub.deleteFolderCallable();
    }

    public final Folder getFolder(FolderName name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(String name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(GetFolderRequest request) {
        return (Folder)this.getFolderCallable().call((Object)request);
    }

    public final UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.stub.getFolderCallable();
    }

    public final ListFoldersPagedResponse listFolders(BucketName parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(String parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(ListFoldersRequest request) {
        return (ListFoldersPagedResponse)((Object)this.listFoldersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.stub.listFoldersPagedCallable();
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.stub.listFoldersCallable();
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(FolderName name, String destinationFolderId) {
        RenameFolderRequest request = RenameFolderRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationFolderId(destinationFolderId).build();
        return this.renameFolderAsync(request);
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(String name, String destinationFolderId) {
        RenameFolderRequest request = RenameFolderRequest.newBuilder().setName(name).setDestinationFolderId(destinationFolderId).build();
        return this.renameFolderAsync(request);
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(RenameFolderRequest request) {
        return this.renameFolderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable() {
        return this.stub.renameFolderOperationCallable();
    }

    public final UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable() {
        return this.stub.renameFolderCallable();
    }

    public final StorageLayout getStorageLayout(StorageLayoutName name) {
        GetStorageLayoutRequest request = GetStorageLayoutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStorageLayout(request);
    }

    public final StorageLayout getStorageLayout(String name) {
        GetStorageLayoutRequest request = GetStorageLayoutRequest.newBuilder().setName(name).build();
        return this.getStorageLayout(request);
    }

    public final StorageLayout getStorageLayout(GetStorageLayoutRequest request) {
        return (StorageLayout)this.getStorageLayoutCallable().call((Object)request);
    }

    public final UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable() {
        return this.stub.getStorageLayoutCallable();
    }

    public final ManagedFolder createManagedFolder(BucketName parent, ManagedFolder managedFolder, String managedFolderId) {
        CreateManagedFolderRequest request = CreateManagedFolderRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setManagedFolder(managedFolder).setManagedFolderId(managedFolderId).build();
        return this.createManagedFolder(request);
    }

    public final ManagedFolder createManagedFolder(String parent, ManagedFolder managedFolder, String managedFolderId) {
        CreateManagedFolderRequest request = CreateManagedFolderRequest.newBuilder().setParent(parent).setManagedFolder(managedFolder).setManagedFolderId(managedFolderId).build();
        return this.createManagedFolder(request);
    }

    public final ManagedFolder createManagedFolder(CreateManagedFolderRequest request) {
        return (ManagedFolder)this.createManagedFolderCallable().call((Object)request);
    }

    public final UnaryCallable<CreateManagedFolderRequest, ManagedFolder> createManagedFolderCallable() {
        return this.stub.createManagedFolderCallable();
    }

    public final void deleteManagedFolder(ManagedFolderName name) {
        DeleteManagedFolderRequest request = DeleteManagedFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteManagedFolder(request);
    }

    public final void deleteManagedFolder(String name) {
        DeleteManagedFolderRequest request = DeleteManagedFolderRequest.newBuilder().setName(name).build();
        this.deleteManagedFolder(request);
    }

    public final void deleteManagedFolder(DeleteManagedFolderRequest request) {
        this.deleteManagedFolderCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteManagedFolderRequest, Empty> deleteManagedFolderCallable() {
        return this.stub.deleteManagedFolderCallable();
    }

    public final ManagedFolder getManagedFolder(ManagedFolderName name) {
        GetManagedFolderRequest request = GetManagedFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getManagedFolder(request);
    }

    public final ManagedFolder getManagedFolder(String name) {
        GetManagedFolderRequest request = GetManagedFolderRequest.newBuilder().setName(name).build();
        return this.getManagedFolder(request);
    }

    public final ManagedFolder getManagedFolder(GetManagedFolderRequest request) {
        return (ManagedFolder)this.getManagedFolderCallable().call((Object)request);
    }

    public final UnaryCallable<GetManagedFolderRequest, ManagedFolder> getManagedFolderCallable() {
        return this.stub.getManagedFolderCallable();
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(BucketName parent) {
        ListManagedFoldersRequest request = ListManagedFoldersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listManagedFolders(request);
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(String parent) {
        ListManagedFoldersRequest request = ListManagedFoldersRequest.newBuilder().setParent(parent).build();
        return this.listManagedFolders(request);
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(ListManagedFoldersRequest request) {
        return (ListManagedFoldersPagedResponse)((Object)this.listManagedFoldersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersPagedResponse> listManagedFoldersPagedCallable() {
        return this.stub.listManagedFoldersPagedCallable();
    }

    public final UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersResponse> listManagedFoldersCallable() {
        return this.stub.listManagedFoldersCallable();
    }

    public final OperationFuture<AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheAsync(BucketName parent, AnywhereCache anywhereCache) {
        CreateAnywhereCacheRequest request = CreateAnywhereCacheRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnywhereCache(anywhereCache).build();
        return this.createAnywhereCacheAsync(request);
    }

    public final OperationFuture<AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheAsync(String parent, AnywhereCache anywhereCache) {
        CreateAnywhereCacheRequest request = CreateAnywhereCacheRequest.newBuilder().setParent(parent).setAnywhereCache(anywhereCache).build();
        return this.createAnywhereCacheAsync(request);
    }

    public final OperationFuture<AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheAsync(CreateAnywhereCacheRequest request) {
        return this.createAnywhereCacheOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAnywhereCacheRequest, AnywhereCache, CreateAnywhereCacheMetadata> createAnywhereCacheOperationCallable() {
        return this.stub.createAnywhereCacheOperationCallable();
    }

    public final UnaryCallable<CreateAnywhereCacheRequest, Operation> createAnywhereCacheCallable() {
        return this.stub.createAnywhereCacheCallable();
    }

    public final OperationFuture<AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheAsync(AnywhereCache anywhereCache, FieldMask updateMask) {
        UpdateAnywhereCacheRequest request = UpdateAnywhereCacheRequest.newBuilder().setAnywhereCache(anywhereCache).setUpdateMask(updateMask).build();
        return this.updateAnywhereCacheAsync(request);
    }

    public final OperationFuture<AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheAsync(UpdateAnywhereCacheRequest request) {
        return this.updateAnywhereCacheOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAnywhereCacheRequest, AnywhereCache, UpdateAnywhereCacheMetadata> updateAnywhereCacheOperationCallable() {
        return this.stub.updateAnywhereCacheOperationCallable();
    }

    public final UnaryCallable<UpdateAnywhereCacheRequest, Operation> updateAnywhereCacheCallable() {
        return this.stub.updateAnywhereCacheCallable();
    }

    public final AnywhereCache disableAnywhereCache(AnywhereCacheName name) {
        DisableAnywhereCacheRequest request = DisableAnywhereCacheRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableAnywhereCache(request);
    }

    public final AnywhereCache disableAnywhereCache(String name) {
        DisableAnywhereCacheRequest request = DisableAnywhereCacheRequest.newBuilder().setName(name).build();
        return this.disableAnywhereCache(request);
    }

    public final AnywhereCache disableAnywhereCache(DisableAnywhereCacheRequest request) {
        return (AnywhereCache)this.disableAnywhereCacheCallable().call((Object)request);
    }

    public final UnaryCallable<DisableAnywhereCacheRequest, AnywhereCache> disableAnywhereCacheCallable() {
        return this.stub.disableAnywhereCacheCallable();
    }

    public final AnywhereCache pauseAnywhereCache(AnywhereCacheName name) {
        PauseAnywhereCacheRequest request = PauseAnywhereCacheRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseAnywhereCache(request);
    }

    public final AnywhereCache pauseAnywhereCache(String name) {
        PauseAnywhereCacheRequest request = PauseAnywhereCacheRequest.newBuilder().setName(name).build();
        return this.pauseAnywhereCache(request);
    }

    public final AnywhereCache pauseAnywhereCache(PauseAnywhereCacheRequest request) {
        return (AnywhereCache)this.pauseAnywhereCacheCallable().call((Object)request);
    }

    public final UnaryCallable<PauseAnywhereCacheRequest, AnywhereCache> pauseAnywhereCacheCallable() {
        return this.stub.pauseAnywhereCacheCallable();
    }

    public final AnywhereCache resumeAnywhereCache(AnywhereCacheName name) {
        ResumeAnywhereCacheRequest request = ResumeAnywhereCacheRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeAnywhereCache(request);
    }

    public final AnywhereCache resumeAnywhereCache(String name) {
        ResumeAnywhereCacheRequest request = ResumeAnywhereCacheRequest.newBuilder().setName(name).build();
        return this.resumeAnywhereCache(request);
    }

    public final AnywhereCache resumeAnywhereCache(ResumeAnywhereCacheRequest request) {
        return (AnywhereCache)this.resumeAnywhereCacheCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeAnywhereCacheRequest, AnywhereCache> resumeAnywhereCacheCallable() {
        return this.stub.resumeAnywhereCacheCallable();
    }

    public final AnywhereCache getAnywhereCache(AnywhereCacheName name) {
        GetAnywhereCacheRequest request = GetAnywhereCacheRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnywhereCache(request);
    }

    public final AnywhereCache getAnywhereCache(String name) {
        GetAnywhereCacheRequest request = GetAnywhereCacheRequest.newBuilder().setName(name).build();
        return this.getAnywhereCache(request);
    }

    public final AnywhereCache getAnywhereCache(GetAnywhereCacheRequest request) {
        return (AnywhereCache)this.getAnywhereCacheCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnywhereCacheRequest, AnywhereCache> getAnywhereCacheCallable() {
        return this.stub.getAnywhereCacheCallable();
    }

    public final ListAnywhereCachesPagedResponse listAnywhereCaches(BucketName parent) {
        ListAnywhereCachesRequest request = ListAnywhereCachesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnywhereCaches(request);
    }

    public final ListAnywhereCachesPagedResponse listAnywhereCaches(String parent) {
        ListAnywhereCachesRequest request = ListAnywhereCachesRequest.newBuilder().setParent(parent).build();
        return this.listAnywhereCaches(request);
    }

    public final ListAnywhereCachesPagedResponse listAnywhereCaches(ListAnywhereCachesRequest request) {
        return (ListAnywhereCachesPagedResponse)((Object)this.listAnywhereCachesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnywhereCachesRequest, ListAnywhereCachesPagedResponse> listAnywhereCachesPagedCallable() {
        return this.stub.listAnywhereCachesPagedCallable();
    }

    public final UnaryCallable<ListAnywhereCachesRequest, ListAnywhereCachesResponse> listAnywhereCachesCallable() {
        return this.stub.listAnywhereCachesCallable();
    }

    public final IntelligenceConfig getProjectIntelligenceConfig(IntelligenceConfigName name) {
        GetProjectIntelligenceConfigRequest request = GetProjectIntelligenceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProjectIntelligenceConfig(request);
    }

    public final IntelligenceConfig getProjectIntelligenceConfig(String name) {
        GetProjectIntelligenceConfigRequest request = GetProjectIntelligenceConfigRequest.newBuilder().setName(name).build();
        return this.getProjectIntelligenceConfig(request);
    }

    public final IntelligenceConfig getProjectIntelligenceConfig(GetProjectIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.getProjectIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectIntelligenceConfigRequest, IntelligenceConfig> getProjectIntelligenceConfigCallable() {
        return this.stub.getProjectIntelligenceConfigCallable();
    }

    public final IntelligenceConfig updateProjectIntelligenceConfig(IntelligenceConfig intelligenceConfig, FieldMask updateMask) {
        UpdateProjectIntelligenceConfigRequest request = UpdateProjectIntelligenceConfigRequest.newBuilder().setIntelligenceConfig(intelligenceConfig).setUpdateMask(updateMask).build();
        return this.updateProjectIntelligenceConfig(request);
    }

    public final IntelligenceConfig updateProjectIntelligenceConfig(UpdateProjectIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.updateProjectIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProjectIntelligenceConfigRequest, IntelligenceConfig> updateProjectIntelligenceConfigCallable() {
        return this.stub.updateProjectIntelligenceConfigCallable();
    }

    public final IntelligenceConfig getFolderIntelligenceConfig(IntelligenceConfigName name) {
        GetFolderIntelligenceConfigRequest request = GetFolderIntelligenceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFolderIntelligenceConfig(request);
    }

    public final IntelligenceConfig getFolderIntelligenceConfig(String name) {
        GetFolderIntelligenceConfigRequest request = GetFolderIntelligenceConfigRequest.newBuilder().setName(name).build();
        return this.getFolderIntelligenceConfig(request);
    }

    public final IntelligenceConfig getFolderIntelligenceConfig(GetFolderIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.getFolderIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetFolderIntelligenceConfigRequest, IntelligenceConfig> getFolderIntelligenceConfigCallable() {
        return this.stub.getFolderIntelligenceConfigCallable();
    }

    public final IntelligenceConfig updateFolderIntelligenceConfig(IntelligenceConfig intelligenceConfig, FieldMask updateMask) {
        UpdateFolderIntelligenceConfigRequest request = UpdateFolderIntelligenceConfigRequest.newBuilder().setIntelligenceConfig(intelligenceConfig).setUpdateMask(updateMask).build();
        return this.updateFolderIntelligenceConfig(request);
    }

    public final IntelligenceConfig updateFolderIntelligenceConfig(UpdateFolderIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.updateFolderIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFolderIntelligenceConfigRequest, IntelligenceConfig> updateFolderIntelligenceConfigCallable() {
        return this.stub.updateFolderIntelligenceConfigCallable();
    }

    public final IntelligenceConfig getOrganizationIntelligenceConfig(IntelligenceConfigName name) {
        GetOrganizationIntelligenceConfigRequest request = GetOrganizationIntelligenceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganizationIntelligenceConfig(request);
    }

    public final IntelligenceConfig getOrganizationIntelligenceConfig(String name) {
        GetOrganizationIntelligenceConfigRequest request = GetOrganizationIntelligenceConfigRequest.newBuilder().setName(name).build();
        return this.getOrganizationIntelligenceConfig(request);
    }

    public final IntelligenceConfig getOrganizationIntelligenceConfig(GetOrganizationIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.getOrganizationIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationIntelligenceConfigRequest, IntelligenceConfig> getOrganizationIntelligenceConfigCallable() {
        return this.stub.getOrganizationIntelligenceConfigCallable();
    }

    public final IntelligenceConfig updateOrganizationIntelligenceConfig(IntelligenceConfig intelligenceConfig, FieldMask updateMask) {
        UpdateOrganizationIntelligenceConfigRequest request = UpdateOrganizationIntelligenceConfigRequest.newBuilder().setIntelligenceConfig(intelligenceConfig).setUpdateMask(updateMask).build();
        return this.updateOrganizationIntelligenceConfig(request);
    }

    public final IntelligenceConfig updateOrganizationIntelligenceConfig(UpdateOrganizationIntelligenceConfigRequest request) {
        return (IntelligenceConfig)this.updateOrganizationIntelligenceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateOrganizationIntelligenceConfigRequest, IntelligenceConfig> updateOrganizationIntelligenceConfigCallable() {
        return this.stub.updateOrganizationIntelligenceConfigCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFoldersPagedResponse
    extends AbstractPagedListResponse<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        public static ApiFuture<ListFoldersPagedResponse> createAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            ApiFuture<ListFoldersPage> futurePage = ListFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFoldersPagedResponse((ListFoldersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFoldersPagedResponse(ListFoldersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFoldersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagedFoldersPagedResponse
    extends AbstractPagedListResponse<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage, ListManagedFoldersFixedSizeCollection> {
        public static ApiFuture<ListManagedFoldersPagedResponse> createAsync(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ApiFuture<ListManagedFoldersResponse> futureResponse) {
            ApiFuture<ListManagedFoldersPage> futurePage = ListManagedFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagedFoldersPagedResponse((ListManagedFoldersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagedFoldersPagedResponse(ListManagedFoldersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagedFoldersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnywhereCachesPagedResponse
    extends AbstractPagedListResponse<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache, ListAnywhereCachesPage, ListAnywhereCachesFixedSizeCollection> {
        public static ApiFuture<ListAnywhereCachesPagedResponse> createAsync(PageContext<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache> context, ApiFuture<ListAnywhereCachesResponse> futureResponse) {
            ApiFuture<ListAnywhereCachesPage> futurePage = ListAnywhereCachesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnywhereCachesPagedResponse((ListAnywhereCachesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnywhereCachesPagedResponse(ListAnywhereCachesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnywhereCachesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnywhereCachesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache, ListAnywhereCachesPage, ListAnywhereCachesFixedSizeCollection> {
        private ListAnywhereCachesFixedSizeCollection(List<ListAnywhereCachesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnywhereCachesFixedSizeCollection createEmptyCollection() {
            return new ListAnywhereCachesFixedSizeCollection(null, 0);
        }

        protected ListAnywhereCachesFixedSizeCollection createCollection(List<ListAnywhereCachesPage> pages, int collectionSize) {
            return new ListAnywhereCachesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnywhereCachesPage
    extends AbstractPage<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache, ListAnywhereCachesPage> {
        private ListAnywhereCachesPage(PageContext<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache> context, ListAnywhereCachesResponse response) {
            super(context, (Object)response);
        }

        private static ListAnywhereCachesPage createEmptyPage() {
            return new ListAnywhereCachesPage(null, null);
        }

        protected ListAnywhereCachesPage createPage(PageContext<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache> context, ListAnywhereCachesResponse response) {
            return new ListAnywhereCachesPage(context, response);
        }

        public ApiFuture<ListAnywhereCachesPage> createPageAsync(PageContext<ListAnywhereCachesRequest, ListAnywhereCachesResponse, AnywhereCache> context, ApiFuture<ListAnywhereCachesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagedFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage, ListManagedFoldersFixedSizeCollection> {
        private ListManagedFoldersFixedSizeCollection(List<ListManagedFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagedFoldersFixedSizeCollection createEmptyCollection() {
            return new ListManagedFoldersFixedSizeCollection(null, 0);
        }

        protected ListManagedFoldersFixedSizeCollection createCollection(List<ListManagedFoldersPage> pages, int collectionSize) {
            return new ListManagedFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagedFoldersPage
    extends AbstractPage<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage> {
        private ListManagedFoldersPage(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ListManagedFoldersResponse response) {
            super(context, (Object)response);
        }

        private static ListManagedFoldersPage createEmptyPage() {
            return new ListManagedFoldersPage(null, null);
        }

        protected ListManagedFoldersPage createPage(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ListManagedFoldersResponse response) {
            return new ListManagedFoldersPage(context, response);
        }

        public ApiFuture<ListManagedFoldersPage> createPageAsync(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ApiFuture<ListManagedFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        private ListFoldersFixedSizeCollection(List<ListFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFoldersFixedSizeCollection createEmptyCollection() {
            return new ListFoldersFixedSizeCollection(null, 0);
        }

        protected ListFoldersFixedSizeCollection createCollection(List<ListFoldersPage> pages, int collectionSize) {
            return new ListFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFoldersPage
    extends AbstractPage<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage> {
        private ListFoldersPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            super(context, (Object)response);
        }

        private static ListFoldersPage createEmptyPage() {
            return new ListFoldersPage(null, null);
        }

        protected ListFoldersPage createPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            return new ListFoldersPage(context, response);
        }

        public ApiFuture<ListFoldersPage> createPageAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

