/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.client;

import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.ScramMechanism;
import com.ongres.scram.common.ScramMechanisms;
import com.ongres.scram.common.gssapi.Gs2CbindFlag;
import com.ongres.scram.common.stringprep.StringPreparation;
import com.ongres.scram.common.util.CryptoUtil;
import com.ongres.scram.common.util.Preconditions;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ScramClient {
    public static final int DEFAULT_NONCE_LENGTH = 24;
    private final ChannelBinding channelBinding;
    private final StringPreparation stringPreparation;
    private final ScramMechanism scramMechanism;
    private final SecureRandom secureRandom;
    private final Supplier<String> nonceSupplier;

    private ScramClient(ChannelBinding channelBinding, StringPreparation stringPreparation, Optional<ScramMechanism> nonChannelBindingMechanism, Optional<ScramMechanism> channelBindingMechanism, SecureRandom secureRandom, Supplier<String> nonceSupplier) {
        assert (null != channelBinding) : "channelBinding";
        assert (null != stringPreparation) : "stringPreparation";
        assert (nonChannelBindingMechanism.isPresent() || channelBindingMechanism.isPresent()) : "Either a channel-binding or a non-binding mechanism must be present";
        assert (null != secureRandom) : "secureRandom";
        assert (null != nonceSupplier) : "nonceSupplier";
        this.channelBinding = channelBinding;
        this.stringPreparation = stringPreparation;
        this.scramMechanism = nonChannelBindingMechanism.orElseGet(() -> (ScramMechanism)channelBindingMechanism.get());
        this.secureRandom = secureRandom;
        this.nonceSupplier = nonceSupplier;
    }

    public static PreBuilder1 channelBinding(ChannelBinding channelBinding) throws IllegalArgumentException {
        return new PreBuilder1((ChannelBinding)((Object)Preconditions.checkNotNull((Object)((Object)channelBinding), (String)"channelBinding")));
    }

    public StringPreparation getStringPreparation() {
        return this.stringPreparation;
    }

    public ScramMechanism getScramMechanism() {
        return this.scramMechanism;
    }

    public static List<String> supportedMechanisms() {
        return Arrays.stream(ScramMechanisms.values()).map(m -> m.getName()).collect(Collectors.toList());
    }

    public ScramSession scramSession(String user) {
        return new ScramSession(this.scramMechanism, this.stringPreparation, Preconditions.checkNotEmpty((String)user, (String)"user"), this.nonceSupplier.get());
    }

    public static class Builder
    extends PreBuilder2 {
        private final Optional<ScramMechanism> nonChannelBindingMechanism;
        private final Optional<ScramMechanism> channelBindingMechanism;
        private SecureRandom secureRandom = new SecureRandom();
        private Supplier<String> nonceSupplier;
        private int nonceLength = 24;

        private Builder(ChannelBinding channelBinding, StringPreparation stringPreparation, Optional<ScramMechanism> nonChannelBindingMechanism, Optional<ScramMechanism> channelBindingMechanism) {
            super(channelBinding, stringPreparation);
            this.nonChannelBindingMechanism = nonChannelBindingMechanism;
            this.channelBindingMechanism = channelBindingMechanism;
        }

        public Builder secureRandomAlgorithmProvider(String algorithm, String provider) throws IllegalArgumentException {
            Preconditions.checkNotNull((Object)algorithm, (String)"algorithm");
            try {
                this.secureRandom = null == provider ? SecureRandom.getInstance(algorithm) : SecureRandom.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new IllegalArgumentException("Invalid algorithm or provider", e);
            }
            return this;
        }

        public Builder nonceSupplier(Supplier<String> nonceSupplier) throws IllegalArgumentException {
            this.nonceSupplier = (Supplier)Preconditions.checkNotNull(nonceSupplier, (String)"nonceSupplier");
            return this;
        }

        public Builder nonceLength(int length) throws IllegalArgumentException {
            this.nonceLength = Preconditions.gt0((int)length, (String)"length");
            return this;
        }

        public ScramClient setup() {
            return new ScramClient(this.channelBinding, this.stringPreparation, this.nonChannelBindingMechanism, this.channelBindingMechanism, this.secureRandom, this.nonceSupplier != null ? this.nonceSupplier : () -> CryptoUtil.nonce((int)this.nonceLength, (SecureRandom)this.secureRandom));
        }
    }

    public static class PreBuilder2
    extends PreBuilder1 {
        protected final StringPreparation stringPreparation;
        protected Optional<ScramMechanism> nonChannelBindingMechanism = Optional.empty();
        protected Optional<ScramMechanism> channelBindingMechanism = Optional.empty();

        private PreBuilder2(ChannelBinding channelBinding, StringPreparation stringPreparation) {
            super(channelBinding);
            this.stringPreparation = stringPreparation;
        }

        public Builder selectMechanismBasedOnServerAdvertised(String ... serverMechanisms) {
            Preconditions.checkArgument((null != serverMechanisms && serverMechanisms.length > 0 ? 1 : 0) != 0, (String)"serverMechanisms");
            this.nonChannelBindingMechanism = ScramMechanisms.selectMatchingMechanism((boolean)false, (String[])serverMechanisms);
            if (this.channelBinding == ChannelBinding.NO && !this.nonChannelBindingMechanism.isPresent()) {
                throw new IllegalArgumentException("Server does not support non channel binding mechanisms");
            }
            this.channelBindingMechanism = ScramMechanisms.selectMatchingMechanism((boolean)true, (String[])serverMechanisms);
            if (this.channelBinding == ChannelBinding.YES && !this.channelBindingMechanism.isPresent()) {
                throw new IllegalArgumentException("Server does not support channel binding mechanisms");
            }
            if (!this.channelBindingMechanism.isPresent() && !this.nonChannelBindingMechanism.isPresent()) {
                throw new IllegalArgumentException("There are no matching mechanisms between client and server");
            }
            return new Builder(this.channelBinding, this.stringPreparation, this.nonChannelBindingMechanism, this.channelBindingMechanism);
        }

        public Builder selectMechanismBasedOnServerAdvertisedCsv(String serverMechanismsCsv) throws IllegalArgumentException {
            return this.selectMechanismBasedOnServerAdvertised(((String)Preconditions.checkNotNull((Object)serverMechanismsCsv, (String)"serverMechanismsCsv")).split(","));
        }

        public Builder selectClientMechanism(ScramMechanism scramMechanism) {
            Preconditions.checkNotNull((Object)scramMechanism, (String)"scramMechanism");
            if (this.channelBinding == ChannelBinding.IF_SERVER_SUPPORTS_IT) {
                throw new IllegalArgumentException("If server selection is considered, no direct client selection should be performed");
            }
            if (this.channelBinding == ChannelBinding.YES && !scramMechanism.supportsChannelBinding() || this.channelBinding == ChannelBinding.NO && scramMechanism.supportsChannelBinding()) {
                throw new IllegalArgumentException("Incompatible selection of mechanism and channel binding");
            }
            if (scramMechanism.supportsChannelBinding()) {
                return new Builder(this.channelBinding, this.stringPreparation, Optional.empty(), Optional.of(scramMechanism));
            }
            return new Builder(this.channelBinding, this.stringPreparation, Optional.of(scramMechanism), Optional.empty());
        }
    }

    public static class PreBuilder1 {
        protected final ChannelBinding channelBinding;

        private PreBuilder1(ChannelBinding channelBinding) {
            this.channelBinding = channelBinding;
        }

        public PreBuilder2 stringPreparation(StringPreparation stringPreparation) throws IllegalArgumentException {
            return new PreBuilder2(this.channelBinding, (StringPreparation)Preconditions.checkNotNull((Object)stringPreparation, (String)"stringPreparation"));
        }
    }

    public static enum ChannelBinding {
        NO(Gs2CbindFlag.CLIENT_NOT),
        YES(Gs2CbindFlag.CHANNEL_BINDING_REQUIRED),
        IF_SERVER_SUPPORTS_IT(Gs2CbindFlag.CLIENT_YES_SERVER_NOT);

        private final Gs2CbindFlag gs2CbindFlag;

        private ChannelBinding(Gs2CbindFlag gs2CbindFlag) {
            this.gs2CbindFlag = gs2CbindFlag;
        }

        public Gs2CbindFlag gs2CbindFlag() {
            return this.gs2CbindFlag;
        }
    }
}

