/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceDStream;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.stateful.StateSpecFunctions;
import org.apache.beam.runners.spark.translation.streaming.UnboundedDataset;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public class SparkUnboundedSource {
    public static <T, CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized UnboundedDataset<T> read(@UnknownKeyFor @NonNull @Initialized JavaStreamingContext jssc, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions rc, @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> source, @UnknownKeyFor @NonNull @Initialized String stepName) {
        SparkPipelineOptions options = (SparkPipelineOptions)rc.get().as(SparkPipelineOptions.class);
        Long maxRecordsPerBatch = options.getMaxRecordsPerBatch();
        SourceDStream<T, CheckpointMarkT> sourceDStream = new SourceDStream<T, CheckpointMarkT>(jssc.ssc(), source, rc, maxRecordsPerBatch);
        JavaPairInputDStream inputDStream = JavaPairInputDStream$.MODULE$.fromInputDStream(sourceDStream, JavaSparkContext$.MODULE$.fakeClassTag(), JavaSparkContext$.MODULE$.fakeClassTag());
        JavaMapWithStateDStream mapWithStateDStream = inputDStream.mapWithState(StateSpec.function(StateSpecFunctions.mapSourceFunction(rc, stepName)).numPartitions(sourceDStream.getNumPartitions()));
        SparkUnboundedSource.checkpointStream(mapWithStateDStream, options);
        int id = inputDStream.inputDStream().id();
        JavaDStream metadataDStream = mapWithStateDStream.map((Function)new Tuple2MetadataFunction());
        new ReadReportDStream((DStream<Metadata>)metadataDStream.dstream(), id, SparkUnboundedSource.getSourceName(source, id), stepName).register();
        WindowedValues.FullWindowedValueCoder coder = WindowedValues.FullWindowedValueCoder.of((Coder)source.getOutputCoder(), (Coder)GlobalWindow.Coder.INSTANCE);
        JavaDStream readUnboundedStream = mapWithStateDStream.flatMap((FlatMapFunction)new Tuple2byteFlatMapFunction()).map(CoderHelpers.fromByteFunction(coder));
        return new UnboundedDataset(readUnboundedStream, Collections.singletonList(id));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized String getSourceName(@UnknownKeyFor @NonNull @Initialized Source<T> source, @UnknownKeyFor @NonNull @Initialized int id) {
        StringBuilder sb = new StringBuilder();
        for (String s : Splitter.onPattern((String)"(?=[A-Z])").split((CharSequence)source.getClass().getSimpleName().replace("$", ""))) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            sb.append(trimmed).append(" ");
        }
        return sb.append("[").append(id).append("]").toString();
    }

    private static void checkpointStream(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dStream, @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options) {
        long checkpointDurationMillis = options.getCheckpointDurationMillis();
        if (checkpointDurationMillis > 0L) {
            dStream.checkpoint(new Duration(checkpointDurationMillis));
        }
    }

    private static class Tuple2byteFlatMapFunction
    implements FlatMapFunction<Tuple2<Iterable<byte[]>, Metadata>, byte[]> {
        private Tuple2byteFlatMapFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> call(@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized Metadata> t2) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return ((Iterable)t2._1()).iterator();
        }
    }

    private static class Tuple2MetadataFunction
    implements Function<Tuple2<Iterable<byte[]>, Metadata>, Metadata> {
        private Tuple2MetadataFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized Metadata call(@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>, @UnknownKeyFor @NonNull @Initialized Metadata> t2) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return (Metadata)t2._2();
        }
    }

    public static class Metadata
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized long numRecords;
        private final @UnknownKeyFor @NonNull @Initialized Instant lowWatermark;
        private final @UnknownKeyFor @NonNull @Initialized Instant highWatermark;
        private final @UnknownKeyFor @NonNull @Initialized long readDurationMillis;
        private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainers;

        public Metadata(@UnknownKeyFor @NonNull @Initialized long numRecords, @UnknownKeyFor @NonNull @Initialized Instant lowWatermark, @UnknownKeyFor @NonNull @Initialized Instant highWatermark, @UnknownKeyFor @NonNull @Initialized long readDurationMillis, @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainer) {
            this.numRecords = numRecords;
            this.readDurationMillis = readDurationMillis;
            this.metricsContainers = metricsContainer;
            this.lowWatermark = lowWatermark;
            this.highWatermark = highWatermark;
        }

        @UnknownKeyFor @NonNull @Initialized long getNumRecords() {
            return this.numRecords;
        }

        @UnknownKeyFor @NonNull @Initialized Instant getLowWatermark() {
            return this.lowWatermark;
        }

        @UnknownKeyFor @NonNull @Initialized Instant getHighWatermark() {
            return this.highWatermark;
        }

        @UnknownKeyFor @NonNull @Initialized long getReadDurationMillis() {
            return this.readDurationMillis;
        }

        @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap getMetricsContainers() {
            return this.metricsContainers;
        }
    }

    private static class ReadReportDStream
    extends DStream<BoxedUnit> {
        private static final @UnknownKeyFor @NonNull @Initialized String READ_DURATION_MILLIS = "readDurationMillis";
        private static final @UnknownKeyFor @NonNull @Initialized String NAMESPACE = "spark-runner.io";
        private final @UnknownKeyFor @NonNull @Initialized DStream<@UnknownKeyFor @NonNull @Initialized Metadata> parent;
        private final @UnknownKeyFor @NonNull @Initialized int inputDStreamId;
        private final @UnknownKeyFor @NonNull @Initialized String sourceName;
        private final @UnknownKeyFor @NonNull @Initialized String stepName;

        ReadReportDStream(@UnknownKeyFor @NonNull @Initialized DStream<@UnknownKeyFor @NonNull @Initialized Metadata> parent, @UnknownKeyFor @NonNull @Initialized int inputDStreamId, @UnknownKeyFor @NonNull @Initialized String sourceName, @UnknownKeyFor @NonNull @Initialized String stepName) {
            super(parent.ssc(), JavaSparkContext$.MODULE$.fakeClassTag());
            this.parent = parent;
            this.inputDStreamId = inputDStreamId;
            this.sourceName = sourceName;
            this.stepName = stepName;
        }

        public @UnknownKeyFor @NonNull @Initialized Duration slideDuration() {
            return this.parent.slideDuration();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dependencies() {
            return JavaConversions.asScalaBuffer(Collections.singletonList(this.parent)).toList();
        }

        public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized BoxedUnit>> compute(@UnknownKeyFor @NonNull @Initialized Time validTime) {
            Option parentRDDOpt = this.parent.getOrCompute(validTime);
            MetricsContainerStepMapAccumulator metricsAccum = MetricsAccumulator.getInstance();
            long count = 0L;
            GlobalWatermarkHolder.SparkWatermarks sparkWatermark = null;
            Instant globalLowWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            Instant globalHighWatermarkForBatch = BoundedWindow.TIMESTAMP_MIN_VALUE;
            long maxReadDuration = 0L;
            if (parentRDDOpt.isDefined()) {
                JavaRDD parentRDD = ((RDD)parentRDDOpt.get()).toJavaRDD();
                for (Metadata metadata : parentRDD.collect()) {
                    count += metadata.getNumRecords();
                    Instant partitionLowWatermark = metadata.getLowWatermark();
                    globalLowWatermarkForBatch = globalLowWatermarkForBatch.isBefore((ReadableInstant)partitionLowWatermark) ? partitionLowWatermark : globalLowWatermarkForBatch;
                    Instant partitionHighWatermark = metadata.getHighWatermark();
                    globalHighWatermarkForBatch = globalHighWatermarkForBatch.isBefore((ReadableInstant)partitionHighWatermark) ? partitionHighWatermark : globalHighWatermarkForBatch;
                    Gauge gauge = Metrics.gauge((String)NAMESPACE, (String)READ_DURATION_MILLIS);
                    MetricsContainerImpl container = metadata.getMetricsContainers().getContainer(this.stepName);
                    try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)container);){
                        long readDurationMillis = metadata.getReadDurationMillis();
                        if (readDurationMillis > maxReadDuration) {
                            gauge.set(readDurationMillis);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    metricsAccum.value().updateAll(metadata.getMetricsContainers());
                }
                sparkWatermark = new GlobalWatermarkHolder.SparkWatermarks(globalLowWatermarkForBatch, globalHighWatermarkForBatch, new Instant(validTime.milliseconds()));
                GlobalWatermarkHolder.add(this.inputDStreamId, sparkWatermark);
            }
            this.report(validTime, count, sparkWatermark);
            return Option.empty();
        }

        private void report(@UnknownKeyFor @NonNull @Initialized Time batchTime, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized GlobalWatermarkHolder.SparkWatermarks sparkWatermark) {
            Map.Map1 metadata = new Map.Map1((Object)StreamInputInfo.METADATA_KEY_DESCRIPTION(), (Object)String.format("Read %d records with observed watermarks %s, from %s for batch time: %s", count, sparkWatermark == null ? "N/A" : sparkWatermark, this.sourceName, batchTime));
            StreamInputInfo streamInputInfo = new StreamInputInfo(this.inputDStreamId, count, (Map)metadata);
            this.ssc().scheduler().inputInfoTracker().reportInfo(batchTime, streamInputInfo);
        }
    }
}

