/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import java.util.Deque;
import java.util.Iterator;
import java.util.function.Supplier;

public abstract class CachingObjectsSupplier<T>
implements Supplier<T> {
    private Iterator<T> iterator;
    private Deque<T> cache;

    public CachingObjectsSupplier(Deque<T> cache, int preallocate) {
        this.cache = cache;
    }

    @Override
    public T get() {
        T obj;
        if (this.iterator.hasNext()) {
            obj = this.iterator.next();
        } else {
            obj = this.create();
            this.cache.addFirst(obj);
        }
        return obj;
    }

    public void reset() {
        this.iterator = this.cache.iterator();
    }

    public abstract T create();
}

