/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rowsfromresult;

import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowsfromresult.RowsFromResultData;
import org.apache.hop.pipeline.transforms.rowsfromresult.RowsFromResultMeta;

public class RowsFromResult
extends BaseTransform<RowsFromResultMeta, RowsFromResultData> {
    private static final Class<?> PKG = RowsFromResult.class;

    public RowsFromResult(TransformMeta transformMeta, RowsFromResultMeta meta, RowsFromResultData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Result previousResult = this.getPipeline().getPreviousResult();
        if (previousResult == null || this.getLinesRead() >= (long)previousResult.getRows().size()) {
            this.setOutputDone();
            return false;
        }
        RowMetaAndData row = (RowMetaAndData)previousResult.getRows().get((int)this.getLinesRead());
        this.incrementLinesRead();
        ((RowsFromResultData)this.data).outputRowMeta = row.getRowMeta();
        this.putRow(((RowsFromResultData)this.data).outputRowMeta, row.getData());
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"RowsFromResult.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }
}

