/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.vertica;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.databases.vertica.VerticaDatabaseMeta;

@DatabaseMetaPlugin(type="VERTICA5", typeDescription="Vertica 5", documentationUrl="/database/databases/vertica.html", classLoaderGroup="vertica5")
@GuiPlugin(id="GUI-Vertica5DatabaseMeta")
public class Vertica5DatabaseMeta
extends VerticaDatabaseMeta {
    @Override
    public String getDriverClass() {
        return "com.vertica.jdbc.Driver";
    }

    @Override
    public boolean isSupportsTimeStampToDateConversion() {
        return false;
    }

    public Object getValueFromResultSet(ResultSet rs, IValueMeta val, int index) throws HopDatabaseException {
        Date data;
        try {
            switch (val.getType()) {
                case 3: 
                case 9: {
                    if (val.getOriginalColumnType() == 93) {
                        data = rs.getTimestamp(index + 1);
                        break;
                    }
                    if (val.getOriginalColumnType() == 92) {
                        data = rs.getTime(index + 1);
                        break;
                    }
                    data = rs.getDate(index + 1);
                    break;
                }
                default: {
                    return super.getValueFromResultSet(rs, val, index);
                }
            }
            if (rs.wasNull()) {
                data = null;
            }
        }
        catch (SQLException e) {
            throw new HopDatabaseException("Unable to get value '" + val.toStringMeta() + "' from database resultset, index " + index, (Throwable)e);
        }
        return data;
    }
}

