/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.ext.awt.image.codec.png.PNGRegistryEntry;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.SwingUniversalImage;
import org.apache.hop.core.SwingUniversalImageSvg;
import org.apache.hop.core.SwtUniversalImage;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SwtUniversalImageSvg
extends SwtUniversalImage {
    private final GraphicsNode svgGraphicsNode;
    private final Dimension2D svgGraphicsSize;

    public SwtUniversalImageSvg(SvgImage svg) {
        this(svg, false);
    }

    public SwtUniversalImageSvg(SvgImage svg, boolean keepOriginal) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        GVTBuilder builder = new GVTBuilder();
        if (!keepOriginal && PropsUi.getInstance().isDarkMode()) {
            DOMImplementation domImplementation = SVGDOMImplementation.getDOMImplementation();
            SVGDocument clonedDocument = (SVGDocument)DOMUtilities.deepCloneDocument((Document)svg.getDocument(), (DOMImplementation)domImplementation);
            SVGSVGElement root = clonedDocument.getRootElement();
            Map<String, String> colorsMap = PropsUi.getInstance().getContrastingColorStrings();
            List<String> tags = Arrays.asList("path", "fill", "bordercolor", "fillcolor", "style", "text", "polygon", "rect", "circle", "ellipse", "stop", "tspan", "polyline", "mask");
            this.contrastColors(root, tags, colorsMap);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgentAdapter);
            ctx.setDynamic(true);
            this.svgGraphicsNode = builder.build(ctx, (Document)clonedDocument);
            this.svgGraphicsSize = ctx.getDocumentSize();
        } else {
            DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgentAdapter);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgentAdapter, documentLoader);
            this.svgGraphicsNode = builder.build(ctx, svg.getDocument());
            this.svgGraphicsSize = ctx.getDocumentSize();
        }
    }

    private void contrastColors(SVGSVGElement root, List<String> tags, Map<String, String> colorsMap) {
        for (String tag : tags) {
            NodeList nodeList = root.getElementsByTagName(tag);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int x = 0; x < namedNodeMap.getLength(); ++x) {
                    String newColor;
                    Node namedNode = namedNodeMap.item(x);
                    String value = namedNode.getNodeValue();
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    String changedValue = value.toLowerCase();
                    HashMap<String, String> detectedColors = new HashMap<String, String>();
                    for (String oldColor : colorsMap.keySet()) {
                        if (!changedValue.contains(oldColor)) continue;
                        newColor = colorsMap.get(oldColor);
                        detectedColors.put(oldColor, newColor);
                    }
                    if (detectedColors.isEmpty()) continue;
                    for (String oldColor : detectedColors.keySet()) {
                        newColor = (String)detectedColors.get(oldColor);
                        changedValue = changedValue.replace(oldColor, newColor);
                    }
                    namedNode.setNodeValue(changedValue);
                }
            }
        }
    }

    @Override
    protected Image renderSimple(Device device) {
        return this.renderSimple(device, (int)Math.round(this.svgGraphicsSize.getWidth()), (int)Math.round(this.svgGraphicsSize.getHeight()));
    }

    @Override
    protected Image renderSimple(Device device, int width, int height) {
        BufferedImage area = SwingUniversalImage.createBitmap((int)width, (int)height);
        Graphics2D gc = SwingUniversalImage.createGraphics((BufferedImage)area);
        SwingUniversalImageSvg.render((Graphics2D)gc, (GraphicsNode)this.svgGraphicsNode, (Dimension2D)this.svgGraphicsSize, (int)(width / 2), (int)(height / 2), (int)width, (int)height, (double)0.0);
        gc.dispose();
        return this.swing2swt(device, area);
    }

    @Override
    protected Image renderRotated(Device device, int width, int height, double angleRadians) {
        BufferedImage doubleArea = SwingUniversalImage.createDoubleBitmap((int)width, (int)height);
        Graphics2D gc = SwingUniversalImage.createGraphics((BufferedImage)doubleArea);
        SwingUniversalImageSvg.render((Graphics2D)gc, (GraphicsNode)this.svgGraphicsNode, (Dimension2D)this.svgGraphicsSize, (int)(doubleArea.getWidth() / 2), (int)(doubleArea.getHeight() / 2), (int)width, (int)height, (double)angleRadians);
        gc.dispose();
        return this.swing2swt(device, doubleArea);
    }

    static {
        ImageTagRegistry registry = ImageTagRegistry.getRegistry();
        registry.register((RegistryEntry)new PNGRegistryEntry());
    }
}

