/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.shared;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IGuiSize;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.gui.SnapAllignDistribute;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.HopToolTip;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IGraphSnapAlignDistribute;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.execution.DragViewZoomBase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class HopGuiAbstractGraph
extends DragViewZoomBase
implements IGraphSnapAlignDistribute {
    public static final String STATE_MAGNIFICATION = "magnification";
    public static final String STATE_SCROLL_X_SELECTION = "offset-x";
    public static final String STATE_SCROLL_Y_SELECTION = "offset-y";
    protected final String id;
    protected HopGui hopGui;
    protected IVariables variables;
    protected Composite parentComposite;
    protected Point iconOffset;
    protected Point noteOffset;
    protected Rectangle resizeArea;
    protected Resize resize;
    protected HopToolTip toolTip;
    protected String mouseOverName;
    protected Map<String, Object> stateMap;

    public HopGuiAbstractGraph(HopGui hopGui, Composite parent, int style) {
        super(parent, style);
        this.parentComposite = parent;
        this.hopGui = hopGui;
        this.variables = new Variables();
        this.variables.copyFrom(hopGui.getVariables());
        this.id = UUID.randomUUID().toString();
        this.stateMap = new HashMap<String, Object>();
        this.offset = new DPoint(0.0, 0.0);
    }

    protected Shell hopShell() {
        return this.hopGui.getShell();
    }

    protected Display hopDisplay() {
        return this.hopGui.getDisplay();
    }

    public abstract boolean hasChanged();

    public abstract void setChanged();

    @Override
    public void redraw() {
        if (this.isDisposed() || this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        this.canvas.redraw();
    }

    public boolean forceFocus() {
        return this.canvas.forceFocus();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getStateProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE_MAGNIFICATION, Float.valueOf(this.magnification));
        map.put(STATE_SCROLL_X_SELECTION, this.offset.x);
        map.put(STATE_SCROLL_Y_SELECTION, this.offset.y);
        return map;
    }

    public void applyStateProperties(Map<String, Object> stateProperties) {
        Object yOffset;
        Double fMagnification = (Double)stateProperties.get(STATE_MAGNIFICATION);
        this.magnification = fMagnification == null ? 1.0f : fMagnification.floatValue();
        this.setZoomLabel();
        Object xOffset = stateProperties.get(STATE_SCROLL_X_SELECTION);
        if (xOffset != null) {
            this.offset.x = Double.parseDouble(xOffset.toString());
        }
        if ((yOffset = stateProperties.get(STATE_SCROLL_Y_SELECTION)) != null) {
            this.offset.y = Double.parseDouble(yOffset.toString());
        }
        this.redraw();
    }

    protected void showToolTip(org.eclipse.swt.graphics.Point location) {
        org.eclipse.swt.graphics.Point p = this.canvas.toDisplay(location);
        this.toolTip.setLocation(p.x + 5, p.y + 5);
        this.toolTip.setVisible(true);
    }

    @Override
    public abstract SnapAllignDistribute createSnapAlignDistribute();

    @Override
    public void snapToGrid() {
        this.snapToGrid(16);
    }

    private void snapToGrid(int size) {
        this.createSnapAlignDistribute().snapToGrid(size);
        this.setChanged();
    }

    @Override
    public void alignLeft() {
        this.createSnapAlignDistribute().allignleft();
        this.setChanged();
    }

    @Override
    public void alignRight() {
        this.createSnapAlignDistribute().allignright();
        this.setChanged();
    }

    @Override
    public void alignTop() {
        this.createSnapAlignDistribute().alligntop();
        this.setChanged();
    }

    @Override
    public void alignBottom() {
        this.createSnapAlignDistribute().allignbottom();
        this.setChanged();
    }

    @Override
    @GuiKeyboardShortcut(alt=true, key=0x1000004)
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000004)
    public void distributeHorizontal() {
        this.createSnapAlignDistribute().distributehorizontal();
        this.setChanged();
    }

    @Override
    @GuiOsxKeyboardShortcut(alt=true, key=0x1000001)
    public void distributeVertical() {
        this.createSnapAlignDistribute().distributevertical();
        this.setChanged();
    }

    public Resize getResize(Rectangle rectangle, Point point) {
        if (point.x <= rectangle.x + 4) {
            if (point.y <= rectangle.y + 4) {
                return Resize.NORTH_WEST;
            }
            if (point.y >= rectangle.y + rectangle.height - 4) {
                return Resize.SOUTH_WEST;
            }
            return Resize.WEST;
        }
        if (point.x >= rectangle.x + rectangle.width - 4) {
            if (point.y <= rectangle.y + 4) {
                return Resize.NORTH_EAST;
            }
            if (point.y >= rectangle.y + rectangle.height - 4) {
                return Resize.SOUTH_EAST;
            }
            return Resize.EAST;
        }
        if (point.y <= rectangle.y + 4) {
            return Resize.NORTH;
        }
        if (point.y >= rectangle.y + rectangle.height - 4) {
            return Resize.SOUTH;
        }
        return null;
    }

    protected void resizeNote(NotePadMeta noteMeta, Point real) {
        switch (this.resize) {
            case EAST: {
                int width = real.x - this.resizeArea.x;
                if (width < noteMeta.getMinimumWidth()) {
                    width = noteMeta.getMinimumWidth();
                }
                PropsUi.setSize((IGuiSize)noteMeta, width, this.resizeArea.height);
                break;
            }
            case NORTH: {
                int y = real.y;
                if (y < 0) {
                    y = 0;
                }
                if (y > this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight()) {
                    y = this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight();
                }
                PropsUi.setLocation((IGuiPosition)noteMeta, this.resizeArea.x, y);
                PropsUi.setSize((IGuiSize)noteMeta, this.resizeArea.width, this.resizeArea.y + this.resizeArea.height - noteMeta.getLocation().y);
                break;
            }
            case NORTH_EAST: {
                int y;
                int width;
                int x = real.x;
                if (x < 0) {
                    x = 0;
                }
                if ((width = real.x - this.resizeArea.x) < noteMeta.getMinimumWidth()) {
                    width = noteMeta.getMinimumWidth();
                }
                if ((y = real.y) < 0) {
                    y = 0;
                }
                if (y > this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight()) {
                    y = this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight();
                }
                PropsUi.setLocation((IGuiPosition)noteMeta, this.resizeArea.x, y);
                PropsUi.setSize((IGuiSize)noteMeta, width, this.resizeArea.y + this.resizeArea.height - noteMeta.getLocation().y);
                break;
            }
            case NORTH_WEST: {
                int y;
                int x = real.x;
                if (x < 0) {
                    x = 0;
                }
                if (x > this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth()) {
                    x = this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth();
                }
                if ((y = real.y) < 0) {
                    y = 0;
                }
                if (y > this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight()) {
                    y = this.resizeArea.y + this.resizeArea.height - noteMeta.getMinimumHeight();
                }
                PropsUi.setLocation((IGuiPosition)noteMeta, x, y);
                PropsUi.setSize((IGuiSize)noteMeta, this.resizeArea.x + this.resizeArea.width - noteMeta.getLocation().x, this.resizeArea.height + this.resizeArea.y - noteMeta.getLocation().y);
                break;
            }
            case SOUTH: {
                int height = real.y - this.resizeArea.y;
                if (height < noteMeta.getMinimumHeight()) {
                    height = noteMeta.getMinimumHeight();
                }
                PropsUi.setSize((IGuiSize)noteMeta, this.resizeArea.width, height);
                break;
            }
            case SOUTH_EAST: {
                int height;
                int width = real.x - this.resizeArea.x;
                if (width < noteMeta.getMinimumWidth()) {
                    width = noteMeta.getMinimumWidth();
                }
                if ((height = real.y - this.resizeArea.y) < noteMeta.getMinimumHeight()) {
                    height = noteMeta.getMinimumHeight();
                }
                PropsUi.setSize((IGuiSize)noteMeta, width, height);
                break;
            }
            case SOUTH_WEST: {
                int height;
                int x = real.x;
                if (x < 0) {
                    x = 0;
                }
                if (x > this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth()) {
                    x = this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth();
                }
                if ((height = real.y - this.resizeArea.y) < noteMeta.getMinimumHeight()) {
                    height = noteMeta.getMinimumHeight();
                }
                PropsUi.setLocation((IGuiPosition)noteMeta, x, this.resizeArea.y);
                PropsUi.setSize((IGuiSize)noteMeta, this.resizeArea.x + this.resizeArea.width - noteMeta.getLocation().x, height);
                break;
            }
            case WEST: {
                int x = real.x;
                if (x < 0) {
                    x = 0;
                }
                if (x > this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth()) {
                    x = this.resizeArea.x + this.resizeArea.width - noteMeta.getMinimumWidth();
                }
                PropsUi.setLocation((IGuiPosition)noteMeta, x, this.resizeArea.y);
                PropsUi.setSize((IGuiSize)noteMeta, this.resizeArea.x + this.resizeArea.width - noteMeta.getLocation().x, this.resizeArea.height);
            }
        }
        this.redraw();
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public Map<String, Object> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Rectangle getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(Rectangle viewPort) {
        this.viewPort = viewPort;
    }

    public Rectangle getGraphPort() {
        return this.graphPort;
    }

    public void setGraphPort(Rectangle graphPort) {
        this.graphPort = graphPort;
    }

    protected void enableSnapAlignDistributeMenuItems(IHopFileType fileType, boolean selectedTransform) {
        GuiMenuWidgets menuWidgets = this.hopGui.getMainMenuWidgets();
        menuWidgets.enableMenuItem(fileType, "20200-menu-edit-snap-to-grid", "SnapToGrid", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20210-menu-edit-align-left", "AlignLeft", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20220-menu-edit-align-right", "AlignRight", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20230-menu-edit-align-top", "AlignTop", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20240-menu-edit-align-bottom", "AlignBottom", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20300-menu-edit-distribute-horizontal", "DistributeHorizontal", selectedTransform);
        menuWidgets.enableMenuItem(fileType, "20320-menu-edit-distribute-vertical", "DistributeVertical", selectedTransform);
    }

    public String getMouseOverName() {
        return this.mouseOverName;
    }

    public void setMouseOverName(String mouseOverName) {
        this.mouseOverName = mouseOverName;
    }

    public static enum Resize {
        EAST(13),
        NORTH(7),
        NORTH_EAST(6),
        NORTH_WEST(17),
        SOUTH(7),
        SOUTH_EAST(17),
        SOUTH_WEST(6),
        WEST(13);

        private final int cursor;

        private Resize(int cursor) {
            this.cursor = cursor;
        }

        @Generated
        public int getCursor() {
            return this.cursor;
        }
    }
}

