/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Workflow Graph Check Delegate")
public class HopGuiWorkflowCheckDelegate {
    private static final Class<?> PKG = HopGui.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiWorkflowCheckDelegate-ToolBar";
    private static final String TOOLBAR_ITEM_COLLAPSE_ALL = "HopGuiWorkflowCheckDelegate-Toolbar-10010-CollapseAll";
    private static final String TOOLBAR_ITEM_EXPAND_ALL = "HopGuiWorkflowCheckDelegate-Toolbar-10020-ExpandAll";
    private final HopGui hopGui;
    private final HopGuiWorkflowGraph workflowGraph;
    private CTabItem workflowCheckTab;
    private GuiToolbarWidgets toolBarWidgets;
    private Tree wTree;

    public HopGuiWorkflowCheckDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
    }

    public static HopGuiWorkflowCheckDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiWorkflowGraph) {
            HopGuiWorkflowGraph hopGuiWorkflowGraph = (HopGuiWorkflowGraph)fileTypeHandler;
            return hopGuiWorkflowGraph.workflowCheckDelegate;
        }
        return null;
    }

    public void addWorkflowCheck() {
        if (this.workflowGraph.extraViewTabFolder == null || this.workflowGraph.extraViewTabFolder.isDisposed()) {
            this.workflowGraph.addExtraView();
        } else if (this.workflowCheckTab != null && !this.workflowCheckTab.isDisposed()) {
            return;
        }
        this.workflowCheckTab = new CTabItem(this.workflowGraph.extraViewTabFolder, 0);
        this.workflowCheckTab.setFont(GuiResource.getInstance().getFontDefault());
        this.workflowCheckTab.setImage(GuiResource.getInstance().getImageCheck());
        this.workflowCheckTab.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.Check.Tab.Name", (String[])new String[0]));
        Composite checkComposite = new Composite((Composite)this.workflowGraph.extraViewTabFolder, 0);
        checkComposite.setLayout((Layout)new FormLayout());
        ToolBar toolbar = new ToolBar(checkComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        toolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)toolbar, 5);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        toolbar.pack();
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbar.setLayoutData((Object)fd);
        this.wTree = new Tree(checkComposite, 768);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdTree = new FormData();
        fdTree.top = new FormAttachment((Control)toolbar, 0);
        fdTree.left = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        this.wTree.addListener(14, this::edit);
        this.workflowCheckTab.setControl((Control)checkComposite);
    }

    @GuiToolbarElement(root="HopGuiWorkflowCheckDelegate-ToolBar", id="HopGuiWorkflowCheckDelegate-Toolbar-10010-CollapseAll", toolTip="i18n::System.Tooltip.CollapseALl", image="ui/images/collapse-all.svg")
    public void collapseAll() {
        this.wTree.setRedraw(false);
        for (TreeItem item : this.wTree.getItems()) {
            item.setExpanded(false);
        }
        this.wTree.setRedraw(true);
    }

    @GuiToolbarElement(root="HopGuiWorkflowCheckDelegate-ToolBar", id="HopGuiWorkflowCheckDelegate-Toolbar-10020-ExpandAll", toolTip="i18n::System.Tooltip.ExpandAll", image="ui/images/expand-all.svg")
    public void expandAll() {
        this.wTree.setRedraw(false);
        for (TreeItem item : this.wTree.getItems()) {
            item.setExpanded(true);
        }
        this.wTree.setRedraw(true);
    }

    public void checkWorkflow() {
        try {
            ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
            this.workflowGraph.extraViewTabFolder.setSelection(this.workflowCheckTab);
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.hopGui.getShell());
            monitorDialog.run(true, monitor -> {
                try {
                    WorkflowMeta workflowMeta = this.workflowGraph.getWorkflowMeta();
                    workflowMeta.checkActions(remarks, false, monitor, this.workflowGraph.getVariables(), (IHopMetadataProvider)this.hopGui.getMetadataProvider());
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"WorkflowGraph.Check.ErrorCheckingWorkflow.Exception", (Object[])new Object[]{e}));
                }
            });
            this.refresh(remarks);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), "WorkflowGraph.Check.ErrorCheckingWorkflow.Message", e);
        }
    }

    private void refresh(List<ICheckResult> remarks) {
        this.wTree.setRedraw(false);
        this.wTree.removeAll();
        HashMap<ICheckResultSource, TreeItem> mapSourceItems = new HashMap<ICheckResultSource, TreeItem>();
        for (ICheckResult cr : remarks) {
            if (cr.getType() == 1) continue;
            ICheckResultSource source = cr.getSourceInfo();
            TreeItem item = (TreeItem)mapSourceItems.get(source);
            if (source == null) {
                item = new TreeItem(this.wTree, 0);
            } else if (item == null) {
                TreeItem parentItem = new TreeItem(this.wTree, 0);
                parentItem.setText(source.getName());
                parentItem.setData((Object)source);
                if (source instanceof IAction) {
                    IAction action = (IAction)source;
                    Image image = GuiResource.getInstance().getSwtImageAction(action.getPluginId()).getAsBitmapForSize((Device)this.hopGui.getDisplay(), 24, 24);
                    if (image != null) {
                        parentItem.setImage(image);
                    }
                    mapSourceItems.put(source, parentItem);
                }
                item = new TreeItem(parentItem, 0);
                parentItem.setExpanded(true);
            } else {
                item = new TreeItem(item, 0);
            }
            item.setText(cr.getText());
            item.setData((Object)source);
            Image image = this.getImage(cr);
            if (image == null) continue;
            item.setImage(image);
        }
        this.wTree.setRedraw(true);
    }

    private Image getImage(ICheckResult cr) {
        return switch (cr.getType()) {
            case 1 -> GuiResource.getInstance().getImageTrue();
            case 4 -> GuiResource.getInstance().getImageError();
            case 3 -> GuiResource.getInstance().getImageWarning();
            default -> null;
        };
    }

    private void edit(Event event) {
        TreeItem item;
        Object object = event.item;
        if (object instanceof TreeItem && (object = (item = (TreeItem)object).getData()) instanceof ICheckResultSource) {
            ICheckResultSource source = (ICheckResultSource)object;
            ActionMeta actionMeta = this.workflowGraph.getWorkflowMeta().findAction(source.getName());
            this.workflowGraph.editAction(actionMeta);
        }
    }

    @Generated
    public CTabItem getWorkflowCheckTab() {
        return this.workflowCheckTab;
    }

    @Generated
    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }
}

