/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.simpleeval;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="SIMPLE_EVAL", name="i18n::ActionSimpleEval.Name", description="i18n::ActionSimpleEval.Description", image="SimpleEval.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionSimpleEval.keyword"}, documentationUrl="/workflow/actions/simpleeval.html")
public class ActionSimpleEval
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSimpleEval.class;
    public static final String CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE = "ActionSimpleEval.Log.CompareWithValue";
    public static final String CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER = "ActionSimpleEval.Error.UnparsableNumber";
    @HopMetadataProperty(key="valuetype", storeWithCode=true)
    private ValueType valueType = ValueType.FIELD;
    @HopMetadataProperty(key="fieldtype", storeWithCode=true)
    private FieldType fieldType = FieldType.STRING;
    @HopMetadataProperty(key="fieldname")
    private String fieldName = null;
    @HopMetadataProperty(key="variablename")
    private String variableName = null;
    @HopMetadataProperty(key="mask")
    private String mask = null;
    @HopMetadataProperty(key="comparevalue")
    private String compareValue = null;
    @HopMetadataProperty(key="minvalue")
    private String minValue = null;
    @HopMetadataProperty(key="maxvalue")
    private String maxValue = null;
    @HopMetadataProperty(key="successcondition", storeWithCode=true)
    private SuccessStringCondition successStringCondition = SuccessStringCondition.EQUAL;
    @HopMetadataProperty(key="successwhenvarset")
    private boolean successWhenVarSet = false;
    @HopMetadataProperty(key="successbooleancondition", storeWithCode=true)
    private SuccessBooleanCondition successBooleanCondition;
    @HopMetadataProperty(key="successnumbercondition", storeWithCode=true)
    private SuccessNumberCondition successNumberCondition = SuccessNumberCondition.EQUAL;

    public ActionSimpleEval(String n) {
        super(n, "");
        this.successBooleanCondition = SuccessBooleanCondition.TRUE;
    }

    public ActionSimpleEval() {
        this("");
    }

    public Object clone() {
        ActionSimpleEval je = (ActionSimpleEval)super.clone();
        return je;
    }

    public void setSuccessWhenVarSet(boolean successwhenvarset) {
        this.successWhenVarSet = successwhenvarset;
    }

    public boolean isSuccessWhenVarSet() {
        return this.successWhenVarSet;
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String sourcevalue = null;
        switch (this.valueType) {
            case FIELD: {
                List rows = result.getRows();
                RowMetaAndData resultRow = null;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
                }
                if (rows.isEmpty()) {
                    rows = null;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.NoRows", (String[])new String[0]));
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(0);
                String realfieldname = this.resolve(this.fieldName);
                int indexOfField = -1;
                indexOfField = resultRow.getRowMeta().indexOfValue(realfieldname);
                if (indexOfField == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.FieldNotExist", (String[])new String[]{realfieldname}));
                    resultRow = null;
                    rows = null;
                    return result;
                }
                sourcevalue = resultRow.getString(indexOfField, null);
                if (sourcevalue == null) {
                    sourcevalue = "";
                }
                resultRow = null;
                rows = null;
                break;
            }
            case VARIABLE: {
                if (Utils.isEmpty((CharSequence)this.variableName)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.VariableMissing", (String[])new String[0]));
                    return result;
                }
                if (this.isSuccessWhenVarSet()) {
                    String variableName = StringUtil.getVariableName((String)Const.NVL((String)this.getVariableName(), (String)""));
                    String value = this.getVariable(variableName);
                    if (value != null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.VariableSet", (String[])new String[]{variableName}));
                        }
                        result.setResult(true);
                        result.setNrErrors(0L);
                        return result;
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.VariableNotSet", (String[])new String[]{variableName}));
                    }
                    result.setNrErrors(0L);
                    return result;
                }
                sourcevalue = this.resolve(this.getVariableWithSpec());
                break;
            }
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.ValueToevaluate", (String[])new String[]{sourcevalue}));
        }
        boolean success = false;
        String realCompareValue = this.resolve(this.compareValue);
        if (realCompareValue == null) {
            realCompareValue = "";
        }
        String realMinValue = this.resolve(this.minValue);
        String realMaxValue = this.resolve(this.maxValue);
        block27 : switch (this.fieldType) {
            case STRING: {
                switch (this.successStringCondition) {
                    case EQUAL: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.equals(realCompareValue);
                        if (this.valueType != ValueType.VARIABLE || success || !Utils.isEmpty((CharSequence)realCompareValue) || this.resolve(this.variableName) != null) break;
                        success = true;
                        break;
                    }
                    case DIFFERENT: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.equals(realCompareValue);
                        break;
                    }
                    case CONTAINS: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.contains(realCompareValue);
                        break;
                    }
                    case NOT_CONTAINS: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.contains(realCompareValue);
                        break;
                    }
                    case START_WITH: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.startsWith(realCompareValue);
                        break;
                    }
                    case NOT_START_WITH: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.startsWith(realCompareValue);
                        break;
                    }
                    case END_WITH: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.endsWith(realCompareValue);
                        break;
                    }
                    case NOT_END_WITH: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.endsWith(realCompareValue);
                        break;
                    }
                    case REGEX: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = Pattern.compile(realCompareValue).matcher(sourcevalue).matches();
                        break;
                    }
                    case IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            success = sourcevalue.equals(parts[i].trim());
                        }
                        break block27;
                    }
                    case NOT_IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            success = !sourcevalue.equals(parts[i].trim());
                        }
                        break block27;
                    }
                }
                break;
            }
            case NUMBER: {
                double valuenumber;
                try {
                    valuenumber = Double.parseDouble(sourcevalue);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{sourcevalue, e.getMessage()}));
                    return result;
                }
                switch (this.successNumberCondition) {
                    case EQUAL: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber == valuecompare;
                        break;
                    }
                    case DIFFERENT: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber != valuecompare;
                        break;
                    }
                    case SMALLER: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber < valuecompare;
                        break;
                    }
                    case SMALLER_EQUAL: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber <= valuecompare;
                        break;
                    }
                    case GREATER: {
                        double valuecompare;
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber > valuecompare;
                        break;
                    }
                    case GREATER_EQUAL: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber >= valuecompare;
                        break;
                    }
                    case BETWEEN: {
                        double valuemax;
                        double valuemin;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                        }
                        try {
                            valuemin = Double.parseDouble(realMinValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realMinValue, e.getMessage()}));
                            return result;
                        }
                        try {
                            valuemax = Double.parseDouble(realMaxValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{realMaxValue, e.getMessage()}));
                            return result;
                        }
                        if (valuemin >= valuemax) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.IncorrectNumbers", (String[])new String[]{realMinValue, realMaxValue}));
                            return result;
                        }
                        success = valuenumber >= valuemin && valuenumber <= valuemax;
                        break;
                    }
                    case IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            double valuecompare;
                            try {
                                valuecompare = Double.parseDouble(parts[i]);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{parts[i], e.getMessage()})});
                                return result;
                            }
                            success = valuenumber == valuecompare;
                        }
                        break block27;
                    }
                    case NOT_IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            double valuecompare;
                            try {
                                valuecompare = Double.parseDouble(parts[i]);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_ERROR_UNPARSABLE_NUMBER, (String[])new String[]{parts[i], e.getMessage()})});
                                return result;
                            }
                            success = valuenumber != valuecompare;
                        }
                        break block27;
                    }
                }
                break;
            }
            case DATE_TIME: {
                String realMask = this.resolve(this.mask);
                SimpleDateFormat df = new SimpleDateFormat();
                if (!Utils.isEmpty((CharSequence)realMask)) {
                    df.applyPattern(realMask);
                }
                Date datevalue = null;
                try {
                    datevalue = this.convertToDate(sourcevalue, realMask, df);
                }
                catch (Exception e) {
                    this.logError(e.getMessage());
                    return result;
                }
                switch (this.successNumberCondition) {
                    case EQUAL: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.equals(datecompare);
                        break;
                    }
                    case DIFFERENT: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = !datevalue.equals(datecompare);
                        break;
                    }
                    case SMALLER: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.before(datecompare);
                        break;
                    }
                    case SMALLER_EQUAL: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.before(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case GREATER: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.after(datecompare);
                        break;
                    }
                    case GREATER_EQUAL: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.after(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case BETWEEN: {
                        Date datemax;
                        Date datemin;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                        }
                        try {
                            datemin = this.convertToDate(realMinValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        try {
                            datemax = this.convertToDate(realMaxValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        if (datemin.after(datemax) || datemin.equals(datemax)) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.IncorrectDates", (String[])new String[]{realMinValue, realMaxValue}));
                            return result;
                        }
                        success = !(!datevalue.after(datemin) && !datevalue.equals(datemin) || !datevalue.before(datemax) && !datevalue.equals(datemax));
                        break;
                    }
                    case IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            Date datecompare;
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{e.getMessage()});
                                return result;
                            }
                            success = datevalue.equals(datecompare);
                        }
                        break;
                    }
                    case NOT_IN_LIST: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)CONST_ACTION_SIMPLE_EVAL_LOG_COMPARE_WITH_VALUE, (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            Date datecompare;
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{e.getMessage()});
                                return result;
                            }
                            success = !datevalue.equals(datecompare);
                        }
                        break;
                    }
                }
                df = null;
                break;
            }
            case BOOLEAN: {
                boolean valuebool;
                try {
                    valuebool = ValueMetaBase.convertStringToBoolean((String)sourcevalue);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableBoolean", (String[])new String[]{sourcevalue, e.getMessage()}));
                    return result;
                }
                switch (this.successBooleanCondition) {
                    case FALSE: {
                        success = !valuebool;
                        break block27;
                    }
                    case TRUE: {
                        success = valuebool;
                        break block27;
                    }
                }
                break;
            }
        }
        result.setResult(success);
        result.setNrErrors(0L);
        return result;
    }

    private String getVariableWithSpec() {
        Object variable = this.getVariableName();
        if (!(((String)variable).contains("${") || ((String)variable).contains("%%") || ((String)variable).contains("$[") || ((String)variable).contains("}") || ((String)variable).contains("%%") || ((String)variable).contains("]"))) {
            variable = "${" + (String)variable + "}";
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.CheckingVariable", (String[])new String[]{variable}));
            }
        }
        return variable;
    }

    private Date convertToDate(String valueString, String mask, SimpleDateFormat df) throws HopException {
        Date datevalue = null;
        try {
            datevalue = df.parse(valueString);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableDate", (String[])new String[]{valueString}));
        }
        return datevalue;
    }

    public void setMinValue(String minvalue) {
        this.minValue = minvalue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setCompareValue(String comparevalue) {
        this.compareValue = comparevalue;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldname) {
        this.fieldName = fieldname;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variablename) {
        this.variableName = variablename;
    }

    public String getCompareValue() {
        return this.compareValue;
    }

    public void setMaxValue(String maxvalue) {
        this.maxValue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public boolean isEvaluation() {
        return true;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public SuccessStringCondition getSuccessStringCondition() {
        return this.successStringCondition;
    }

    public void setValueType(ValueType valuetype) {
        this.valueType = valuetype;
    }

    public void setFieldType(FieldType fieldtype) {
        this.fieldType = fieldtype;
    }

    public void setSuccessStringCondition(SuccessStringCondition successcondition) {
        this.successStringCondition = successcondition;
    }

    public SuccessBooleanCondition getSuccessBooleanCondition() {
        return this.successBooleanCondition;
    }

    public SuccessNumberCondition getSuccessNumberCondition() {
        return this.successNumberCondition;
    }

    public void setSuccessBooleanCondition(SuccessBooleanCondition successBooleanCondition) {
        this.successBooleanCondition = successBooleanCondition;
    }

    public void setSuccessNumberCondition(SuccessNumberCondition successNumberCondition) {
        this.successNumberCondition = successNumberCondition;
    }

    public static enum ValueType implements IEnumHasCodeAndDescription
    {
        FIELD("field", BaseMessages.getString(PKG, (String)"ActionSimpleEval.EvalPreviousField.Label", (String[])new String[0])),
        VARIABLE("variable", BaseMessages.getString(PKG, (String)"ActionSimpleEval.EvalVariable.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private ValueType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(ValueType.class);
        }

        public static ValueType lookupDescription(String description) {
            return (ValueType)IEnumHasCodeAndDescription.lookupDescription(ValueType.class, (String)description, (IEnumHasCodeAndDescription)FIELD);
        }

        public static ValueType lookupCode(String code) {
            return (ValueType)IEnumHasCode.lookupCode(ValueType.class, (String)code, (IEnumHasCode)FIELD);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum FieldType implements IEnumHasCodeAndDescription
    {
        STRING("string", BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeString.Label", (String[])new String[0])),
        NUMBER("number", BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeNumber.Label", (String[])new String[0])),
        DATE_TIME("datetime", BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeDateTime.Label", (String[])new String[0])),
        BOOLEAN("boolean", BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeBoolean.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private FieldType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(FieldType.class);
        }

        public static FieldType lookupDescription(String description) {
            return (FieldType)IEnumHasCodeAndDescription.lookupDescription(FieldType.class, (String)description, (IEnumHasCodeAndDescription)STRING);
        }

        public static FieldType lookupCode(String code) {
            return (FieldType)IEnumHasCode.lookupCode(FieldType.class, (String)code, (IEnumHasCode)STRING);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum SuccessStringCondition implements IEnumHasCodeAndDescription
    {
        EQUAL("equal", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEqual.Label", (String[])new String[0])),
        DIFFERENT("different", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0])),
        CONTAINS("contains", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenContains.Label", (String[])new String[0])),
        NOT_CONTAINS("notcontains", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotContains.Label", (String[])new String[0])),
        START_WITH("startswith", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenStartWith.Label", (String[])new String[0])),
        NOT_START_WITH("notstatwith", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotStartWith.Label", (String[])new String[0])),
        END_WITH("endswith", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEndWith.Label", (String[])new String[0])),
        NOT_END_WITH("notendwith", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotEndWith.Label", (String[])new String[0])),
        REGEX("regexp", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenRegExp.Label", (String[])new String[0])),
        IN_LIST("inlist", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenInList.Label", (String[])new String[0])),
        NOT_IN_LIST("notinlist", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SuccessStringCondition(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SuccessStringCondition.class);
        }

        public static SuccessStringCondition lookupDescription(String description) {
            return (SuccessStringCondition)IEnumHasCodeAndDescription.lookupDescription(SuccessStringCondition.class, (String)description, (IEnumHasCodeAndDescription)EQUAL);
        }

        public static SuccessStringCondition lookupCode(String code) {
            return (SuccessStringCondition)IEnumHasCode.lookupCode(SuccessStringCondition.class, (String)code, (IEnumHasCode)EQUAL);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum SuccessNumberCondition implements IEnumHasCodeAndDescription
    {
        EQUAL("equal", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEqual.Label", (String[])new String[0])),
        DIFFERENT("different", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0])),
        SMALLER("smaller", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSmallThan.Label", (String[])new String[0])),
        SMALLER_EQUAL("smallequal", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSmallOrEqualThan.Label", (String[])new String[0])),
        GREATER("greater", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenGreaterThan.Label", (String[])new String[0])),
        GREATER_EQUAL("greaterequal", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenGreaterOrEqualThan.Label", (String[])new String[0])),
        BETWEEN("between", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessBetween.Label", (String[])new String[0])),
        IN_LIST("inlist", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenInList.Label", (String[])new String[0])),
        NOT_IN_LIST("notinlist", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SuccessNumberCondition(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SuccessNumberCondition.class);
        }

        public static SuccessNumberCondition lookupDescription(String description) {
            return (SuccessNumberCondition)IEnumHasCodeAndDescription.lookupDescription(SuccessNumberCondition.class, (String)description, (IEnumHasCodeAndDescription)EQUAL);
        }

        public static SuccessNumberCondition lookupCode(String code) {
            return (SuccessNumberCondition)IEnumHasCode.lookupCode(SuccessNumberCondition.class, (String)code, (IEnumHasCode)EQUAL);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum SuccessBooleanCondition implements IEnumHasCodeAndDescription
    {
        TRUE("true", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenTrue.Label", (String[])new String[0])),
        FALSE("false", BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenFalse.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SuccessBooleanCondition(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SuccessBooleanCondition.class);
        }

        public static SuccessBooleanCondition lookupDescription(String description) {
            return (SuccessBooleanCondition)IEnumHasCodeAndDescription.lookupDescription(SuccessBooleanCondition.class, (String)description, (IEnumHasCodeAndDescription)TRUE);
        }

        public static SuccessBooleanCondition lookupCode(String code) {
            return (SuccessBooleanCondition)IEnumHasCode.lookupCode(SuccessBooleanCondition.class, (String)code, (IEnumHasCode)TRUE);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

