/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.salesforce;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.salesforce.SalesforceConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SalesforceConnectionEditor
extends MetadataEditor<SalesforceConnection> {
    private static final Class<?> PKG = SalesforceConnectionEditor.class;
    private Text wName;
    private Label wlAuthType;
    private CCombo wAuthType;
    private Group wUsernamePasswordGroup;
    private LabelTextVar wUsername;
    private PasswordTextVar wPassword;
    private PasswordTextVar wSecurityToken;
    private LabelTextVar wTargetUrl;
    private Group wOAuthGroup;
    private LabelTextVar wOAuthClientId;
    private PasswordTextVar wOAuthClientSecret;
    private LabelTextVar wOAuthRedirectUri;
    private LabelTextVar wOAuthInstanceUrl;
    private LabelTextVar wOAuthAccessToken;
    private PasswordTextVar wOAuthRefreshToken;
    private Button wOAuthAuthorize;
    private Button wOAuthExchange;
    private Group wOAuthJwtGroup;
    private TextVar wOAuthJwtUsername;
    private TextVar wOAuthJwtConsumerKey;
    private PasswordTextVar wOAuthJwtPrivateKey;
    private TextVar wOAuthJwtTokenEndpoint;
    private Button wTest;
    private String codeVerifier;
    private String codeChallenge;

    public SalesforceConnectionEditor(HopGui hopGui, MetadataManager<SalesforceConnection> manager, SalesforceConnection salesforceConnection) {
        super(hopGui, manager, (IHopMetadata)salesforceConnection);
    }

    public void createControl(Composite composite) {
        Control[] controls;
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        IVariables variables = this.hopGui.getVariables();
        Label wlName = new Label(composite, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.Name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        this.wlAuthType = new Label(composite, 131072);
        PropsUi.setLook((Widget)this.wlAuthType);
        this.wlAuthType.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.AuthType", (String[])new String[0]));
        FormData fdlAuthType = new FormData();
        fdlAuthType.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthType.left = new FormAttachment(0, 0);
        fdlAuthType.right = new FormAttachment(middle, -margin);
        this.wlAuthType.setLayoutData((Object)fdlAuthType);
        this.wAuthType = new CCombo(composite, 2056);
        PropsUi.setLook((Widget)this.wAuthType);
        this.wAuthType.setItems(new String[]{BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.AuthType.UsernamePassword", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.AuthType.OAuth", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.AuthType.OAuthJWT", (String[])new String[0])});
        this.wAuthType.select(0);
        FormData fdAuthType = new FormData();
        fdAuthType.left = new FormAttachment(middle, 0);
        fdAuthType.top = new FormAttachment((Control)this.wlAuthType, 0, 0x1000000);
        fdAuthType.right = new FormAttachment(95, 0);
        this.wAuthType.setLayoutData((Object)fdAuthType);
        this.wAuthType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SalesforceConnectionEditor.this.updateAuthenticationUI();
            }
        });
        lastControl = this.wAuthType;
        this.wUsernamePasswordGroup = new Group(composite, 16);
        this.wUsernamePasswordGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.UsernamePasswordGroup", (String[])new String[0]));
        FormLayout fUsernamePasswordLayout = new FormLayout();
        fUsernamePasswordLayout.marginWidth = 3;
        fUsernamePasswordLayout.marginHeight = 3;
        this.wUsernamePasswordGroup.setLayout((Layout)fUsernamePasswordLayout);
        PropsUi.setLook((Widget)this.wUsernamePasswordGroup);
        this.wUsername = new LabelTextVar(variables, (Composite)this.wUsernamePasswordGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.Username", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.Username.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.left = new FormAttachment(0, 0);
        fdUsername.top = new FormAttachment(0, margin);
        fdUsername.right = new FormAttachment(100, 0);
        this.wUsername.setLayoutData((Object)fdUsername);
        Label wlPassword = new Label((Composite)this.wUsernamePasswordGroup, 131072);
        PropsUi.setLook((Widget)wlPassword);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.Password", (String[])new String[0]));
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUsername, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(variables, (Composite)this.wUsernamePasswordGroup, 18436, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.Password.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)wlPassword, 0, 0x1000000);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Label wlSecurityToken = new Label((Composite)this.wUsernamePasswordGroup, 131072);
        PropsUi.setLook((Widget)wlSecurityToken);
        wlSecurityToken.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.SecurityToken", (String[])new String[0]) + " (Optional)");
        FormData fdlSecurityToken = new FormData();
        fdlSecurityToken.left = new FormAttachment(0, 0);
        fdlSecurityToken.top = new FormAttachment((Control)this.wPassword, margin);
        fdlSecurityToken.right = new FormAttachment(middle, -margin);
        wlSecurityToken.setLayoutData((Object)fdlSecurityToken);
        this.wSecurityToken = new PasswordTextVar(variables, (Composite)this.wUsernamePasswordGroup, 18436, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.SecurityToken.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSecurityToken);
        FormData fdSecurityToken = new FormData();
        fdSecurityToken.left = new FormAttachment(middle, 0);
        fdSecurityToken.top = new FormAttachment((Control)wlSecurityToken, 0, 0x1000000);
        fdSecurityToken.right = new FormAttachment(100, 0);
        this.wSecurityToken.setLayoutData((Object)fdSecurityToken);
        this.wTargetUrl = new LabelTextVar(variables, (Composite)this.wUsernamePasswordGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.TargetUrl", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.TargetUrl.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTargetUrl);
        FormData fdTargetUrl = new FormData();
        fdTargetUrl.left = new FormAttachment(0, 0);
        fdTargetUrl.top = new FormAttachment((Control)this.wSecurityToken, margin);
        fdTargetUrl.right = new FormAttachment(100, 0);
        this.wTargetUrl.setLayoutData((Object)fdTargetUrl);
        FormData fdUsernamePasswordGroup = new FormData();
        fdUsernamePasswordGroup.left = new FormAttachment(0, 0);
        fdUsernamePasswordGroup.right = new FormAttachment(100, 0);
        fdUsernamePasswordGroup.top = new FormAttachment((Control)lastControl, margin);
        this.wUsernamePasswordGroup.setLayoutData((Object)fdUsernamePasswordGroup);
        this.wOAuthGroup = new Group(composite, 16);
        this.wOAuthGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthGroup", (String[])new String[0]));
        FormLayout fOAuthLayout = new FormLayout();
        fOAuthLayout.marginWidth = 3;
        fOAuthLayout.marginHeight = 3;
        this.wOAuthGroup.setLayout((Layout)fOAuthLayout);
        PropsUi.setLook((Widget)this.wOAuthGroup);
        this.wOAuthClientId = new LabelTextVar(variables, (Composite)this.wOAuthGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthClientId", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthClientId.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthClientId);
        FormData fdOAuthClientId = new FormData();
        fdOAuthClientId.left = new FormAttachment(0, 0);
        fdOAuthClientId.top = new FormAttachment(0, margin);
        fdOAuthClientId.right = new FormAttachment(100, 0);
        this.wOAuthClientId.setLayoutData((Object)fdOAuthClientId);
        Label wlOAuthClientSecret = new Label((Composite)this.wOAuthGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthClientSecret);
        wlOAuthClientSecret.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthClientSecret", (String[])new String[0]));
        FormData fdlOAuthClientSecret = new FormData();
        fdlOAuthClientSecret.left = new FormAttachment(0, 0);
        fdlOAuthClientSecret.top = new FormAttachment((Control)this.wOAuthClientId, margin);
        fdlOAuthClientSecret.right = new FormAttachment(middle, -margin);
        wlOAuthClientSecret.setLayoutData((Object)fdlOAuthClientSecret);
        this.wOAuthClientSecret = new PasswordTextVar(variables, (Composite)this.wOAuthGroup, 18436, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthClientSecret.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthClientSecret);
        FormData fdOAuthClientSecret = new FormData();
        fdOAuthClientSecret.left = new FormAttachment(middle, 0);
        fdOAuthClientSecret.top = new FormAttachment((Control)wlOAuthClientSecret, 0, 0x1000000);
        fdOAuthClientSecret.right = new FormAttachment(100, 0);
        this.wOAuthClientSecret.setLayoutData((Object)fdOAuthClientSecret);
        this.wOAuthRedirectUri = new LabelTextVar(variables, (Composite)this.wOAuthGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthRedirectUri", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthRedirectUri.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthRedirectUri);
        FormData fdOAuthRedirectUri = new FormData();
        fdOAuthRedirectUri.left = new FormAttachment(0, 0);
        fdOAuthRedirectUri.top = new FormAttachment((Control)this.wOAuthClientSecret, margin);
        fdOAuthRedirectUri.right = new FormAttachment(100, 0);
        this.wOAuthRedirectUri.setLayoutData((Object)fdOAuthRedirectUri);
        this.wOAuthInstanceUrl = new LabelTextVar(variables, (Composite)this.wOAuthGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthInstanceUrl", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthInstanceUrl.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthInstanceUrl);
        FormData fdOAuthInstanceUrl = new FormData();
        fdOAuthInstanceUrl.left = new FormAttachment(0, 0);
        fdOAuthInstanceUrl.top = new FormAttachment((Control)this.wOAuthRedirectUri, margin);
        fdOAuthInstanceUrl.right = new FormAttachment(100, 0);
        this.wOAuthInstanceUrl.setLayoutData((Object)fdOAuthInstanceUrl);
        this.wOAuthAuthorize = new Button((Composite)this.wOAuthGroup, 8);
        this.wOAuthAuthorize.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthAuthorize", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthAuthorize);
        FormData fdOAuthAuthorize = new FormData();
        this.wOAuthAuthorize.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthAuthorize.Tooltip", (String[])new String[0]));
        fdOAuthAuthorize.top = new FormAttachment((Control)this.wOAuthInstanceUrl, margin);
        fdOAuthAuthorize.right = new FormAttachment(100, 0);
        this.wOAuthAuthorize.setLayoutData((Object)fdOAuthAuthorize);
        this.wOAuthAuthorize.addListener(13, e -> this.authorizeOAuth());
        this.wOAuthAccessToken = new LabelTextVar(variables, (Composite)this.wOAuthGroup, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthAccessToken", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthAccessToken.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wOAuthAccessToken);
        FormData fdOAuthAccessToken = new FormData();
        fdOAuthAccessToken.left = new FormAttachment(0, 0);
        fdOAuthAccessToken.top = new FormAttachment((Control)this.wOAuthAuthorize, margin);
        fdOAuthAccessToken.right = new FormAttachment(100, 0);
        this.wOAuthAccessToken.setLayoutData((Object)fdOAuthAccessToken);
        Label wlOAuthRefreshToken = new Label((Composite)this.wOAuthGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthRefreshToken);
        wlOAuthRefreshToken.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthRefreshToken", (String[])new String[0]));
        FormData fdlOAuthRefreshToken = new FormData();
        fdlOAuthRefreshToken.left = new FormAttachment(0, 0);
        fdlOAuthRefreshToken.top = new FormAttachment((Control)this.wOAuthAccessToken, margin);
        fdlOAuthRefreshToken.right = new FormAttachment(middle, -margin);
        wlOAuthRefreshToken.setLayoutData((Object)fdlOAuthRefreshToken);
        this.wOAuthRefreshToken = new PasswordTextVar(variables, (Composite)this.wOAuthGroup, 18436, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthRefreshToken.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthRefreshToken);
        FormData fdOAuthRefreshToken = new FormData();
        fdOAuthRefreshToken.left = new FormAttachment(middle, 0);
        fdOAuthRefreshToken.top = new FormAttachment((Control)wlOAuthRefreshToken, 0, 0x1000000);
        fdOAuthRefreshToken.right = new FormAttachment(100, 0);
        this.wOAuthRefreshToken.setLayoutData((Object)fdOAuthRefreshToken);
        this.wOAuthExchange = new Button((Composite)this.wOAuthGroup, 8);
        this.wOAuthExchange.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthExchange", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthExchange);
        FormData fdOAuthExchange = new FormData();
        this.wOAuthExchange.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthExchange.Tooltip", (String[])new String[0]));
        fdOAuthExchange.top = new FormAttachment((Control)this.wOAuthRefreshToken, margin);
        fdOAuthExchange.right = new FormAttachment(100, 0);
        this.wOAuthExchange.setLayoutData((Object)fdOAuthExchange);
        this.wOAuthExchange.addListener(13, e -> this.exchangeCodeForTokens());
        FormData fdOAuthGroup = new FormData();
        fdOAuthGroup.left = new FormAttachment(0, 0);
        fdOAuthGroup.right = new FormAttachment(100, 0);
        fdOAuthGroup.top = new FormAttachment((Control)lastControl, margin);
        this.wOAuthGroup.setLayoutData((Object)fdOAuthGroup);
        this.wOAuthGroup.setVisible(false);
        this.wOAuthJwtGroup = new Group(composite, 16);
        this.wOAuthJwtGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtGroup", (String[])new String[0]));
        FormLayout fOAuthJwtLayout = new FormLayout();
        fOAuthJwtLayout.marginWidth = 3;
        fOAuthJwtLayout.marginHeight = 3;
        this.wOAuthJwtGroup.setLayout((Layout)fOAuthJwtLayout);
        PropsUi.setLook((Widget)this.wOAuthJwtGroup);
        Label wlOAuthJwtUsername = new Label((Composite)this.wOAuthJwtGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthJwtUsername);
        wlOAuthJwtUsername.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtUsername", (String[])new String[0]));
        FormData fdlOAuthJwtUsername = new FormData();
        fdlOAuthJwtUsername.left = new FormAttachment(0, 0);
        fdlOAuthJwtUsername.top = new FormAttachment(0, margin);
        fdlOAuthJwtUsername.right = new FormAttachment(middle, -margin);
        wlOAuthJwtUsername.setLayoutData((Object)fdlOAuthJwtUsername);
        this.wOAuthJwtUsername = new TextVar(variables, (Composite)this.wOAuthJwtGroup, 18436);
        this.wOAuthJwtUsername.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtUsername.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthJwtUsername);
        FormData fdOAuthJwtUsername = new FormData();
        fdOAuthJwtUsername.left = new FormAttachment(middle, 0);
        fdOAuthJwtUsername.top = new FormAttachment((Control)wlOAuthJwtUsername, 0, 0x1000000);
        fdOAuthJwtUsername.right = new FormAttachment(100, 0);
        this.wOAuthJwtUsername.setLayoutData((Object)fdOAuthJwtUsername);
        Label wlOAuthJwtConsumerKey = new Label((Composite)this.wOAuthJwtGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthJwtConsumerKey);
        wlOAuthJwtConsumerKey.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtConsumerKey", (String[])new String[0]));
        FormData fdlOAuthJwtConsumerKey = new FormData();
        fdlOAuthJwtConsumerKey.left = new FormAttachment(0, 0);
        fdlOAuthJwtConsumerKey.top = new FormAttachment((Control)this.wOAuthJwtUsername, margin);
        fdlOAuthJwtConsumerKey.right = new FormAttachment(middle, -margin);
        wlOAuthJwtConsumerKey.setLayoutData((Object)fdlOAuthJwtConsumerKey);
        this.wOAuthJwtConsumerKey = new TextVar(variables, (Composite)this.wOAuthJwtGroup, 18436);
        this.wOAuthJwtConsumerKey.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtConsumerKey.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthJwtConsumerKey);
        FormData fdOAuthJwtConsumerKey = new FormData();
        fdOAuthJwtConsumerKey.left = new FormAttachment(middle, 0);
        fdOAuthJwtConsumerKey.top = new FormAttachment((Control)wlOAuthJwtConsumerKey, 0, 0x1000000);
        fdOAuthJwtConsumerKey.right = new FormAttachment(100, 0);
        this.wOAuthJwtConsumerKey.setLayoutData((Object)fdOAuthJwtConsumerKey);
        Label wlOAuthJwtPrivateKey = new Label((Composite)this.wOAuthJwtGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthJwtPrivateKey);
        wlOAuthJwtPrivateKey.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtPrivateKey", (String[])new String[0]));
        FormData fdlOAuthJwtPrivateKey = new FormData();
        fdlOAuthJwtPrivateKey.left = new FormAttachment(0, 0);
        fdlOAuthJwtPrivateKey.top = new FormAttachment((Control)this.wOAuthJwtConsumerKey, margin);
        fdlOAuthJwtPrivateKey.right = new FormAttachment(middle, -margin);
        wlOAuthJwtPrivateKey.setLayoutData((Object)fdlOAuthJwtPrivateKey);
        Composite wOAuthJwtPrivateKeyComposite = new Composite((Composite)this.wOAuthJwtGroup, 0);
        PropsUi.setLook((Widget)wOAuthJwtPrivateKeyComposite);
        FormLayout privateKeyLayout = new FormLayout();
        privateKeyLayout.marginWidth = 0;
        privateKeyLayout.marginHeight = 0;
        wOAuthJwtPrivateKeyComposite.setLayout((Layout)privateKeyLayout);
        FormData fdOAuthJwtPrivateKeyComposite = new FormData();
        fdOAuthJwtPrivateKeyComposite.left = new FormAttachment(middle, 0);
        fdOAuthJwtPrivateKeyComposite.top = new FormAttachment((Control)wlOAuthJwtPrivateKey, 0, 0x1000000);
        fdOAuthJwtPrivateKeyComposite.right = new FormAttachment(100, 0);
        wOAuthJwtPrivateKeyComposite.setLayoutData((Object)fdOAuthJwtPrivateKeyComposite);
        Button wOAuthJwtLoadKey = new Button(wOAuthJwtPrivateKeyComposite, 8);
        wOAuthJwtLoadKey.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wOAuthJwtLoadKey.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtLoadKey.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wOAuthJwtLoadKey);
        FormData fdOAuthJwtLoadKey = new FormData();
        fdOAuthJwtLoadKey.right = new FormAttachment(100, 0);
        fdOAuthJwtLoadKey.top = new FormAttachment(0, 0);
        wOAuthJwtLoadKey.setLayoutData((Object)fdOAuthJwtLoadKey);
        wOAuthJwtLoadKey.addListener(13, e -> this.loadPrivateKeyFromFile());
        this.wOAuthJwtPrivateKey = new PasswordTextVar(variables, wOAuthJwtPrivateKeyComposite, 18436, BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtPrivateKey.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthJwtPrivateKey);
        FormData fdOAuthJwtPrivateKey = new FormData();
        fdOAuthJwtPrivateKey.left = new FormAttachment(0, 0);
        fdOAuthJwtPrivateKey.top = new FormAttachment((Control)wOAuthJwtLoadKey, 0, 0x1000000);
        fdOAuthJwtPrivateKey.right = new FormAttachment((Control)wOAuthJwtLoadKey, -margin);
        this.wOAuthJwtPrivateKey.setLayoutData((Object)fdOAuthJwtPrivateKey);
        Label wlOAuthJwtTokenEndpoint = new Label((Composite)this.wOAuthJwtGroup, 131072);
        PropsUi.setLook((Widget)wlOAuthJwtTokenEndpoint);
        wlOAuthJwtTokenEndpoint.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtTokenEndpoint", (String[])new String[0]));
        FormData fdlOAuthJwtTokenEndpoint = new FormData();
        fdlOAuthJwtTokenEndpoint.left = new FormAttachment(0, 0);
        fdlOAuthJwtTokenEndpoint.top = new FormAttachment((Control)wOAuthJwtPrivateKeyComposite, margin);
        fdlOAuthJwtTokenEndpoint.right = new FormAttachment(middle, -margin);
        wlOAuthJwtTokenEndpoint.setLayoutData((Object)fdlOAuthJwtTokenEndpoint);
        this.wOAuthJwtTokenEndpoint = new TextVar(variables, (Composite)this.wOAuthJwtGroup, 18436);
        this.wOAuthJwtTokenEndpoint.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtTokenEndpoint.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOAuthJwtTokenEndpoint);
        FormData fdOAuthJwtTokenEndpoint = new FormData();
        fdOAuthJwtTokenEndpoint.left = new FormAttachment(middle, 0);
        fdOAuthJwtTokenEndpoint.top = new FormAttachment((Control)wlOAuthJwtTokenEndpoint, 0, 0x1000000);
        fdOAuthJwtTokenEndpoint.right = new FormAttachment(100, 0);
        this.wOAuthJwtTokenEndpoint.setLayoutData((Object)fdOAuthJwtTokenEndpoint);
        FormData fdOAuthJwtGroup = new FormData();
        fdOAuthJwtGroup.left = new FormAttachment(0, 0);
        fdOAuthJwtGroup.right = new FormAttachment(100, 0);
        fdOAuthJwtGroup.top = new FormAttachment((Control)lastControl, margin);
        this.wOAuthJwtGroup.setLayoutData((Object)fdOAuthJwtGroup);
        this.wOAuthJwtGroup.setVisible(false);
        this.wTest = new Button(composite, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.TestConnection", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTest);
        FormData fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wOAuthGroup, margin);
        fdTest.right = new FormAttachment(95, 0);
        this.wTest.setLayoutData((Object)fdTest);
        this.wTest.addListener(13, e -> this.testConnection());
        this.setWidgetsContent();
        this.updateAuthenticationUI();
        this.resetChanged();
        for (Control control : controls = new Control[]{this.wName, this.wAuthType, this.wUsername.getTextWidget(), this.wPassword.getTextWidget(), this.wSecurityToken.getTextWidget(), this.wTargetUrl.getTextWidget(), this.wOAuthClientId.getTextWidget(), this.wOAuthClientSecret.getTextWidget(), this.wOAuthRedirectUri.getTextWidget(), this.wOAuthInstanceUrl.getTextWidget(), this.wOAuthAccessToken.getTextWidget(), this.wOAuthRefreshToken.getTextWidget(), this.wOAuthJwtUsername, this.wOAuthJwtConsumerKey, this.wOAuthJwtPrivateKey.getTextWidget(), this.wOAuthJwtTokenEndpoint}) {
            control.addListener(24, e -> this.setChanged());
            control.addListener(13, e -> this.setChanged());
        }
    }

    private void updateAuthenticationUI() {
        String currentEndpoint;
        String currentUrl;
        boolean isOAuthJwt;
        int selectedIndex = this.wAuthType == null ? 0 : this.wAuthType.getSelectionIndex();
        boolean isUsernamePassword = selectedIndex == 0;
        boolean isOAuth = selectedIndex == 1;
        boolean bl = isOAuthJwt = selectedIndex == 2;
        if (this.wUsernamePasswordGroup != null) {
            this.wUsernamePasswordGroup.setVisible(isUsernamePassword);
            if (isUsernamePassword) {
                this.wUsernamePasswordGroup.layout(true, true);
            }
            int n = ((FormData)this.wUsernamePasswordGroup.getLayoutData()).height = isUsernamePassword ? -1 : 0;
        }
        if (this.wOAuthGroup != null) {
            this.wOAuthGroup.setVisible(isOAuth);
            if (isOAuth) {
                this.wOAuthGroup.layout(true, true);
            }
            int n = ((FormData)this.wOAuthGroup.getLayoutData()).height = isOAuth ? -1 : 0;
        }
        if (this.wOAuthJwtGroup != null) {
            this.wOAuthJwtGroup.setVisible(isOAuthJwt);
            if (isOAuthJwt) {
                this.wOAuthJwtGroup.layout(true, true);
            }
            int n = ((FormData)this.wOAuthJwtGroup.getLayoutData()).height = isOAuthJwt ? -1 : 0;
        }
        if (isUsernamePassword && this.wTargetUrl != null && ((currentUrl = this.wTargetUrl.getText()) == null || currentUrl.trim().isEmpty())) {
            this.wTargetUrl.setText("https://login.salesforce.com/services/Soap/u/64.0");
            this.setChanged();
        }
        if (isOAuthJwt && this.wOAuthJwtTokenEndpoint != null && ((currentEndpoint = this.wOAuthJwtTokenEndpoint.getText()) == null || currentEndpoint.trim().isEmpty())) {
            this.wOAuthJwtTokenEndpoint.setText("https://login.salesforce.com");
            this.setChanged();
        }
        if (this.wTest != null) {
            FormData fdTest = (FormData)this.wTest.getLayoutData();
            fdTest.top = isOAuth ? new FormAttachment((Control)this.wOAuthGroup, PropsUi.getMargin()) : (isOAuthJwt ? new FormAttachment((Control)this.wOAuthJwtGroup, PropsUi.getMargin()) : new FormAttachment((Control)this.wUsernamePasswordGroup, PropsUi.getMargin()));
            this.wTest.setLayoutData((Object)fdTest);
        }
        if (this.wTest != null && this.wTest.getParent() != null) {
            Composite parent = this.wTest.getParent();
            parent.layout(true, true);
            parent.redraw();
            parent.update();
        }
    }

    private boolean isOAuthSelected() {
        if (this.wAuthType == null) {
            return false;
        }
        return this.wAuthType.getSelectionIndex() == 1;
    }

    private void authorizeOAuth() {
        try {
            String clientId = this.wOAuthClientId.getText();
            String redirectUri = this.wOAuthRedirectUri.getText();
            String instanceUrl = this.wOAuthInstanceUrl.getText();
            if (Utils.isEmpty((CharSequence)clientId)) {
                MessageBox clientIdMb = new MessageBox(this.getShell(), 33);
                clientIdMb.setMessage("OAuth Client ID is required for authorization.");
                clientIdMb.setText("OAuth Configuration Error");
                clientIdMb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)redirectUri)) {
                MessageBox redirectUriMb = new MessageBox(this.getShell(), 33);
                redirectUriMb.setMessage("OAuth Redirect URI is required for authorization.");
                redirectUriMb.setText("OAuth Configuration Error");
                redirectUriMb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)instanceUrl)) {
                MessageBox instanceUrlMb = new MessageBox(this.getShell(), 33);
                instanceUrlMb.setMessage("OAuth Instance URL is required for authorization.");
                instanceUrlMb.setText("OAuth Configuration Error");
                instanceUrlMb.open();
                return;
            }
            String authUrl = this.buildAuthorizationUrl(clientId, redirectUri, instanceUrl, false);
            this.showAuthorizationUrlDialog(authUrl, redirectUri);
        }
        catch (Exception e) {
            MessageBox errorMb = new MessageBox(this.getShell(), 33);
            errorMb.setMessage("Error starting OAuth authorization: " + e.getMessage());
            errorMb.setText("OAuth Authorization Error");
            errorMb.open();
        }
    }

    private String buildAuthorizationUrl(String clientId, String redirectUri, String instanceUrl, boolean forceConsent) {
        try {
            this.generatePKCEParameters();
            StringBuilder url = new StringBuilder();
            url.append(instanceUrl);
            if (!instanceUrl.endsWith("/")) {
                url.append("/");
            }
            url.append("services/oauth2/authorize?");
            url.append("response_type=code&");
            url.append("client_id=").append(URLEncoder.encode(clientId, "UTF-8")).append("&");
            url.append("redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8")).append("&");
            url.append("scope=").append(URLEncoder.encode("api refresh_token", "UTF-8")).append("&");
            url.append("code_challenge=").append(URLEncoder.encode(this.codeChallenge, "UTF-8")).append("&");
            url.append("code_challenge_method=S256");
            if (forceConsent) {
                url.append("&prompt=consent");
            }
            return url.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build authorization URL: " + e.getMessage(), e);
        }
    }

    private void generatePKCEParameters() {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] randomBytes = new byte[32];
            secureRandom.nextBytes(randomBytes);
            this.codeVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(this.codeVerifier.getBytes("UTF-8"));
            this.codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate PKCE parameters: " + e.getMessage(), e);
        }
    }

    private void showAuthorizationUrlDialog(String authUrl, String redirectUri) {
        Shell urlDialog = new Shell(this.getShell(), 67680);
        urlDialog.setText("OAuth Authorization URL");
        Rectangle screenSize = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        int dialogWidth = Math.min(screenSize.width / 2, 800);
        urlDialog.setSize(dialogWidth, 450);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        urlDialog.setLayout((Layout)layout);
        Label instructionsLabel = new Label((Composite)urlDialog, 64);
        instructionsLabel.setText("OAuth Authorization Instructions:\n\n1. Click 'Open in Browser' to open the authorization URL\n2. Log in to Salesforce and authorize the application\n3. After authorization, you'll be redirected to: " + redirectUri + "\n4. IMPORTANT: The authorization code may be hidden in the address bar\n   \u2022 Click on the address bar to see the full URL\n   \u2022 Look for the 'code=' parameter in the URL\n5. Copy the entire code value (everything after 'code=')\n6. Paste the code in the 'Access Token' field above\n7. Click 'Exchange Code for Tokens' to get your tokens\n\n\u26a0\ufe0f  Authorization codes expire in 10 minutes - work quickly!");
        GridData gdInstructions = new GridData();
        gdInstructions.horizontalAlignment = 4;
        gdInstructions.grabExcessHorizontalSpace = true;
        instructionsLabel.setLayoutData((Object)gdInstructions);
        Button forceConsentCheckbox = new Button((Composite)urlDialog, 32);
        forceConsentCheckbox.setText("Force consent (prompt=consent)");
        forceConsentCheckbox.setToolTipText("Force Salesforce to show the authorization page even if previously authorized");
        GridData gdForceConsent = new GridData();
        gdForceConsent.horizontalAlignment = 4;
        gdForceConsent.grabExcessHorizontalSpace = true;
        forceConsentCheckbox.setLayoutData((Object)gdForceConsent);
        Text urlText = new Text((Composite)urlDialog, 2386);
        urlText.setText(authUrl);
        urlText.setEditable(false);
        GridData gdUrlText = new GridData();
        gdUrlText.horizontalAlignment = 4;
        gdUrlText.grabExcessHorizontalSpace = false;
        gdUrlText.heightHint = 100;
        urlText.setLayoutData((Object)gdUrlText);
        forceConsentCheckbox.addListener(13, e -> {
            try {
                String clientId = this.wOAuthClientId.getText();
                String redirectUriValue = this.wOAuthRedirectUri.getText();
                String instanceUrl = this.wOAuthInstanceUrl.getText();
                boolean forceConsent = forceConsentCheckbox.getSelection();
                String newAuthUrl = this.buildAuthorizationUrl(clientId, redirectUriValue, instanceUrl, forceConsent);
                urlText.setText(newAuthUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Button copyButton = new Button((Composite)urlDialog, 8);
        copyButton.setText("Copy URL");
        GridData gdCopyButton = new GridData();
        gdCopyButton.horizontalAlignment = 1;
        copyButton.setLayoutData((Object)gdCopyButton);
        copyButton.addListener(13, e -> {
            urlText.selectAll();
            urlText.copy();
            MessageBox mb = new MessageBox(urlDialog, 34);
            mb.setMessage("URL copied to clipboard!");
            mb.setText("Copied");
            mb.open();
        });
        Button openButton = new Button((Composite)urlDialog, 8);
        openButton.setText("Open in Browser");
        GridData gdOpenButton = new GridData();
        gdOpenButton.horizontalAlignment = 1;
        openButton.setLayoutData((Object)gdOpenButton);
        openButton.addListener(13, e -> {
            try {
                this.openBrowser(authUrl);
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(urlDialog, 33);
                mb.setMessage("Failed to open browser: " + ex.getMessage());
                mb.setText("Error");
                mb.open();
            }
        });
        Button closeButton = new Button((Composite)urlDialog, 8);
        closeButton.setText("Close");
        GridData gdCloseButton = new GridData();
        gdCloseButton.horizontalAlignment = 3;
        closeButton.setLayoutData((Object)gdCloseButton);
        closeButton.addListener(13, e -> urlDialog.close());
        urlDialog.pack();
        urlDialog.setLocation(this.getShell().getLocation().x + (this.getShell().getSize().x - urlDialog.getSize().x) / 2, this.getShell().getLocation().y + (this.getShell().getSize().y - urlDialog.getSize().y) / 2);
        urlDialog.open();
    }

    private void openBrowser(String url) throws Exception {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        if (os.contains("win")) {
            runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.contains("mac")) {
            runtime.exec("open " + url);
        } else if (os.contains("nix") || os.contains("nux")) {
            runtime.exec("xdg-open " + url);
        } else {
            throw new Exception("Unsupported operating system: " + os);
        }
    }

    private void exchangeCodeForTokens() {
        try {
            String line;
            String clientId = this.wOAuthClientId.getText();
            String clientSecret = this.wOAuthClientSecret.getText();
            String redirectUri = this.wOAuthRedirectUri.getText();
            String instanceUrl = this.wOAuthInstanceUrl.getText();
            String authorizationCode = this.wOAuthAccessToken.getText();
            if (Utils.isEmpty((CharSequence)clientId)) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("OAuth Client ID is required for token exchange.");
                mb.setText("OAuth Configuration Error");
                mb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)clientSecret)) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("OAuth Client Secret is required for token exchange.");
                mb.setText("OAuth Configuration Error");
                mb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)redirectUri)) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("OAuth Redirect URI is required for token exchange.");
                mb.setText("OAuth Configuration Error");
                mb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)instanceUrl)) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("OAuth Instance URL is required for token exchange.");
                mb.setText("OAuth Configuration Error");
                mb.open();
                return;
            }
            if (Utils.isEmpty((CharSequence)authorizationCode)) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("Authorization code is required. Please paste the code from the authorization URL.");
                mb.setText("OAuth Configuration Error");
                mb.open();
                return;
            }
            String decodedCode = URLDecoder.decode(authorizationCode, "UTF-8");
            Object tokenUrl = instanceUrl;
            if (!((String)tokenUrl).endsWith("/")) {
                tokenUrl = (String)tokenUrl + "/";
            }
            tokenUrl = (String)tokenUrl + "services/oauth2/token";
            URL url = new URL((String)tokenUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            StringBuilder requestBody = new StringBuilder();
            requestBody.append("grant_type=authorization_code&");
            requestBody.append("client_id=").append(URLEncoder.encode(clientId, "UTF-8")).append("&");
            requestBody.append("client_secret=").append(URLEncoder.encode(clientSecret, "UTF-8")).append("&");
            requestBody.append("redirect_uri=").append(URLEncoder.encode(redirectUri, "UTF-8")).append("&");
            requestBody.append("code=").append(URLEncoder.encode(decodedCode, "UTF-8")).append("&");
            requestBody.append("code_verifier=").append(URLEncoder.encode(this.codeVerifier, "UTF-8"));
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.toString().getBytes("UTF-8");
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            BufferedReader reader = responseCode >= 200 && responseCode < 300 ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            if (responseCode >= 200 && responseCode < 300) {
                String responseStr = response.toString();
                String accessToken = this.extractJsonValue(responseStr, "access_token");
                String refreshToken = this.extractJsonValue(responseStr, "refresh_token");
                String instanceUrlFromResponse = this.extractJsonValue(responseStr, "instance_url");
                this.wOAuthAccessToken.setText(accessToken);
                this.wOAuthRefreshToken.setText(refreshToken);
                if (!Utils.isEmpty((CharSequence)instanceUrlFromResponse)) {
                    this.wOAuthInstanceUrl.setText(instanceUrlFromResponse);
                }
                MessageBox mb = new MessageBox(this.getShell(), 34);
                mb.setMessage("Tokens successfully obtained and populated!");
                mb.setText("Success");
                mb.open();
            } else {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setMessage("Token exchange failed with response code " + responseCode + ": " + response.toString());
                mb.setText("Token Exchange Error");
                mb.open();
            }
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setMessage("Error exchanging code for tokens: " + e.getMessage());
            mb.setText("Token Exchange Error");
            mb.open();
        }
    }

    private String extractJsonValue(String json, String key) {
        try {
            String pattern = "\"" + key + "\"\\s*:\\s*\"([^\"]+)\"";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(json);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void loadPrivateKeyFromFile() {
        try {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtLoadKey.DialogTitle", (String[])new String[0]));
            dialog.setFilterExtensions(new String[]{"*.key;*.pem", "*.*"});
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtLoadKey.FileTypes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
            String filename = dialog.open();
            if (filename != null) {
                Path path = Paths.get(filename, new String[0]);
                String keyContent = new String(Files.readAllBytes(path), "UTF-8");
                if (keyContent.contains("BEGIN") && keyContent.contains("PRIVATE KEY")) {
                    this.wOAuthJwtPrivateKey.setText(keyContent);
                    this.setChanged();
                } else {
                    MessageBox mb = new MessageBox(this.getShell(), 40);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtLoadKey.InvalidFormat", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Warning.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceConnectionEditor.OAuthJwtLoadKey.Error", (String[])new String[0]), e);
        }
    }

    private void testConnection() {
        try {
            this.getWidgetsContent((SalesforceConnection)this.getMetadata());
            ((SalesforceConnection)this.getMetadata()).testConnection(this.hopGui.getVariables(), this.hopGui.getLog());
            MessageBox mb = new MessageBox(this.getShell(), 34);
            mb.setMessage("Connection test successful!");
            mb.setText("Success");
            mb.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Connection test failed", e);
        }
    }

    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getName(), (String)""));
        if (((SalesforceConnection)this.metadata).isOAuthAuthentication()) {
            this.wAuthType.select(1);
        } else if (((SalesforceConnection)this.metadata).isOAuthJwtAuthentication()) {
            this.wAuthType.select(2);
        } else {
            this.wAuthType.select(0);
        }
        this.wUsername.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getPassword(), (String)""));
        this.wSecurityToken.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getSecurityToken(), (String)""));
        this.wTargetUrl.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getTargetUrl(), (String)""));
        this.wOAuthClientId.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthClientId(), (String)""));
        this.wOAuthClientSecret.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthClientSecret(), (String)""));
        this.wOAuthRedirectUri.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthRedirectUri(), (String)"http://localhost:8080/callback"));
        this.wOAuthInstanceUrl.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthInstanceUrl(), (String)""));
        this.wOAuthAccessToken.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthAccessToken(), (String)""));
        this.wOAuthRefreshToken.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthRefreshToken(), (String)""));
        this.wOAuthJwtUsername.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthJwtUsername(), (String)""));
        this.wOAuthJwtConsumerKey.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthJwtConsumerKey(), (String)""));
        String privateKey = ((SalesforceConnection)this.metadata).getOauthJwtPrivateKey();
        if (!Utils.isEmpty((CharSequence)privateKey)) {
            String maskedPlaceholder = "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
            this.wOAuthJwtPrivateKey.setText(maskedPlaceholder);
            this.wOAuthJwtPrivateKey.setData("actualPrivateKey", (Object)privateKey);
        } else {
            this.wOAuthJwtPrivateKey.setText("");
            this.wOAuthJwtPrivateKey.setData("actualPrivateKey", null);
        }
        this.wOAuthJwtTokenEndpoint.setText(Const.NVL((String)((SalesforceConnection)this.metadata).getOauthJwtTokenEndpoint(), (String)"https://login.salesforce.com"));
        this.updateAuthenticationUI();
        if (this.wTest != null && this.wTest.getParent() != null) {
            this.wTest.getParent().getDisplay().asyncExec(() -> {
                if (!this.wTest.isDisposed() && !this.wTest.getParent().isDisposed()) {
                    this.wTest.getParent().layout(true, true);
                }
            });
        }
    }

    public void getWidgetsContent(SalesforceConnection connection) {
        connection.setName(this.wName.getText());
        int selectedIndex = this.wAuthType.getSelectionIndex();
        if (selectedIndex == 1) {
            connection.setAuthenticationType("OAUTH");
        } else if (selectedIndex == 2) {
            connection.setAuthenticationType("OAUTH_JWT");
        } else {
            connection.setAuthenticationType("USERNAME_PASSWORD");
        }
        connection.setUsername(this.wUsername.getText());
        connection.setPassword(this.wPassword.getText());
        connection.setSecurityToken(this.wSecurityToken.getText());
        connection.setTargetUrl(this.wTargetUrl.getText());
        connection.setOauthClientId(this.wOAuthClientId.getText());
        connection.setOauthClientSecret(this.wOAuthClientSecret.getText());
        connection.setOauthRedirectUri(this.wOAuthRedirectUri.getText());
        connection.setOauthInstanceUrl(this.wOAuthInstanceUrl.getText());
        connection.setOauthAccessToken(this.wOAuthAccessToken.getText());
        connection.setOauthRefreshToken(this.wOAuthRefreshToken.getText());
        connection.setOauthJwtUsername(this.wOAuthJwtUsername.getText());
        connection.setOauthJwtConsumerKey(this.wOAuthJwtConsumerKey.getText());
        String displayedKey = this.wOAuthJwtPrivateKey.getText();
        if (displayedKey != null && displayedKey.matches("^\u2022+$")) {
            String actualKey = (String)this.wOAuthJwtPrivateKey.getData("actualPrivateKey");
            connection.setOauthJwtPrivateKey(actualKey != null ? actualKey : "");
        } else {
            connection.setOauthJwtPrivateKey(displayedKey);
        }
        connection.setOauthJwtTokenEndpoint(this.wOAuthJwtTokenEndpoint.getText());
    }
}

