/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.config.GitConfig;
import org.apache.hop.git.config.GitConfigSingleton;
import org.apache.hop.git.info.GitInfoExplorerFileType;
import org.apache.hop.git.info.GitInfoExplorerFileTypeHandler;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerFilePaintListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRefreshListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRootChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerSelectionListener;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

@GuiPlugin
public class GitGuiPlugin
implements IExplorerRootChangedListener,
IExplorerFilePaintListener,
IExplorerRefreshListener,
IExplorerSelectionListener {
    public static final Class<?> PKG = GitGuiPlugin.class;
    public static final String ID_TOOLBAR_ITEM_GIT = "toolbar-item-30000-git";
    public static final String ID_CONTEXT_MENU_GIT = "context-menu-git";
    public static final String CONTEXT_MENU_GIT_CREATE_BRANCH = "context-menu-git-20010-CreateBranch";
    public static final String CONTEXT_MENU_GIT_MERGE_BRANCH = "context-menu-git-20020-MergeBranch";
    public static final String CONTEXT_MENU_GIT_RENAME_BRANCH = "context-menu-git-20020-RenameBranch";
    public static final String CONTEXT_MENU_GIT_DELETE_BRANCH = "context-menu-git-20030-DeleteBranch";
    public static final String CONTEXT_MENU_GIT_PUSH = "context-menu-git-30000-Push";
    public static final String CONTEXT_MENU_GIT_PULL = "context-menu-git-30010-Pull";
    public static final String TOOLBAR_ITEM_GIT_INFO = "ExplorerPerspective-Toolbar-20100-GitInfo";
    public static final String TOOLBAR_ITEM_ADD = "ExplorerPerspective-Toolbar-20200-Add";
    public static final String TOOLBAR_ITEM_REVERT = "ExplorerPerspective-Toolbar-20300-Revert";
    public static final String TOOLBAR_ITEM_COMMIT = "ExplorerPerspective-Toolbar-21000-Commit";
    public static final String TOOLBAR_ITEM_PUSH = "ExplorerPerspective-Toolbar-21100-Push";
    public static final String TOOLBAR_ITEM_PULL = "ExplorerPerspective-Toolbar-21200-Pull";
    public static final String CONTEXT_MENU_GIT_INFO = "ExplorerPerspective-ContextMenu-20000-GitInfo";
    public static final String CONTEXT_MENU_GIT_ADD = "ExplorerPerspective-ContextMenu-20100-GitAdd";
    public static final String CONTEXT_MENU_GIT_REVERT = "ExplorerPerspective-ContextMenu-20200-GitRevert";
    public static final String CONTEXT_MENU_GIT_COMMIT = "ExplorerPerspective-ContextMenu-21000-GitCommit";
    public static final String TOOLBAR_ITEM_BRANCH = "ExplorerPerspective-Toolbar-22000-GitBranch";
    private static GitGuiPlugin instance;
    private static UIGit git;
    private Map<String, UIFile> changedFiles;
    private Map<String, String> ignoredFiles;
    private final Color colorIgnored;
    private final Color colorStagedUnchanged;
    private final Color colorStagedAdd;
    private final Color colorStagedModify;
    private final Color colorUnstaged;

    public static GitGuiPlugin getInstance() {
        if (instance == null) {
            instance = new GitGuiPlugin();
        }
        return instance;
    }

    public GitGuiPlugin() {
        if (PropsUi.getInstance().isDarkMode()) {
            this.colorStagedModify = GuiResource.getInstance().getColorLightBlue();
            this.colorIgnored = GuiResource.getInstance().getColorGray();
            this.colorUnstaged = GuiResource.getInstance().getColor(217, 105, 73);
        } else {
            this.colorStagedModify = GuiResource.getInstance().getColorBlue();
            this.colorIgnored = GuiResource.getInstance().getColorDarkGray();
            this.colorUnstaged = GuiResource.getInstance().getColor(225, 30, 70);
        }
        this.colorStagedUnchanged = GuiResource.getInstance().getColorBlack();
        this.colorStagedAdd = GuiResource.getInstance().getColorDarkGreen();
        this.refreshChangedFiles();
    }

    @GuiCallback(callbackId="ExplorerPerspective-Toolbar-Created")
    public void addRootChangedListener() {
        git = null;
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        explorerPerspective.getRootChangedListeners().add(this);
        explorerPerspective.getFilePaintListeners().add(this);
        explorerPerspective.getRefreshListeners().add(this);
        explorerPerspective.getSelectionListeners().add(this);
        this.enableButtons();
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-21000-GitCommit", label="i18n::GitGuiPlugin.Menu.Commit.Text", image="git-commit.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21000-Commit", toolTip="i18n::GitGuiPlugin.Toolbar.Commit.Tooltip", image="git-commit.svg")
    public void gitCommit() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> changedFilesToCommit = git.getRevertPathFiles(relativePath);
            if (changedFilesToCommit.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Message", (String[])new String[0]));
                box.open();
            } else {
                EnterStringDialog enterStringDialog;
                String message;
                String[] files = changedFilesToCommit.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.StageFiles.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.StageFiles.Message", (String[])new String[0]));
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null && (message = (enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Message", (String[])new String[0]))).open()) != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        if (this.fileExists(file)) {
                            git.add(file);
                            continue;
                        }
                        git.rm(file);
                    }
                    String authorName = git.getAuthorName("WORKINGTREE");
                    git.commit(authorName, message);
                }
            }
            ExplorerPerspective.getInstance().refresh();
            this.enableButtons();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Message", (String[])new String[0]), e);
        }
    }

    private boolean fileExists(String file) throws HopFileException, FileSystemException {
        String filename = git.getDirectory() + File.separator + file;
        return HopVfs.getFileObject((String)filename).exists();
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-30000-Push", label="i18n::GitGuiPlugin.Menu.Branch.Push.Text", image="push.svg", separator=true)
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21100-Push", toolTip="i18n::GitGuiPlugin.Toolbar.Push.Tooltip", image="push.svg")
    public void gitPush() {
        try {
            git.push();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Message", (String[])new String[0]), e);
        }
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-30010-Pull", label="i18n::GitGuiPlugin.Menu.Branch.Pull.Text", image="pull.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21200-Pull", toolTip="i18n::GitGuiPlugin.Toolbar.Pull.Tooltip", image="pull.svg")
    @GuiKeyboardShortcut(control=true, key=84)
    @GuiOsxKeyboardShortcut(control=true, key=84)
    public void gitPull() {
        try {
            if (git.pull()) {
                ExplorerPerspective.getInstance().refresh();
                MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullSuccessful.Header", (String[])new String[0]));
                pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullSuccessful.Message", (String[])new String[0]));
                pullSuccessful.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="HopGui-Status-Toolbar", id="toolbar-item-30000-git", type=GuiToolbarElementType.BUTTON, image="branch.svg", toolTip="i18n::GitGuiPlugin.Toolbar.Branch.Tooltip", separator=true)
    public void showGitContextMenu() {
        ToolItem item = GitGuiPlugin.getGitToolItem();
        if (item != null) {
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y + rect.height));
            Menu menu = this.createGitContextMenu();
            menu.setLocation(pt);
            menu.setVisible(true);
        }
    }

    private Menu createGitContextMenu() {
        Shell shell = HopGui.getInstance().getActiveShell();
        Menu menu = new Menu((Decorations)shell, 8);
        if (git == null) {
            return menu;
        }
        try {
            GuiMenuWidgets menuWidgets = new GuiMenuWidgets();
            menuWidgets.registerGuiPluginObject((Object)this);
            menuWidgets.createMenuWidgets(ID_CONTEXT_MENU_GIT, shell, menu);
            new MenuItem(menu, 2);
            String currentBranch = git.getBranch();
            for (String name : git.getBranches()) {
                MenuItem item = new MenuItem(menu, 0);
                item.setText(name);
                if (currentBranch.equals(name)) {
                    item.setImage(GuiResource.getInstance().getImageCheck());
                }
                item.addListener(13, e -> this.gitCheckoutBranch(name));
            }
        }
        catch (Exception e2) {
            new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.Message", (String[])new String[0]), e2);
        }
        return menu;
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20100-GitAdd", label="i18n::GitGuiPlugin.Menu.Add.Text", image="git-add.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20200-Add", toolTip="i18n::GitGuiPlugin.Toolbar.Add.Tooltip", image="git-add.svg")
    public void gitAdd() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            git.add(relativePath);
            ExplorerPerspective.getInstance().refresh();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Message", (String[])new String[0]), e);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20200-GitRevert", label="i18n::GitGuiPlugin.Menu.Revert.Text", image="git-revert.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20300-Revert", toolTip="i18n::GitGuiPlugin.Toolbar.Revert.Tooltip", image="git-revert.svg")
    public void gitRevert() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> revertPathFiles = git.getRevertPathFiles(relativePath);
            if (revertPathFiles.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Message", (String[])new String[0]));
                box.open();
            } else {
                String[] files = revertPathFiles.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Message", (String[])new String[0]));
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        git.revertPath(file);
                    }
                    MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                    box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.FilesReverted.Header", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.FilesReverted.Message", (String[])new String[0]));
                    box.open();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Message", (String[])new String[0]), e);
        }
        ExplorerPerspective.getInstance().refresh();
        this.enableButtons();
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-20010-CreateBranch", label="i18n::GitGuiPlugin.Menu.Branch.Create.Text", image="ui/images/add.svg")
    public void gitCreateBranch() {
        EnterStringDialog enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranch.Message", (String[])new String[0]));
        String message = enterStringDialog.open();
        if (message != null) {
            boolean branchCreated = git.createBranch(message);
            if (branchCreated) {
                MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranchSuccessFul.Header", (String[])new String[0]));
                pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranchSuccessFul.Message", (String[])new String[0]));
                pullSuccessful.open();
            }
            ExplorerPerspective.getInstance().refresh();
        }
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-20020-RenameBranch", label="i18n::GitGuiPlugin.Menu.Branch.Rename.Text", image="ui/images/rename.svg")
    public void gitRenameBranch() {
        boolean renamed;
        String oldName = GitGuiPlugin.getGitToolItem().getText();
        EnterStringDialog enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), oldName, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.RenameBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.RenameBranch.Message", (String[])new String[0]));
        String newName = enterStringDialog.open();
        if (!Utils.isEmpty((CharSequence)newName) && !newName.equals(oldName) && (renamed = git.renameBranch(oldName, newName))) {
            this.setBranchLabel(newName);
        }
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-20020-MergeBranch", label="i18n::GitGuiPlugin.Menu.Branch.Merge.Text", image="merge.svg")
    public void gitMergeBranch() {
        List<String> branches = git.getBranches();
        EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), branches.toArray(new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranch.Message", (String[])new String[0]));
        String branchToMerge = selectionDialog.open();
        if (branchToMerge != null) {
            try {
                boolean branchMerged = git.mergeBranch(branchToMerge, (MergeStrategy)MergeStrategy.RECURSIVE);
                if (branchMerged) {
                    MessageBox mergeSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                    mergeSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranchSuccessFul.Header", (String[])new String[0]));
                    mergeSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranchSuccessFul.Message", (String[])new String[0]));
                    mergeSuccessful.open();
                }
            }
            catch (Exception ex) {
                new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.MergeBranchError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.MergeBranchError.Message", (String[])new String[0]), ex);
            }
            ExplorerPerspective.getInstance().refresh();
        }
    }

    private void gitCheckoutBranch(String name) {
        git.checkout(name);
        ExplorerPerspective.getInstance().refresh();
    }

    @GuiMenuElement(root="context-menu-git", parentId="context-menu-git", id="context-menu-git-20030-DeleteBranch", label="i18n::GitGuiPlugin.Menu.Branch.Delete.Text", image="ui/images/delete.svg")
    public void gitDeleteBranch() {
        List<String> branches = git.getBranches();
        EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), branches.toArray(new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranch.Message", (String[])new String[0]));
        String branchToDelete = selectionDialog.open();
        if (branchToDelete != null) {
            boolean branchDeleted = git.deleteBranch(branchToDelete, true);
            if (branchDeleted) {
                MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranchSuccessFul.Header", (String[])new String[0]));
                pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranchSuccessFul.Message", (String[])new String[0]));
                pullSuccessful.open();
            }
            ExplorerPerspective.getInstance().refresh();
        }
    }

    private String calculateRelativePath(String directory, ExplorerFile explorerFile) {
        try {
            FileObject file = HopVfs.getFileObject((String)explorerFile.getFilename());
            FileObject root = HopVfs.getFileObject((String)directory);
            return root.getName().getRelativeName(file.getName());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative path for filename '" + explorerFile.getFilename() + "' against '" + directory + "'", (Throwable)e);
            return null;
        }
    }

    private ExplorerFile getSelectedFile() {
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        return explorerPerspective.getSelectedFile();
    }

    public void rootChanged(String rootFolder, String rootName) {
        GitConfig config = GitConfigSingleton.getConfig();
        git = null;
        this.setBranchLabel(null);
        if (config.isEnabled()) {
            try (FileObject folder = this.findGitConfig(rootFolder, config.isSearchingParentFolders());){
                if (folder != null) {
                    git = new UIGit();
                    git.openRepo(HopVfs.getFilename((FileObject)folder));
                    this.setBranchLabel(git.getBranch());
                }
            }
            catch (Exception e) {
                git = null;
                LogChannel.UI.logBasic("No git project found in " + rootFolder);
            }
        }
        this.refreshChangedFiles();
        this.enableButtons();
    }

    private FileObject findGitConfig(String rootFolderName, boolean searchParentFolders) throws HopFileException, FileSystemException {
        FileObject folder = HopVfs.getFileObject((String)rootFolderName);
        FileObject fileObject = folder.resolveFile(".git/config");
        while (searchParentFolders && !fileObject.exists() && folder.getParent() != null) {
            folder = folder.getParent();
            fileObject = folder.resolveFile(".git/config");
        }
        if (fileObject.exists()) {
            return folder;
        }
        return null;
    }

    private String getAbsoluteFilename(String path) {
        try {
            path = HopVfs.getFileObject((String)path).getName().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private String getAbsoluteFilename(String root, String relativePath) {
        Object path = root + File.separator + relativePath;
        try {
            path = HopVfs.getFileObject((String)path).getName().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private void refreshChangedFiles() {
        this.changedFiles = new HashMap<String, UIFile>();
        this.ignoredFiles = new HashMap<String, String>();
        if (git != null) {
            ArrayList<UIFile> files = new ArrayList<UIFile>(git.getStagedFiles());
            files.addAll(git.getUnstagedFiles());
            for (UIFile file : files) {
                String path = this.getAbsoluteFilename(git.getDirectory(), file.getName());
                this.changedFiles.put(path, file);
            }
            Set<String> ignored = git.getIgnored(null);
            for (String file : ignored) {
                String path = this.getAbsoluteFilename(git.getDirectory(), file);
                this.ignoredFiles.put(path, file);
            }
            this.setBranchLabel(git.getBranch());
        }
    }

    public void beforeRefresh() {
        this.refreshChangedFiles();
    }

    public void fileSelected() {
        this.enableButtons();
    }

    private void enableButtons() {
        boolean isGit = git != null;
        boolean isSelected = isGit && this.getSelectedFile() != null;
        GuiToolbarWidgets toolBarWidgets = ExplorerPerspective.getInstance().getToolBarWidgets();
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_GIT_INFO, isGit);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ADD, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_REVERT, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_COMMIT, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_PUSH, isGit);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_PULL, isGit);
        GuiMenuWidgets menuWidgets = ExplorerPerspective.getInstance().getMenuWidgets();
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_INFO, isGit);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_ADD, isSelected);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_COMMIT, isSelected);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_REVERT, isSelected);
        GitGuiPlugin.getGitToolItem().setEnabled(isGit);
    }

    public void filePainted(Tree tree, TreeItem treeItem, String path, String name) {
        String absolutePath = this.getAbsoluteFilename(path);
        UIFile file = this.changedFiles.get(absolutePath);
        if (file != null) {
            switch (file.getChangeType()) {
                case ADD: 
                case COPY: 
                case RENAME: {
                    treeItem.setForeground(file.isStaged() ? this.colorStagedAdd : this.colorUnstaged);
                    break;
                }
                case MODIFY: {
                    treeItem.setForeground(file.isStaged() ? this.colorStagedModify : this.colorUnstaged);
                    break;
                }
                case DELETE: {
                    treeItem.setForeground(this.colorStagedUnchanged);
                }
            }
        }
        if (this.ignoredFiles.containsKey(absolutePath)) {
            treeItem.setForeground(this.colorIgnored);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20000-GitInfo", label="i18n::GitGuiPlugin.Menu.Info.Text", image="git-info.svg", separator=true)
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20100-GitInfo", toolTip="i18n::GitGuiPlugin.Toolbar.Info.Tooltip", image="git-info.svg", separator=true)
    public void showGitInfo() {
        if (git == null) {
            return;
        }
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        if (explorerPerspective == null) {
            return;
        }
        ExplorerFile activeFile = explorerPerspective.getSelectedFile();
        if (activeFile == null) {
            activeFile = new ExplorerFile();
            activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Project.Label", (String[])new String[0]));
            activeFile.setFilename(git.getDirectory());
        }
        activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Info.Label", (String[])new String[]{activeFile.getName()}));
        GitInfoExplorerFileType fileType = new GitInfoExplorerFileType();
        activeFile.setFileType((IHopFileType)fileType);
        GitInfoExplorerFileTypeHandler fileTypeHandler = fileType.createFileTypeHandler(HopGui.getInstance(), explorerPerspective, activeFile);
        explorerPerspective.addFile((IExplorerFileTypeHandler)fileTypeHandler);
    }

    public UIGit getGit() {
        return git;
    }

    private static ToolItem getGitToolItem() {
        return HopGui.getInstance().getStatusToolbarWidgets().findToolItem(ID_TOOLBAR_ITEM_GIT);
    }

    private void setBranchLabel(String branch) {
        ToolItem item = GitGuiPlugin.getGitToolItem();
        if (item != null && !item.isDisposed()) {
            HopGui.getInstance().getStatusToolbarWidgets().setToolbarItemText(ID_TOOLBAR_ITEM_GIT, Const.NVL((String)branch, (String)""));
        }
    }

    @Generated
    public Map<String, UIFile> getChangedFiles() {
        return this.changedFiles;
    }

    @Generated
    public Map<String, String> getIgnoredFiles() {
        return this.ignoredFiles;
    }
}

