/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.changefileencoding;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.changefileencoding.ChangeFileEncodingMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ChangeFileEncodingDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ChangeFileEncodingDialog.class;
    private CCombo wFileName;
    private CCombo wTargetFileName;
    private ComboVar wTargetEncoding;
    private ComboVar wSourceEncoding;
    private Button wSourceAddResult;
    private Button wTargetAddResult;
    private Button wCreateParentFolder;
    private final ChangeFileEncodingMeta input;
    private boolean gotPreviousFields = false;

    public ChangeFileEncodingDialog(Shell parent, IVariables variables, ChangeFileEncodingMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wSourceFileGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSourceFileGroup);
        wSourceFileGroup.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.Group.SourceFileGroup.Label", (String[])new String[0]));
        FormLayout sourceFilegroupLayout = new FormLayout();
        sourceFilegroupLayout.marginWidth = 10;
        sourceFilegroupLayout.marginHeight = 10;
        wSourceFileGroup.setLayout((Layout)sourceFilegroupLayout);
        Label wlFileName = new Label((Composite)wSourceFileGroup, 131072);
        wlFileName.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.FileName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileName);
        FormData fdlFileName = new FormData();
        fdlFileName.left = new FormAttachment(0, 0);
        fdlFileName.right = new FormAttachment(middle, -margin);
        fdlFileName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFileName.setLayoutData((Object)fdlFileName);
        this.wFileName = new CCombo((Composite)wSourceFileGroup, 2056);
        this.wFileName.setEditable(true);
        PropsUi.setLook((Widget)this.wFileName);
        this.wFileName.addModifyListener(lsMod);
        FormData fdfileName = new FormData();
        fdfileName.left = new FormAttachment(middle, 0);
        fdfileName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdfileName.right = new FormAttachment(100, -margin);
        this.wFileName.setLayoutData((Object)fdfileName);
        this.wFileName.addListener(15, e -> this.get());
        Label wlSourceEncoding = new Label((Composite)wSourceFileGroup, 131072);
        wlSourceEncoding.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.SourceEncoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSourceEncoding);
        FormData fdlSourceEncoding = new FormData();
        fdlSourceEncoding.left = new FormAttachment(0, 0);
        fdlSourceEncoding.top = new FormAttachment((Control)this.wFileName, margin);
        fdlSourceEncoding.right = new FormAttachment(middle, -margin);
        wlSourceEncoding.setLayoutData((Object)fdlSourceEncoding);
        this.wSourceEncoding = new ComboVar(this.variables, (Composite)wSourceFileGroup, 2056);
        this.wSourceEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wSourceEncoding);
        this.wSourceEncoding.addModifyListener(lsMod);
        FormData fdSourceEncoding = new FormData();
        fdSourceEncoding.left = new FormAttachment(middle, 0);
        fdSourceEncoding.top = new FormAttachment((Control)this.wFileName, margin);
        fdSourceEncoding.right = new FormAttachment(100, 0);
        this.wSourceEncoding.setLayoutData((Object)fdSourceEncoding);
        this.wSourceEncoding.addListener(15, e -> this.setEncodings(this.wSourceEncoding));
        Label wlSourceAddResult = new Label((Composite)wSourceFileGroup, 131072);
        wlSourceAddResult.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.AddSourceResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSourceAddResult);
        FormData fdlSourceAddResult = new FormData();
        fdlSourceAddResult.left = new FormAttachment(0, 0);
        fdlSourceAddResult.top = new FormAttachment((Control)this.wSourceEncoding, margin);
        fdlSourceAddResult.right = new FormAttachment(middle, -margin);
        wlSourceAddResult.setLayoutData((Object)fdlSourceAddResult);
        this.wSourceAddResult = new Button((Composite)wSourceFileGroup, 32);
        PropsUi.setLook((Widget)this.wSourceAddResult);
        this.wSourceAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.AddSourceResult.Tooltip", (String[])new String[0]));
        FormData fdSourceAddResult = new FormData();
        fdSourceAddResult.left = new FormAttachment(middle, 0);
        fdSourceAddResult.top = new FormAttachment((Control)wlSourceAddResult, 0, 0x1000000);
        this.wSourceAddResult.setLayoutData((Object)fdSourceAddResult);
        this.wSourceAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        FormData fdSourceFileGroup = new FormData();
        fdSourceFileGroup.left = new FormAttachment(0, margin);
        fdSourceFileGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSourceFileGroup.right = new FormAttachment(100, -margin);
        wSourceFileGroup.setLayoutData((Object)fdSourceFileGroup);
        Group wTargetFileGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wTargetFileGroup);
        wTargetFileGroup.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.Group.TargetFileGroup.Label", (String[])new String[0]));
        FormLayout targetFilegroupLayout = new FormLayout();
        targetFilegroupLayout.marginWidth = 10;
        targetFilegroupLayout.marginHeight = 10;
        wTargetFileGroup.setLayout((Layout)targetFilegroupLayout);
        Label wlTargetFileName = new Label((Composite)wTargetFileGroup, 131072);
        wlTargetFileName.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.TargetFileName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetFileName);
        FormData fdlTargetFileName = new FormData();
        fdlTargetFileName.left = new FormAttachment(0, 0);
        fdlTargetFileName.right = new FormAttachment(middle, -margin);
        fdlTargetFileName.top = new FormAttachment((Control)this.wSourceEncoding, margin);
        wlTargetFileName.setLayoutData((Object)fdlTargetFileName);
        this.wTargetFileName = new CCombo((Composite)wTargetFileGroup, 2056);
        this.wTargetFileName.setEditable(true);
        PropsUi.setLook((Widget)this.wTargetFileName);
        this.wTargetFileName.addModifyListener(lsMod);
        FormData fdTargetFileName = new FormData();
        fdTargetFileName.left = new FormAttachment(middle, 0);
        fdTargetFileName.top = new FormAttachment((Control)this.wSourceEncoding, margin);
        fdTargetFileName.right = new FormAttachment(100, -margin);
        this.wTargetFileName.setLayoutData((Object)fdTargetFileName);
        this.wTargetFileName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ChangeFileEncodingDialog.this.get();
            }
        });
        Label wlCreateParentFolder = new Label((Composite)wTargetFileGroup, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.CreateParentFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wTargetFileName, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wTargetFileGroup, 32);
        PropsUi.setLook((Widget)this.wCreateParentFolder);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)wlCreateParentFolder, 0, 0x1000000);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlTargetEncoding = new Label((Composite)wTargetFileGroup, 131072);
        wlTargetEncoding.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.TargetEncoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetEncoding);
        FormData fdlTargetEncoding = new FormData();
        fdlTargetEncoding.left = new FormAttachment(0, 0);
        fdlTargetEncoding.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlTargetEncoding.right = new FormAttachment(middle, -margin);
        wlTargetEncoding.setLayoutData((Object)fdlTargetEncoding);
        this.wTargetEncoding = new ComboVar(this.variables, (Composite)wTargetFileGroup, 2056);
        this.wTargetEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wTargetEncoding);
        this.wTargetEncoding.addModifyListener(lsMod);
        FormData fdTargetEncoding = new FormData();
        fdTargetEncoding.left = new FormAttachment(middle, 0);
        fdTargetEncoding.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdTargetEncoding.right = new FormAttachment(100, 0);
        this.wTargetEncoding.setLayoutData((Object)fdTargetEncoding);
        this.wTargetEncoding.addListener(15, e -> this.setEncodings(this.wTargetEncoding));
        Label wlTargetAddResult = new Label((Composite)wTargetFileGroup, 131072);
        wlTargetAddResult.setText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.AddTargetResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetAddResult);
        FormData fdlTargetAddResult = new FormData();
        fdlTargetAddResult.left = new FormAttachment(0, 0);
        fdlTargetAddResult.top = new FormAttachment((Control)this.wTargetEncoding, margin);
        fdlTargetAddResult.right = new FormAttachment(middle, -margin);
        wlTargetAddResult.setLayoutData((Object)fdlTargetAddResult);
        this.wTargetAddResult = new Button((Composite)wTargetFileGroup, 32);
        PropsUi.setLook((Widget)this.wTargetAddResult);
        this.wTargetAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.AddTargetResult.Tooltip", (String[])new String[0]));
        FormData fdTargetAddResult = new FormData();
        fdTargetAddResult.left = new FormAttachment(middle, 0);
        fdTargetAddResult.top = new FormAttachment((Control)wlTargetAddResult, 0, 0x1000000);
        this.wTargetAddResult.setLayoutData((Object)fdTargetAddResult);
        this.wTargetAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        FormData fdTargetFileGroup = new FormData();
        fdTargetFileGroup.left = new FormAttachment(0, margin);
        fdTargetFileGroup.top = new FormAttachment((Control)wSourceFileGroup, margin);
        fdTargetFileGroup.right = new FormAttachment(100, -margin);
        fdTargetFileGroup.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTargetFileGroup.setLayoutData((Object)fdTargetFileGroup);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFilenameField() != null) {
            this.wFileName.setText(this.input.getFilenameField());
        }
        if (this.input.getTargetFilenameField() != null) {
            this.wTargetFileName.setText(this.input.getTargetFilenameField());
        }
        if (this.input.getTargetEncoding() != null) {
            this.wTargetEncoding.setText(this.input.getTargetEncoding());
        }
        if (this.input.getSourceEncoding() != null) {
            this.wSourceEncoding.setText(this.input.getSourceEncoding());
        }
        this.wSourceAddResult.setSelection(this.input.isAddSourceResultFilenames());
        this.wTargetAddResult.setSelection(this.input.isAddTargetResultFilenames());
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setFilenameField(this.wFileName.getText());
        this.input.setTargetFilenameField(this.wTargetFileName.getText());
        this.input.setSourceEncoding(this.wSourceEncoding.getText());
        this.input.setTargetEncoding(this.wTargetEncoding.getText());
        this.input.setAddSourceResultFilenames(this.wSourceAddResult.getSelection());
        this.input.setAddTargetResultFilenames(this.wTargetAddResult.getSelection());
        this.input.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String filefield = this.wFileName.getText();
                String targetfilefield = this.wTargetFileName.getText();
                this.wFileName.removeAll();
                this.wTargetFileName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFileName.setItems(r.getFieldNames());
                    this.wTargetFileName.setItems(r.getFieldNames());
                }
                if (filefield != null) {
                    this.wFileName.setText(filefield);
                }
                if (targetfilefield != null) {
                    this.wTargetFileName.setText(targetfilefield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ChangeFileEncodingDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void setEncodings(ComboVar cVar) {
        String encoding = Const.NVL((String)cVar.getText(), (String)Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8"));
        cVar.removeAll();
        ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
        for (Charset charSet : values) {
            cVar.add(charSet.displayName());
        }
        int idx = Const.indexOfString((String)encoding, (String[])cVar.getItems());
        if (idx >= 0) {
            cVar.select(idx);
        }
    }
}

