/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.UploadIdResponseInterceptor;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Transport {
    public static @UnknownKeyFor @NonNull @Initialized HttpTransport getTransport() {
        return SingletonHelper.HTTP_TRANSPORT;
    }

    public static @UnknownKeyFor @NonNull @Initialized JsonFactory getJsonFactory() {
        return SingletonHelper.JSON_FACTORY;
    }

    private static @UnknownKeyFor @NonNull @Initialized ApiComponents apiComponentsFromUrl(@UnknownKeyFor @NonNull @Initialized String urlString) {
        try {
            URL url = new URL(urlString);
            String rootUrl = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            return new ApiComponents(rootUrl, url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + urlString);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Storage.Builder newStorageClient(@UnknownKeyFor @NonNull @Initialized GcsOptions options) {
        String applicationName = String.format("%sapache-beam/%s (GPN:Beam)", Strings.isNullOrEmpty((String)options.getAppName()) ? "" : options.getAppName() + " ", ReleaseInfo.getReleaseInfo().getSdkVersion());
        String servicePath = options.getGcsEndpoint();
        Storage.Builder storageBuilder = new Storage.Builder(Transport.getTransport(), Transport.getJsonFactory(), Transport.httpRequestInitializerFromOptions(options)).setApplicationName(applicationName).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
        if (servicePath != null) {
            ApiComponents components = Transport.apiComponentsFromUrl(servicePath);
            storageBuilder.setRootUrl(components.rootUrl);
            storageBuilder.setServicePath(components.servicePath);
            storageBuilder.setBatchPath(Paths.get("batch/", components.servicePath).toString());
        }
        return storageBuilder;
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializerFromOptions(@UnknownKeyFor @NonNull @Initialized GcsOptions options) {
        Credentials credential;
        Integer writeTimeout;
        RetryHttpRequestInitializer retryHttpRequestInitializer = new RetryHttpRequestInitializer((Collection<Integer>)ImmutableList.of((Object)404), new UploadIdResponseInterceptor());
        String jobName = Optional.ofNullable(options.getJobName()).orElse("UNKNOWN");
        ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)GcsOptions.GcsCustomAuditEntries.CUSTOM_AUDIT_JOB_ENTRY_KEY, (Object)jobName);
        GcsOptions.GcsCustomAuditEntries customAuditEntries = options.getGcsCustomAuditEntries();
        if (customAuditEntries != null && customAuditEntries.size() > 0) {
            builder.putAll((Map)customAuditEntries);
        }
        retryHttpRequestInitializer.setHttpHeaders((Map<String, String>)builder.buildKeepingLast());
        Integer readTimeout = options.getGcsHttpRequestReadTimeout();
        if (readTimeout != null) {
            retryHttpRequestInitializer.setReadTimeout(readTimeout);
        }
        if ((writeTimeout = options.getGcsHttpRequestWriteTimeout()) != null) {
            retryHttpRequestInitializer.setWriteTimeout(writeTimeout);
        }
        if ((credential = options.getGcpCredential()) == null) {
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), retryHttpRequestInitializer});
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), retryHttpRequestInitializer});
    }

    private static class ApiComponents {
        public @UnknownKeyFor @NonNull @Initialized String rootUrl;
        public @UnknownKeyFor @NonNull @Initialized String servicePath;

        public ApiComponents(@UnknownKeyFor @NonNull @Initialized String root, @UnknownKeyFor @NonNull @Initialized String path) {
            this.rootUrl = root;
            this.servicePath = path;
        }
    }

    private static class SingletonHelper {
        private static final @UnknownKeyFor @NonNull @Initialized JsonFactory JSON_FACTORY;
        private static final @UnknownKeyFor @NonNull @Initialized HttpTransport HTTP_TRANSPORT;

        private SingletonHelper() {
        }

        static {
            try {
                JSON_FACTORY = GsonFactory.getDefaultInstance();
                HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

