/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkfilelocked;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.checkfilelocked.LockFile;

@Action(id="CHECK_FILES_LOCKED", name="i18n::ActionCheckFilesLocked.Name", description="i18n::ActionCheckFilesLocked.Description", image="CheckFilesLocked.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionCheckFilesLocked.keyword"}, documentationUrl="/workflow/actions/checkfilelocked.html")
public class ActionCheckFilesLocked
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCheckFilesLocked.class;
    @HopMetadataProperty(key="arg_from_previous")
    private boolean argFromPrevious = false;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includeSubfolders = false;
    @HopMetadataProperty(key="field", groupKey="fields")
    private List<CheckedFile> checkedFiles = new ArrayList<CheckedFile>();

    public ActionCheckFilesLocked(String n) {
        super(n, "");
    }

    public ActionCheckFilesLocked() {
        this("");
    }

    public ActionCheckFilesLocked clone() {
        return new ActionCheckFilesLocked(this);
    }

    public ActionCheckFilesLocked(ActionCheckFilesLocked a) {
        this();
        this.argFromPrevious = a.argFromPrevious;
        this.includeSubfolders = a.includeSubfolders;
        for (CheckedFile checkedFile : a.checkedFiles) {
            this.checkedFiles.add(new CheckedFile(checkedFile));
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Result execute(Result previousResult, int nr) {
        List rows = previousResult.getRows();
        boolean oneFileLocked = false;
        previousResult.setResult(true);
        try {
            if (this.argFromPrevious && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (this.argFromPrevious && rows != null) {
                oneFileLocked = this.isOneArgumentsFileLocked(rows);
            } else if (!this.checkedFiles.isEmpty()) {
                oneFileLocked = this.isOneSpecifiedFileLocked();
            } else if (this.isBasic()) {
                this.logBasic("This action didn't execute any locking checks as there were no lines to check and no arguments provided.");
            }
            if (oneFileLocked) {
                previousResult.setResult(false);
                previousResult.setNrErrors(1L);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ErrorRunningAction", (Object[])new Object[]{e}));
        }
        return previousResult;
    }

    private boolean isOneSpecifiedFileLocked() {
        boolean oneFileLocked = false;
        for (int i = 0; i < this.checkedFiles.size() && !this.parentWorkflow.isStopped() && !oneFileLocked; ++i) {
            CheckedFile checkedFile = this.checkedFiles.get(i);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingArg", (String[])new String[]{checkedFile.getName(), checkedFile.getWildcard()}));
            }
            oneFileLocked = this.processCheckedFilesLine(checkedFile.getName(), checkedFile.getWildcard());
        }
        return oneFileLocked;
    }

    private boolean isOneArgumentsFileLocked(List<RowMetaAndData> rows) throws HopValueException {
        boolean oneFileLocked = false;
        for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped() && !oneFileLocked; ++iteration) {
            RowMetaAndData resultRow = rows.get(iteration);
            String fileFolderPrevious = resultRow.getString(0, "");
            String fileMasksPrevious = resultRow.getString(1, "");
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingRow", (String[])new String[]{fileFolderPrevious, fileMasksPrevious}));
            }
            oneFileLocked = this.processCheckedFilesLine(fileFolderPrevious, fileMasksPrevious);
        }
        return oneFileLocked;
    }

    private boolean processCheckedFilesLine(String name, String wildcard) {
        boolean locked = false;
        String realFileFolderName = this.resolve(name);
        String realWildcard = this.resolve(wildcard);
        try (FileObject fileFolder = HopVfs.getFileObject((String)realFileFolderName, (IVariables)this.getVariables());){
            FileObject[] files = new FileObject[]{fileFolder};
            if (fileFolder.exists()) {
                if (fileFolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingFolder", (String[])new String[]{realFileFolderName}));
                    }
                    files = fileFolder.findFiles((FileSelector)new TextFileSelector(fileFolder.toString(), realWildcard));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.TotalFilesToCheck", (String[])new String[]{String.valueOf(files.length)}));
                    }
                } else if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingFile", (String[])new String[]{realFileFolderName}));
                }
                locked = this.checkFilesLocked(files);
            } else if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FileNotExist", (String[])new String[]{realFileFolderName}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.CouldNotProcess", (String[])new String[]{realFileFolderName, e.getMessage()}));
        }
        return locked;
    }

    private boolean checkFilesLocked(FileObject[] files) throws HopException {
        boolean oneFileLocked = false;
        for (int i = 0; i < files.length && !oneFileLocked; ++i) {
            FileObject file = files[i];
            String filename = HopVfs.getFilename((FileObject)file);
            LockFile locked = new LockFile(filename, this.getVariables());
            if (locked.isLocked()) {
                oneFileLocked = true;
                this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Log.FileLocked", (String[])new String[]{filename}));
                continue;
            }
            if (!this.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Log.FileNotLocked", (String[])new String[]{filename}));
        }
        return oneFileLocked;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    public List<CheckedFile> getCheckedFiles() {
        return this.checkedFiles;
    }

    public void setCheckedFiles(List<CheckedFile> checkedFiles) {
        this.checkedFiles = checkedFiles;
    }

    public static class CheckedFile {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="filemask")
        private String wildcard;

        public CheckedFile() {
        }

        public CheckedFile(CheckedFile f) {
            this();
            this.name = f.name;
            this.wildcard = f.wildcard;
        }

        public CheckedFile(String name, String wildcard) {
            this.name = name;
            this.wildcard = wildcard;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getWildcard() {
            return this.wildcard;
        }

        public void setWildcard(String wildcard) {
            this.wildcard = wildcard;
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean includeFile = false;
            try {
                if (info.getFile().toString().equals(this.sourceFolder)) {
                    return false;
                }
                if (ActionCheckFilesLocked.this.isDetailed()) {
                    ActionCheckFilesLocked.this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                }
                String shortFilename = info.getFile().getName().getBaseName();
                includeFile = !info.getFile().getParent().equals(info.getBaseFolder()) ? ActionCheckFilesLocked.this.includeSubfolders && info.getFile().getType() == FileType.FILE && this.getFileWildcard(shortFilename, this.fileWildcard) : info.getFile().getType() == FileType.FILE && this.getFileWildcard(shortFilename, this.fileWildcard);
            }
            catch (Exception e) {
                ActionCheckFilesLocked.this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Error.Exception.ProcessError", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobCheckFilesLocked.Error.Exception.Process", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
            }
            return includeFile;
        }

        private boolean getFileWildcard(String selectedFile, String wildcard) {
            boolean getIt = true;
            if (!Utils.isEmpty((CharSequence)wildcard)) {
                Pattern pattern = Pattern.compile(wildcard);
                Matcher matcher = pattern.matcher(selectedFile);
                getIt = matcher.matches();
            }
            return getIt;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return info.getDepth() == 0 || ActionCheckFilesLocked.this.includeSubfolders;
        }
    }
}

