/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;

@ExtensionPoint(id="ExplorerPerspectiveRoot", description="Set the root folder and name of the current project in the explorer perspective", extensionPointId="HopGuiDetermineExplorerRoot")
public class ExplorerPerspectiveRoot
implements IExtensionPoint<ExplorerPerspective.DetermineRootFolderExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, ExplorerPerspective.DetermineRootFolderExtension ext) throws HopException {
        String projectName = HopNamespace.getNamespace();
        if (StringUtil.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        ext.rootFolder = variables.resolve(projectConfig.getProjectHome());
        ext.rootName = projectName;
    }
}

