/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3.replication;

import com.amazon.redshift.copy.CopyDual;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.replication.LogSequenceNumber;
import com.amazon.redshift.replication.RedshiftReplicationStream;
import com.amazon.redshift.replication.ReplicationType;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class V3RedshiftReplicationStream
implements RedshiftReplicationStream {
    private RedshiftLogger logger;
    public static final long REDSHIFT_EPOCH_2000_01_01 = 946684800000L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private final CopyDual copyDual;
    private final long updateInterval;
    private final ReplicationType replicationType;
    private long lastStatusUpdate;
    private boolean closeFlag = false;
    private LogSequenceNumber lastServerLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastReceiveLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastAppliedLSN = LogSequenceNumber.INVALID_LSN;
    private volatile LogSequenceNumber lastFlushedLSN = LogSequenceNumber.INVALID_LSN;

    public V3RedshiftReplicationStream(CopyDual copyDual, LogSequenceNumber startLSN, long updateIntervalMs, ReplicationType replicationType, RedshiftLogger logger) {
        this.logger = logger;
        this.copyDual = copyDual;
        this.updateInterval = updateIntervalMs * 1000000L;
        this.lastStatusUpdate = System.nanoTime() - updateIntervalMs * 1000000L;
        this.lastReceiveLSN = startLSN;
        this.replicationType = replicationType;
    }

    @Override
    public ByteBuffer read() throws SQLException {
        this.checkClose();
        ByteBuffer payload = null;
        while (payload == null && this.copyDual.isActive()) {
            payload = this.readInternal(true);
        }
        return payload;
    }

    @Override
    public ByteBuffer readPending() throws SQLException {
        this.checkClose();
        return this.readInternal(false);
    }

    @Override
    public LogSequenceNumber getLastReceiveLSN() {
        return this.lastReceiveLSN;
    }

    @Override
    public LogSequenceNumber getLastFlushedLSN() {
        return this.lastFlushedLSN;
    }

    @Override
    public LogSequenceNumber getLastAppliedLSN() {
        return this.lastAppliedLSN;
    }

    @Override
    public void setFlushedLSN(LogSequenceNumber flushed) {
        this.lastFlushedLSN = flushed;
    }

    @Override
    public void setAppliedLSN(LogSequenceNumber applied) {
        this.lastAppliedLSN = applied;
    }

    @Override
    public void forceUpdateStatus() throws SQLException {
        this.checkClose();
        this.updateStatusInternal(this.lastReceiveLSN, this.lastFlushedLSN, this.lastAppliedLSN, true);
    }

    @Override
    public boolean isClosed() {
        return this.closeFlag || !this.copyDual.isActive();
    }

    private ByteBuffer readInternal(boolean block) throws SQLException {
        boolean updateStatusRequired = false;
        block4: while (this.copyDual.isActive()) {
            ByteBuffer buffer = this.receiveNextData(block);
            if (updateStatusRequired || this.isTimeUpdate()) {
                this.timeUpdateStatus();
            }
            if (buffer == null) {
                return null;
            }
            byte code = buffer.get();
            switch (code) {
                case 107: {
                    updateStatusRequired = this.processKeepAliveMessage(buffer);
                    updateStatusRequired |= this.updateInterval == 0L;
                    continue block4;
                }
                case 119: {
                    return this.processXLogData(buffer);
                }
            }
            throw new RedshiftException(GT.tr("Unexpected packet type during replication: {0}", Integer.toString(code)), RedshiftState.PROTOCOL_VIOLATION);
        }
        return null;
    }

    private ByteBuffer receiveNextData(boolean block) throws SQLException {
        try {
            byte[] message = this.copyDual.readFromCopy(block);
            if (message != null) {
                return ByteBuffer.wrap(message);
            }
            return null;
        }
        catch (RedshiftException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                return null;
            }
            throw e;
        }
    }

    private boolean isTimeUpdate() {
        if (this.updateInterval == 0L) {
            return false;
        }
        long diff = System.nanoTime() - this.lastStatusUpdate;
        return diff >= this.updateInterval;
    }

    private void timeUpdateStatus() throws SQLException {
        this.updateStatusInternal(this.lastReceiveLSN, this.lastFlushedLSN, this.lastAppliedLSN, false);
    }

    private void updateStatusInternal(LogSequenceNumber received, LogSequenceNumber flushed, LogSequenceNumber applied, boolean replyRequired) throws SQLException {
        byte[] reply = this.prepareUpdateStatus(received, flushed, applied, replyRequired);
        this.copyDual.writeToCopy(reply, 0, reply.length);
        this.copyDual.flushCopy();
        this.lastStatusUpdate = System.nanoTime();
    }

    private byte[] prepareUpdateStatus(LogSequenceNumber received, LogSequenceNumber flushed, LogSequenceNumber applied, boolean replyRequired) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(34);
        long now = System.nanoTime() / 1000000L;
        long systemClock = TimeUnit.MICROSECONDS.convert(now - 946684800000L, TimeUnit.MICROSECONDS);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> StandbyStatusUpdate(received: {0}, flushed: {1}, applied: {2}, clock: {3})", received.asString(), flushed.asString(), applied.asString(), new Date(now));
        }
        byteBuffer.put((byte)114);
        byteBuffer.putLong(received.asLong());
        byteBuffer.putLong(flushed.asLong());
        byteBuffer.putLong(applied.asLong());
        byteBuffer.putLong(systemClock);
        if (replyRequired) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put(received == LogSequenceNumber.INVALID_LSN ? (byte)1 : 0);
        }
        this.lastStatusUpdate = now;
        return byteBuffer.array();
    }

    private boolean processKeepAliveMessage(ByteBuffer buffer) {
        boolean replyRequired;
        this.lastServerLSN = LogSequenceNumber.valueOf(buffer.getLong());
        if (this.lastServerLSN.asLong() > this.lastReceiveLSN.asLong()) {
            this.lastReceiveLSN = this.lastServerLSN;
        }
        long lastServerClock = buffer.getLong();
        boolean bl = replyRequired = buffer.get() != 0;
        if (RedshiftLogger.isEnable()) {
            Date clockTime = new Date(TimeUnit.MILLISECONDS.convert(lastServerClock, TimeUnit.MICROSECONDS) + 946684800000L);
            this.logger.log(LogLevel.DEBUG, "  <=BE Keepalive(lastServerWal: {0}, clock: {1} needReply: {2})", this.lastServerLSN.asString(), clockTime, replyRequired);
        }
        return replyRequired;
    }

    private ByteBuffer processXLogData(ByteBuffer buffer) {
        long startLsn = buffer.getLong();
        this.lastServerLSN = LogSequenceNumber.valueOf(buffer.getLong());
        long systemClock = buffer.getLong();
        switch (this.replicationType) {
            case LOGICAL: {
                this.lastReceiveLSN = LogSequenceNumber.valueOf(startLsn);
                break;
            }
            case PHYSICAL: {
                int payloadSize = buffer.limit() - buffer.position();
                this.lastReceiveLSN = LogSequenceNumber.valueOf(startLsn + (long)payloadSize);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  <=BE XLogData(currWal: {0}, lastServerWal: {1}, clock: {2})", this.lastReceiveLSN.asString(), this.lastServerLSN.asString(), systemClock);
        }
        return buffer.slice();
    }

    private void checkClose() throws RedshiftException {
        if (this.isClosed()) {
            throw new RedshiftException(GT.tr("This replication stream has been closed.", new Object[0]), RedshiftState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> StopReplication", new Object[0]);
        }
        this.copyDual.endCopy();
        this.closeFlag = true;
    }
}

